/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.core.JavaCoreBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.impl.LanguageLevelProjectExtensionImpl;
import com.intellij.openapi.roots.ui.configuration.GeneralProjectSettingsElement;
import com.intellij.openapi.roots.ui.configuration.LanguageLevelCombo;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectJdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.project.ProjectKt;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectConfigurable
extends ProjectStructureElementConfigurable<Project>
implements DetailsComponent.Facade {
    private final Project a;
    private LanguageLevelCombo b;
    private ProjectJdkConfigurable f;
    private FieldPanel l;
    private JTextField e;
    private JPanel j;
    private final StructureConfigurableContext g;
    private final ModulesConfigurator h;
    private JPanel k;
    private boolean i = false;
    private DetailsComponent d;
    private final GeneralProjectSettingsElement c;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ProjectConfigurable(Project project2, StructureConfigurableContext structureConfigurableContext, ModulesConfigurator modulesConfigurator, ProjectSdksModel projectSdksModel) {
        this.a = project2;
        this.g = structureConfigurableContext;
        this.h = modulesConfigurator;
        this.c();
        this.c = new GeneralProjectSettingsElement(structureConfigurableContext);
        final ProjectStructureDaemonAnalyzer projectStructureDaemonAnalyzer = structureConfigurableContext.getDaemonAnalyzer();
        this.h.addAllModuleChangeListener(new ModuleEditor.ChangeListener(){

            @Override
            public void moduleStateChanged(ModifiableRootModel modifiableRootModel) {
                projectStructureDaemonAnalyzer.queueUpdate(ProjectConfigurable.this.c);
            }
        });
        this.a(projectSdksModel);
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.c;
    }

    public DetailsComponent getDetailsComponent() {
        return this.d;
    }

    public JComponent createOptionsPanel() {
        this.d = new DetailsComponent(false, false);
        this.d.setContent((JComponent)this.j);
        this.d.setText(new String[]{this.getBannerSlogan()});
        this.f.createComponent();
        return this.d.getComponent();
    }

    private void a(ProjectSdksModel projectSdksModel) {
        this.j = new JPanel(new GridBagLayout());
        this.j.setPreferredSize((Dimension)JBUI.size((int)700, (int)500));
        if (ProjectKt.isDirectoryBased((Project)this.a)) {
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel("<html><body><b>Project name:</b></body></html>", 2);
            jPanel.add((Component)jLabel, "North");
            this.e = new JTextField();
            this.e.setColumns(40);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(Box.createHorizontalStrut(4));
            jPanel2.add(this.e);
            jPanel.add((Component)jPanel2, "Center");
            JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
            jPanel3.add(jPanel);
            jPanel3.setAlignmentX(0.0f);
            this.j.add((Component)jPanel3, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)4, (int)0, (int)10, (int)0), 0, 0));
        }
        this.f = new ProjectJdkConfigurable(this.a, projectSdksModel);
        this.j.add((Component)this.f.createComponent(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insetsTop((int)4), 0, 0));
        this.j.add((Component)this.k, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, (Insets)JBUI.insetsTop((int)4), 0, 0));
        this.j.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.l.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                if (ProjectConfigurable.this.i) {
                    return;
                }
                ProjectConfigurable.this.h.processModuleCompilerOutputChanged(ProjectConfigurable.this.getCompilerOutputUrl());
            }
        });
        this.f.addChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectConfigurable.this.b.sdkUpdated(ProjectConfigurable.this.f.getSelectedProjectJdk(), ProjectConfigurable.this.a.isDefault());
                LanguageLevelProjectExtensionImpl.getInstanceImpl((Project)ProjectConfigurable.this.a).setCurrentLevel(ProjectConfigurable.this.b.getSelectedLevel());
            }
        });
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LanguageLevelProjectExtensionImpl.getInstanceImpl((Project)ProjectConfigurable.this.a).setCurrentLevel(ProjectConfigurable.this.b.getSelectedLevel());
            }
        });
    }

    public void disposeUIResources() {
        try {
            if (this.f != null) {
                this.f.disposeUIResources();
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
    }

    public void reset() {
        this.i = true;
        try {
            this.f.reset();
            String string = this.a();
            try {
                if (string != null) {
                    this.l.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)string)));
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw ProjectConfigurable.a(illegalStateException);
            }
            try {
                this.b.reset(this.a);
                if (this.e != null) {
                    this.e.setText(this.a.getName());
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw ProjectConfigurable.a(illegalStateException);
            }
        }
        finally {
            this.i = false;
        }
        this.g.getDaemonAnalyzer().queueUpdate(this.c);
    }

    public void apply() throws ConfigurationException {
        CompilerProjectExtension compilerProjectExtension;
        block9: {
            block8: {
                compilerProjectExtension = CompilerProjectExtension.getInstance((Project)this.a);
                try {
                    try {
                        if ($assertionsDisabled || compilerProjectExtension != null) break block8;
                    }
                    catch (ConfigurationException configurationException) {
                        throw ProjectConfigurable.a((Exception)((Object)configurationException));
                    }
                    throw new AssertionError(this.a);
                }
                catch (ConfigurationException configurationException) {
                    throw ProjectConfigurable.a((Exception)((Object)configurationException));
                }
            }
            try {
                try {
                    if (this.e == null || !StringUtil.isEmptyOrSpaces((String)this.e.getText())) break block9;
                }
                catch (ConfigurationException configurationException) {
                    throw ProjectConfigurable.a((Exception)((Object)configurationException));
                }
                throw new ConfigurationException("Please, specify project name!");
            }
            catch (ConfigurationException configurationException) {
                throw ProjectConfigurable.a((Exception)((Object)configurationException));
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            block12: {
                block13: {
                    block11: {
                        String string = this.l.getText();
                        try {
                            if (string == null || string.length() <= 0) break block11;
                        }
                        catch (IOException iOException) {
                            throw ProjectConfigurable.a(iOException);
                        }
                        try {
                            string = FileUtil.resolveShortWindowsName((String)string);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        string = FileUtil.toSystemIndependentName((String)string);
                        compilerProjectExtension.setCompilerOutputUrl(VfsUtilCore.pathToUrl((String)string));
                        break block13;
                    }
                    compilerProjectExtension.setCompilerOutputPointer(null);
                }
                LanguageLevelProjectExtension languageLevelProjectExtension = LanguageLevelProjectExtension.getInstance((Project)this.a);
                LanguageLevel languageLevel = this.b.getSelectedLevel();
                try {
                    if (languageLevel != null) {
                        languageLevelProjectExtension.setLanguageLevel(languageLevel);
                    }
                }
                catch (IOException iOException) {
                    throw ProjectConfigurable.a(iOException);
                }
                try {
                    try {
                        languageLevelProjectExtension.setDefault(Boolean.valueOf(this.b.isDefault()));
                        this.f.apply();
                        if (this.e == null) break block12;
                        ((ProjectEx)this.a).setProjectName(this.getProjectName());
                        if (this.d == null) break block12;
                    }
                    catch (IOException iOException) {
                        throw ProjectConfigurable.a(iOException);
                    }
                    this.d.setText(new String[]{this.getBannerSlogan()});
                }
                catch (IOException iOException) {
                    throw ProjectConfigurable.a(iOException);
                }
            }
        });
    }

    public void setDisplayName(String string) {
    }

    public Project getEditableObject() {
        return this.a;
    }

    public String getBannerSlogan() {
        return ProjectBundle.message((String)"project.roots.project.banner.text", (Object[])new Object[]{this.a.getName()});
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"project.roots.project.display.name", (Object[])new Object[0]);
    }

    public Icon getIcon(boolean bl2) {
        return AllIcons.Nodes.Project;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure.general";
    }

    public boolean isModified() {
        block16: {
            LanguageLevelProjectExtension languageLevelProjectExtension = LanguageLevelProjectExtension.getInstance((Project)this.a);
            try {
                block15: {
                    try {
                        try {
                            if (languageLevelProjectExtension.isDefault() != this.b.isDefault()) break block15;
                            if (languageLevelProjectExtension.isDefault()) break block16;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw ProjectConfigurable.a(illegalStateException);
                        }
                        if (languageLevelProjectExtension.getLanguageLevel().equals((Object)this.b.getSelectedLevel())) break block16;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw ProjectConfigurable.a(illegalStateException);
                    }
                }
                return true;
            }
            catch (IllegalStateException illegalStateException) {
                throw ProjectConfigurable.a(illegalStateException);
            }
        }
        String string = this.a();
        try {
            if (!Comparing.strEqual((String)FileUtil.toSystemIndependentName((String)VfsUtilCore.urlToPath((String)string)), (String)FileUtil.toSystemIndependentName((String)this.l.getText()))) {
                return true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
        try {
            if (this.f.isModified()) {
                return true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
        try {
            if (!this.getProjectName().equals(this.a.getName())) {
                return true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
        return false;
    }

    @NotNull
    public String getProjectName() {
        String string;
        String string2;
        try {
            string2 = this.e != null ? this.e.getText().trim() : this.a.getName();
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
        try {
            string = string2;
            if (string2 == null) {
                ProjectConfigurable.a(0);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
        return string;
    }

    @Nullable
    private String a() {
        String string;
        CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)this.a);
        try {
            string = compilerProjectExtension != null ? compilerProjectExtension.getCompilerOutputUrl() : null;
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
        return string;
    }

    private void b() {
        this.b = new LanguageLevelCombo(JavaCoreBundle.message((String)"default.language.level.description", (Object[])new Object[0])){

            @Override
            protected LanguageLevel getDefaultLevel() {
                Sdk sdk = ProjectConfigurable.this.f.getSelectedProjectJdk();
                if (sdk == null) {
                    return null;
                }
                JavaSdkVersion javaSdkVersion = JavaSdk.getInstance().getVersion(sdk);
                return javaSdkVersion == null ? null : javaSdkVersion.getMaxLanguageLevel();
            }
        };
        ExtendableTextField extendableTextField = new ExtendableTextField();
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        InsertPathAction.addTo((JTextComponent)extendableTextField, (FileChooserDescriptor)fileChooserDescriptor);
        fileChooserDescriptor.setHideIgnored(false);
        BrowseFilesListener browseFilesListener = new BrowseFilesListener((JTextField)extendableTextField, "", ProjectBundle.message((String)"project.compiler.output", (Object[])new Object[0]), fileChooserDescriptor);
        this.l = new FieldPanel((JTextField)extendableTextField, null, null, (ActionListener)browseFilesListener, EmptyRunnable.getInstance());
        FileChooserFactory.getInstance().installFileCompletion(this.l.getTextField(), fileChooserDescriptor, true, null);
    }

    public String getCompilerOutputUrl() {
        return VfsUtilCore.pathToUrl((String)this.l.getText().trim());
    }

    static {
        boolean bl2;
        try {
            bl2 = !ProjectConfigurable.class.desiredAssertionStatus();
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
        $assertionsDisabled = bl2;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/ProjectConfigurable", "getProjectName"));
    }

    private /* synthetic */ void c() {
        JPanel jPanel;
        this.b();
        this.k = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, 5, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.a(jLabel, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.language.level"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        LanguageLevelCombo languageLevelCombo = this.b;
        jPanel2.add((Component)((Object)languageLevelCombo), new GridConstraints(0, 0, 1, 1, 8, 0, 7, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.a(jLabel2, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.compiler.output"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 6, 0, null, null, null));
        FieldPanel fieldPanel = this.l;
        jPanel3.add((Component)fieldPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.k;
    }

    private /* synthetic */ void a(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c2 = '\u0000';
        int n2 = -1;
        int n3 = 0;
        while (true) {
            block13: {
                try {
                    try {
                        try {
                            if (n3 >= string.length()) break;
                            if (string.charAt(n3) != '&') break block13;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw ProjectConfigurable.a(illegalStateException);
                        }
                        if (++n3 == string.length()) {
                            break;
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw ProjectConfigurable.a(illegalStateException);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw ProjectConfigurable.a(illegalStateException);
                }
                try {
                    if (bl2 || string.charAt(n3) == '&') break block13;
                }
                catch (IllegalStateException illegalStateException) {
                    throw ProjectConfigurable.a(illegalStateException);
                }
                bl2 = true;
                c2 = string.charAt(n3);
                n2 = stringBuffer.length();
            }
            stringBuffer.append(string.charAt(n3));
            ++n3;
        }
        try {
            jLabel.setText(stringBuffer.toString());
            if (bl2) {
                jLabel.setDisplayedMnemonic(c2);
                jLabel.setDisplayedMnemonicIndex(n2);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

