/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.IconUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ProjectJdksConfigurable
extends MasterDetailsComponent {
    private final ProjectSdksModel a;
    private final Project b;

    public ProjectJdksConfigurable(Project project2) {
        this(project2, ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel());
    }

    public ProjectJdksConfigurable(Project project2, ProjectSdksModel projectSdksModel) {
        this.b = project2;
        this.a = projectSdksModel;
        this.initTree();
        this.myToReInitWholePanel = true;
        this.reInitWholePanelIfNeeded();
    }

    protected String getComponentStateKey() {
        return "ProjectJDKs.UI";
    }

    protected MasterDetailsStateService getStateService() {
        return MasterDetailsStateService.getInstance((Project)this.b);
    }

    protected void initTree() {
        super.initTree();
        new TreeSpeedSearch(this.myTree, treePath -> ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getDisplayName(), true);
        this.myTree.setRootVisible(false);
    }

    public void reset() {
        super.reset();
        this.a.reset(this.b);
        this.myRoot.removeAllChildren();
        HashMap hashMap = this.a.getProjectSdks();
        for (Sdk sdk : hashMap.keySet()) {
            JdkConfigurable jdkConfigurable = new JdkConfigurable((ProjectJdkImpl)hashMap.get(sdk), this.a, this.TREE_UPDATER, this.myHistory, this.b);
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)jdkConfigurable), this.myRoot);
        }
        this.selectJdk(this.a.getProjectSdk());
        JBSplitter jBSplitter = this.a();
        if (jBSplitter != null) {
            jBSplitter.setAndLoadSplitterProportionKey("project.jdk.splitter");
        }
    }

    @Nullable
    private JBSplitter a() {
        Component[] componentArray = this.myWholePanel.getComponents();
        return componentArray.length == 1 && componentArray[0] instanceof JBSplitter ? (JBSplitter)componentArray[0] : null;
    }

    /*
     * Unable to fully structure code
     */
    public void apply() throws ConfigurationException {
        var1_1 = Ref.create();
        try {
            block10: {
                super.apply();
                var2_2 = false;
                for (var3_4 = 0; var3_4 < this.myRoot.getChildCount(); ++var3_4) {
                    var4_5 = ((MasterDetailsComponent.MyNode)this.myRoot.getChildAt(var3_4)).getConfigurable();
                    if (!var4_5.isModified()) continue;
                    var4_5.apply();
                    var2_2 = true;
                }
                if (this.a.isModified()) ** GOTO lbl18
                try {
                    block11: {
                        if (!var2_2) break block10;
                        break block11;
                        catch (ConfigurationException v0) {
                            throw ProjectJdksConfigurable.b(v0);
                        }
                    }
                    this.a.apply((MasterDetailsComponent)this);
                }
                catch (ConfigurationException v1) {
                    throw ProjectJdksConfigurable.b(v1);
                }
            }
            this.a.setProjectSdk(this.getSelectedJdk());
        }
        catch (ConfigurationException var2_3) {
            var1_1.set((Object)var2_3);
        }
        try {
            if (!var1_1.isNull()) {
                throw (ConfigurationException)var1_1.get();
            }
        }
        catch (ConfigurationException v2) {
            throw ProjectJdksConfigurable.b(v2);
        }
    }

    public boolean isModified() {
        return super.isModified() || this.a.isModified();
    }

    public void disposeUIResources() {
        this.a.disposeUIResources();
        super.disposeUIResources();
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean bl2) {
        if (this.a == null) {
            return null;
        }
        ArrayList<AnAction> arrayList = new ArrayList<AnAction>();
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(ProjectBundle.message((String)"add.new.jdk.text", (Object[])new Object[0]), true);
        defaultActionGroup.getTemplatePresentation().setIcon(IconUtil.getAddIcon());
        this.a.createAddActions(defaultActionGroup, (JComponent)this.myTree, sdk -> {
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)new JdkConfigurable((ProjectJdkImpl)sdk, this.a, this.TREE_UPDATER, this.myHistory, this.b), false), this.myRoot);
            this.selectNodeInTree((DefaultMutableTreeNode)ProjectJdksConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)sdk));
        });
        arrayList.add((AnAction)new MasterDetailsComponent.MyActionGroupWrapper((MasterDetailsComponent)this, (ActionGroup)defaultActionGroup));
        arrayList.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this, Conditions.alwaysTrue()));
        return arrayList;
    }

    protected void processRemovedItems() {
        HashSet<Sdk> hashSet = new HashSet<Sdk>();
        for (int i2 = 0; i2 < this.myRoot.getChildCount(); ++i2) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.myRoot.getChildAt(i2);
            NamedConfigurable namedConfigurable = (NamedConfigurable)defaultMutableTreeNode.getUserObject();
            hashSet.add(((JdkConfigurable)namedConfigurable).getEditableObject());
        }
        HashMap hashMap = new HashMap(this.a.getProjectSdks());
        for (NamedConfigurable namedConfigurable : hashMap.values()) {
            if (hashSet.contains(namedConfigurable)) continue;
            this.a.removeSdk((Sdk)namedConfigurable);
        }
    }

    protected boolean wasObjectStored(Object object) {
        return this.a.getProjectSdks().containsKey((Sdk)object);
    }

    @Nullable
    public Sdk getSelectedJdk() {
        return (Sdk)this.getSelectedObject();
    }

    public void selectJdk(Sdk sdk) {
        this.selectNodeInTree(sdk);
    }

    @Nullable
    public String getDisplayName() {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    protected String getEmptySelectionString() {
        return "Select an SDK to view or edit its details here";
    }

    public void selectJdkVersion(JavaSdkVersion javaSdkVersion) {
        for (Sdk sdk : this.a.getSdks()) {
            if (!JavaSdk.getInstance().isOfVersionOrHigher(sdk, javaSdkVersion)) continue;
            this.selectJdk(sdk);
            break;
        }
    }

    private static ConfigurationException b(ConfigurationException configurationException) {
        return configurationException;
    }
}

