/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.ide.projectWizard.NewProjectWizard;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class NewModuleAction
extends AnAction
implements DumbAware {
    public NewModuleAction() {
        super(ProjectBundle.message((String)"module.new.action", (Object[])new Object[0]), ProjectBundle.message((String)"module.new.action.description", (Object[])new Object[0]), null);
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        NewProjectWizard newProjectWizard;
        Project project2 = NewModuleAction.getEventProject((AnActionEvent)anActionEvent);
        if (project2 == null) {
            return;
        }
        Object object = this.prepareDataFromContext(anActionEvent);
        String string = null;
        VirtualFile virtualFile = (VirtualFile)anActionEvent.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile != null && virtualFile.isDirectory()) {
            string = virtualFile.getPath();
        }
        if ((newProjectWizard = new NewProjectWizard(project2, (ModulesProvider)new DefaultModulesProvider(project2), string)).showAndGet()) {
            this.createModuleFromWizard(project2, object, newProjectWizard);
        }
    }

    @Nullable
    public Module createModuleFromWizard(Project project2, @Nullable Object object, AbstractProjectWizard abstractProjectWizard) {
        ProjectBuilder projectBuilder = abstractProjectWizard.getBuilder(project2);
        if (projectBuilder == null) {
            return null;
        }
        if (projectBuilder instanceof ModuleBuilder) {
            Module module2 = ((ModuleBuilder)projectBuilder).commitModule(project2, null);
            if (module2 != null) {
                this.processCreatedModule(module2, object);
            }
            return module2;
        }
        List list = projectBuilder.commit(project2, null, (ModulesProvider)new DefaultModulesProvider(project2));
        if (projectBuilder.isOpenProjectSettingsAfter()) {
            ModulesConfigurator.showDialog(project2, null, null);
        }
        Module module3 = list == null || list.isEmpty() ? null : (Module)list.get(0);
        project2.save();
        return module3;
    }

    @Nullable
    protected Object prepareDataFromContext(AnActionEvent anActionEvent) {
        return null;
    }

    protected void processCreatedModule(Module module2, @Nullable Object object) {
    }

    public void update(AnActionEvent anActionEvent) {
        super.update(anActionEvent);
        anActionEvent.getPresentation().setEnabled(NewModuleAction.getEventProject((AnActionEvent)anActionEvent) != null);
    }
}

