/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactErrorPanel;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProblemDescription;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolderImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.packaging.elements.PackagingElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ArtifactValidationManagerImpl
implements Disposable {
    private final ArtifactErrorPanel a;
    private final ArtifactEditorImpl b;
    private final MultiValuesMap<PackagingElementNode<?>, ArtifactProblemDescription> d = new MultiValuesMap(true);
    private final List<ArtifactProblemDescription> c = new ArrayList<ArtifactProblemDescription>();

    ArtifactValidationManagerImpl(ArtifactEditorImpl artifactEditorImpl) {
        Disposer.register((Disposable)artifactEditorImpl, (Disposable)this);
        this.b = artifactEditorImpl;
        this.a = new ArtifactErrorPanel(artifactEditorImpl);
    }

    public void dispose() {
    }

    public JComponent getMainErrorPanel() {
        return this.a.getMainPanel();
    }

    public void onNodesAdded() {
        for (ArtifactProblemDescription artifactProblemDescription : this.c) {
            this.a(artifactProblemDescription);
        }
    }

    @Nullable
    public Collection<ArtifactProblemDescription> getProblems(PackagingElementNode<?> packagingElementNode) {
        return this.d.get(packagingElementNode);
    }

    public void updateProblems(@Nullable ProjectStructureProblemsHolderImpl projectStructureProblemsHolderImpl) {
        List<ProjectStructureProblemDescription> list;
        this.a.clearError();
        this.d.clear();
        this.c.clear();
        if (projectStructureProblemsHolderImpl != null && (list = projectStructureProblemsHolderImpl.getProblemDescriptions()) != null) {
            for (ProjectStructureProblemDescription projectStructureProblemDescription : list) {
                String string = projectStructureProblemDescription.getMessage(false);
                List<Object> list2 = Collections.emptyList();
                if (projectStructureProblemDescription instanceof ArtifactProblemDescription) {
                    ArtifactProblemDescription artifactProblemDescription = (ArtifactProblemDescription)projectStructureProblemDescription;
                    list2 = artifactProblemDescription.getFixes();
                    if (artifactProblemDescription.getPathToPlace() != null) {
                        this.c.add(artifactProblemDescription);
                        this.a(artifactProblemDescription);
                    }
                }
                this.a.showError(string, projectStructureProblemDescription.getSeverity(), list2);
            }
        }
        this.b.getLayoutTreeComponent().updateTreeNodesPresentation();
    }

    private void a(ArtifactProblemDescription artifactProblemDescription) {
        LayoutTree layoutTree = this.b.getLayoutTreeComponent().getLayoutTree();
        PackagingElementNode<?> packagingElementNode = layoutTree.getRootPackagingNode();
        List<PackagingElement<?>> list = artifactProblemDescription.getPathToPlace();
        if (packagingElementNode != null && list != null) {
            List<PackagingElementNode<?>> list2 = packagingElementNode.getNodesByPath(list.subList(1, list.size()));
            for (PackagingElementNode<?> packagingElementNode2 : list2) {
                this.d.put(packagingElementNode2, (Object)artifactProblemDescription);
            }
        }
    }
}

