/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableItem;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.List;

class LibraryItem
extends ClasspathTableItem<LibraryOrderEntry> {
    private final StructureConfigurableContext b;

    public LibraryItem(LibraryOrderEntry libraryOrderEntry, StructureConfigurableContext structureConfigurableContext) {
        super(libraryOrderEntry, true);
        this.b = structureConfigurableContext;
    }

    @Override
    public boolean isEditable() {
        return this.myEntry != null && ((LibraryOrderEntry)this.myEntry).isValid();
    }

    @Override
    public String getTooltipText() {
        List<String> list;
        if (this.myEntry == null) {
            return null;
        }
        Library library = ((LibraryOrderEntry)this.myEntry).getLibrary();
        if (library == null) {
            return null;
        }
        String string = library.getName();
        if (string != null && !(list = ((LibraryEx)library).getInvalidRootUrls(OrderRootType.CLASSES)).isEmpty()) {
            return ProjectBundle.message((String)"project.roots.tooltip.library.has.broken.paths", (Object[])new Object[]{string, list.size()});
        }
        list = LibraryPresentationManager.getInstance().getDescriptions(library, this.b);
        if (list.isEmpty()) {
            return null;
        }
        return XmlStringUtil.wrapInHtml((CharSequence)StringUtil.join(list, (String)"<br>"));
    }
}

