/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.JavadocQuarantineStatusCleaner;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.IconUtil;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;

public class JavadocOrderRootTypeUIFactory
implements OrderRootTypeUIFactory {
    public SdkPathEditor createPathEditor(Sdk sdk) {
        return new JavadocPathsEditor(sdk, FileChooserDescriptorFactory.createMultipleJavaPathDescriptor());
    }

    public Icon getIcon() {
        return AllIcons.Nodes.JavaDocFolder;
    }

    public String getNodeText() {
        return ProjectBundle.message((String)"library.javadocs.node", (Object[])new Object[0]);
    }

    private static class JavadocPathsEditor
    extends SdkPathEditor {
        private final Sdk a;

        public JavadocPathsEditor(Sdk sdk, FileChooserDescriptor fileChooserDescriptor) {
            super(ProjectBundle.message((String)"sdk.configure.javadoc.tab", (Object[])new Object[0]), JavadocOrderRootType.getInstance(), fileChooserDescriptor);
            this.a = sdk;
        }

        protected void addToolbarButtons(ToolbarDecorator toolbarDecorator) {
            DumbAwareActionButton dumbAwareActionButton = new DumbAwareActionButton(ProjectBundle.message((String)"sdk.paths.specify.url.button", (Object[])new Object[0]), IconUtil.getAddLinkIcon()){

                public void actionPerformed(AnActionEvent anActionEvent) {
                    this.a();
                }
            };
            dumbAwareActionButton.setShortcut((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"alt S"}));
            dumbAwareActionButton.addCustomUpdater(new AnActionButtonUpdater(){

                public boolean isEnabled(AnActionEvent anActionEvent) {
                    return myEnabled;
                }
            });
            toolbarDecorator.addExtraAction((AnActionButton)dumbAwareActionButton);
        }

        private void a() {
            String string = this.a == null ? "" : StringUtil.notNullize((String)((SdkType)this.a.getSdkType()).getDefaultDocumentationUrl(this.a), (String)"");
            VirtualFile virtualFile = Util.showSpecifyJavadocUrlDialog((JComponent)this.myPanel, (String)string);
            if (virtualFile != null) {
                this.addElement(virtualFile);
                this.setModified(true);
                this.requestDefaultFocus();
                this.setSelectedRoots(new Object[]{virtualFile});
            }
        }

        protected VirtualFile[] adjustAddedFileSet(Component component, VirtualFile[] virtualFileArray) {
            JavadocQuarantineStatusCleaner.cleanIfNeeded(virtualFileArray);
            for (int i2 = 0; i2 < virtualFileArray.length; ++i2) {
                VirtualFile virtualFile = virtualFileArray[i2];
                VirtualFile virtualFile2 = null;
                if (virtualFile.getName().equalsIgnoreCase("docs")) {
                    virtualFile2 = virtualFile.findChild("api");
                } else if (virtualFile.getFileSystem() instanceof ArchiveFileSystem && virtualFile.getParent() == null) {
                    virtualFile2 = virtualFile.findFileByRelativePath("docs/api");
                }
                if (virtualFile2 == null) continue;
                virtualFileArray[i2] = virtualFile2;
            }
            return super.adjustAddedFileSet(component, virtualFileArray);
        }
    }
}

