/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ConfigurationError;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ConfigurationErrorQuickFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsSettings;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ProjectConfigurationProblem
extends ConfigurationError {
    private final ProjectStructureProblemDescription d;
    private final Project e;

    public ProjectConfigurationProblem(ProjectStructureProblemDescription projectStructureProblemDescription, Project project2) {
        super(StringUtil.unescapeXml((String)projectStructureProblemDescription.getMessage(true)), ProjectConfigurationProblem.a(projectStructureProblemDescription), ProjectConfigurationProblem.a(project2, projectStructureProblemDescription.getProblemLevel()).isIgnored(projectStructureProblemDescription));
        this.d = projectStructureProblemDescription;
        this.e = project2;
    }

    private static ProjectStructureProblemsSettings a(Project project2, ProjectStructureProblemDescription.ProblemLevel problemLevel) {
        try {
            if (problemLevel == ProjectStructureProblemDescription.ProblemLevel.PROJECT) {
                return ProjectStructureProblemsSettings.getProjectInstance(project2);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurationProblem.c(illegalStateException);
        }
        return ProjectStructureProblemsSettings.getGlobalInstance();
    }

    private static String a(ProjectStructureProblemDescription projectStructureProblemDescription) {
        String string;
        String string2 = projectStructureProblemDescription.getDescription();
        try {
            string = string2 != null ? string2 : projectStructureProblemDescription.getMessage(true);
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurationProblem.c(illegalStateException);
        }
        return string;
    }

    @NotNull
    public ProjectStructureProblemDescription getProblemDescription() {
        ProjectStructureProblemDescription projectStructureProblemDescription;
        try {
            projectStructureProblemDescription = this.d;
            if (projectStructureProblemDescription == null) {
                ProjectConfigurationProblem.b(0);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurationProblem.c(illegalStateException);
        }
        return projectStructureProblemDescription;
    }

    @Override
    public void ignore(boolean bl2) {
        super.ignore(bl2);
        ProjectConfigurationProblem.a(this.e, this.d.getProblemLevel()).setIgnored(this.d, bl2);
    }

    @Override
    public void navigate() {
        this.d.getPlace().navigate();
    }

    @Override
    public boolean canBeFixed() {
        boolean bl2;
        try {
            bl2 = !this.d.getFixes().isEmpty();
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurationProblem.c(illegalStateException);
        }
        return bl2;
    }

    @Override
    public void fix(JComponent jComponent, RelativePoint relativePoint) {
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ConfigurationErrorQuickFix>(null, this.d.getFixes()){

            @NotNull
            public String getTextFor(ConfigurationErrorQuickFix configurationErrorQuickFix) {
                String string;
                try {
                    string = configurationErrorQuickFix.getActionName();
                    if (string == null) {
                        1.a(0);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw 1.b(illegalStateException);
                }
                return string;
            }

            public PopupStep onChosen(ConfigurationErrorQuickFix configurationErrorQuickFix, boolean bl2) {
                return this.doFinalStep(() -> configurationErrorQuickFix.performFix());
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectConfigurationProblem$1", "getTextFor"));
            }

            private static IllegalStateException b(IllegalStateException illegalStateException) {
                return illegalStateException;
            }
        }).show(relativePoint);
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectConfigurationProblem", "getProblemDescription"));
    }

    private static IllegalStateException c(IllegalStateException illegalStateException) {
        return illegalStateException;
    }
}

