/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectStructureValidator {
    private static final ExtensionPointName<ProjectStructureValidator> a = ExtensionPointName.create((String)"com.intellij.projectStructureValidator");

    public static List<ProjectStructureElementUsage> getUsagesInElement(ProjectStructureElement projectStructureElement) {
        for (ProjectStructureValidator projectStructureValidator : (ProjectStructureValidator[])a.getExtensions()) {
            List<ProjectStructureElementUsage> list = projectStructureValidator.getUsagesIn(projectStructureElement);
            if (list == null) continue;
            return list;
        }
        return projectStructureElement.getUsagesInElement();
    }

    public static void check(ProjectStructureElement projectStructureElement, ProjectStructureProblemsHolder projectStructureProblemsHolder) {
        for (ProjectStructureValidator projectStructureValidator : (ProjectStructureValidator[])a.getExtensions()) {
            if (!projectStructureValidator.checkElement(projectStructureElement, projectStructureProblemsHolder)) continue;
            return;
        }
        projectStructureElement.check(projectStructureProblemsHolder);
    }

    public static void showDialogAndAddLibraryToDependencies(Library library, Project project2, boolean bl2) {
        for (ProjectStructureValidator projectStructureValidator : (ProjectStructureValidator[])a.getExtensions()) {
            if (!projectStructureValidator.addLibraryToDependencies(library, project2, bl2)) continue;
            return;
        }
        ModuleStructureConfigurable moduleStructureConfigurable = ModuleStructureConfigurable.getInstance(project2);
        List<Module> list = LibraryEditingUtil.getSuitableModules(moduleStructureConfigurable, (LibraryKind)((LibraryEx)library).getKind(), library);
        if (list.isEmpty()) {
            return;
        }
        ChooseModulesDialog chooseModulesDialog = new ChooseModulesDialog(moduleStructureConfigurable.getProject(), list, ProjectBundle.message((String)"choose.modules.dialog.title", (Object[])new Object[0]), ProjectBundle.message((String)"choose.modules.dialog.description", (Object[])new Object[]{library.getName()}));
        if (chooseModulesDialog.showAndGet()) {
            List list2 = chooseModulesDialog.getChosenElements();
            for (Module module2 : list2) {
                moduleStructureConfigurable.addLibraryOrderEntry(module2, library);
            }
        }
    }

    protected boolean addLibraryToDependencies(Library library, Project project2, boolean bl2) {
        return false;
    }

    protected boolean checkElement(ProjectStructureElement projectStructureElement, ProjectStructureProblemsHolder projectStructureProblemsHolder) {
        return false;
    }

    @Nullable
    protected List<ProjectStructureElementUsage> getUsagesIn(ProjectStructureElement projectStructureElement) {
        return null;
    }
}

