/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.google.common.net.HostAndPort;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ssh.config.ProxyJumpOptions;
import com.intellij.ssh.config.TildeExpandFilenameException;
import com.intellij.util.SystemProperties;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u001a\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0002\u001a\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0000\u001a$\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00022\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00020\u0015H\u0000\u001a\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0002H\u0000\u001a \u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0002H\u0000\u001a\u001e\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f2\u0006\u0010!\u001a\u00020\u0002H\u0000\u001a&\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u0016H\u0000\u001a&\u0010$\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u0016H\u0000\u001a\u0010\u0010%\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002H\u0000\u001a\f\u0010&\u001a\u00020\u0002*\u00020\u000eH\u0000\"\u001e\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"cachedExceptions", "Ljava/util/HashMap;", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "cachedHomes", "homesLock", "Ljava/lang/Object;", "getCachedOrRetrieveUserHome", "username", "getHostName", "getUserHome", "getUserHomeUsingGetentPasswd", "parseJump", "Lcom/intellij/ssh/config/ProxyJumpOptions;", "value", "parseUserHomeFromGetentPasswdOutput", "output", "percentExpand", "pattern", "tokens", "", "", "resolveHostName", "hostName", "host", "resolveIdentityFile", "path", "remoteHost", "remoteUser", "splitHostPort", "Lkotlin/Pair;", "", "hostPort", "splitMinHead", "delimiter", "splitMinTail", "tildeExpandFilename", "toProxyCommand", "ssh"})
@JvmName(name="OpenSSHConfigUtil")
public final class OpenSSHConfigUtil {
    private static final Object b = new Object();
    private static final HashMap<String, String> c = new HashMap();
    private static final HashMap<String, Exception> a = new HashMap();

    @NotNull
    public static final String percentExpand(@NotNull String string, @NotNull Map<Character, String> map) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"pattern");
        Intrinsics.checkParameterIsNotNull(map, (String)"tokens");
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl2 = false;
        CharSequence charSequence2 = charSequence = (CharSequence)string;
        for (int i2 = 0; i2 < charSequence2.length(); ++i2) {
            Pair pair2;
            block19: {
                char c2;
                block21: {
                    block20: {
                        block18: {
                            char c3;
                            c2 = c3 = charSequence2.charAt(i2);
                            try {
                                try {
                                    if (c2 != '%' || bl2) break block18;
                                }
                                catch (TildeExpandFilenameException tildeExpandFilenameException) {
                                    throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
                                }
                                pair2 = TuplesKt.to((Object)"", (Object)true);
                                break block19;
                            }
                            catch (TildeExpandFilenameException tildeExpandFilenameException) {
                                throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
                            }
                        }
                        try {
                            try {
                                if (c2 != '%' || !bl2) break block20;
                            }
                            catch (TildeExpandFilenameException tildeExpandFilenameException) {
                                throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
                            }
                            pair2 = TuplesKt.to((Object)Character.valueOf('%'), (Object)false);
                            break block19;
                        }
                        catch (TildeExpandFilenameException tildeExpandFilenameException) {
                            throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
                        }
                    }
                    try {
                        try {
                            if (!map.containsKey(Character.valueOf(c2)) || !bl2) break block21;
                        }
                        catch (TildeExpandFilenameException tildeExpandFilenameException) {
                            throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
                        }
                        pair2 = TuplesKt.to((Object)map.get(Character.valueOf(c2)), (Object)false);
                        break block19;
                    }
                    catch (TildeExpandFilenameException tildeExpandFilenameException) {
                        throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
                    }
                }
                try {
                    pair2 = bl2 ? TuplesKt.to((Object)("" + '%' + c2), (Object)false) : TuplesKt.to((Object)Character.valueOf(c2), (Object)false);
                }
                catch (TildeExpandFilenameException tildeExpandFilenameException) {
                    throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
                }
            }
            Pair pair3 = pair2;
            Object object = pair3.component1();
            boolean bl3 = (Boolean)pair3.component2();
            stringBuilder.append(object);
            bl2 = bl3;
        }
        try {
            if (bl2) {
                stringBuilder.append('%');
            }
        }
        catch (TildeExpandFilenameException tildeExpandFilenameException) {
            throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"builder.toString()");
        return string2;
    }

    @NotNull
    public static final String resolveHostName(@NotNull String string, @NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"hostName");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"host");
        return OpenSSHConfigUtil.percentExpand(string, MapsKt.mapOf((Pair)TuplesKt.to((Object)Character.valueOf('h'), (Object)string2)));
    }

    @NotNull
    public static final String resolveIdentityFile(@NotNull String string, @NotNull String string2, @NotNull String string3) {
        Map map;
        block0: {
            String string4;
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"remoteHost");
            Intrinsics.checkParameterIsNotNull((Object)string3, (String)"remoteUser");
            String string5 = SystemProperties.getUserHome();
            String string6 = SystemProperties.getUserName();
            String string7 = OpenSSHConfigUtil.a();
            map = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)Character.valueOf('d'), (Object)string5), TuplesKt.to((Object)Character.valueOf('u'), (Object)string6), TuplesKt.to((Object)Character.valueOf('h'), (Object)string2), TuplesKt.to((Object)Character.valueOf('r'), (Object)string3)});
            String string8 = string7;
            if (string8 == null) break block0;
            String string9 = string4 = string8;
            Map map2 = map;
            Character c2 = Character.valueOf('l');
            String string10 = string7;
            map2.put(c2, string10);
        }
        return OpenSSHConfigUtil.percentExpand(OpenSSHConfigUtil.tildeExpandFilename(string), map);
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static final String tildeExpandFilename(@NotNull String string) {
        block12: {
            String string2;
            String string3;
            String string4;
            block16: {
                int n2;
                block15: {
                    int n3;
                    block14: {
                        block13: {
                            Object object;
                            block17: {
                                List list;
                                try {
                                    Intrinsics.checkParameterIsNotNull((Object)string, (String)"path");
                                    list = SystemInfo.isWindows ? CollectionsKt.listOf((Object[])new String[]{"\\", "/"}) : CollectionsKt.listOf((Object)"/");
                                }
                                catch (Exception exception) {
                                    throw OpenSSHConfigUtil.a(exception);
                                }
                                List list2 = list;
                                if (!StringsKt.startsWith$default((String)string, (String)"~", (boolean)false, (int)2, null)) break block12;
                                object = StringsKt.findAnyOf$default((CharSequence)string, (Collection)list2, (int)1, (boolean)false, (int)4, null);
                                if (object == null) break block13;
                                break block17;
                                catch (Exception exception) {
                                    throw OpenSSHConfigUtil.a(exception);
                                }
                            }
                            try {
                                block18: {
                                    if ((object = (Integer)object.getFirst()) == null) break block13;
                                    break block18;
                                    catch (Exception exception) {
                                        throw OpenSSHConfigUtil.a(exception);
                                    }
                                }
                                n3 = (Integer)object;
                                break block14;
                            }
                            catch (Exception exception) {
                                throw OpenSSHConfigUtil.a(exception);
                            }
                        }
                        n3 = string.length();
                    }
                    n2 = n3;
                    string4 = string;
                    String string5 = string4.substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                    string3 = string5;
                    try {
                        if (n2 != 1) break block15;
                        string2 = SystemProperties.getUserHome();
                        break block16;
                    }
                    catch (Exception exception) {
                        throw OpenSSHConfigUtil.a(exception);
                    }
                }
                String string6 = string;
                int n4 = 1;
                String string7 = string6.substring(n4, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string8 = string7;
                try {
                    string6 = OpenSSHConfigUtil.a(string8);
                }
                catch (Exception exception) {
                    throw (Throwable)new TildeExpandFilenameException("Failed to expand ~" + string8 + " in " + string, exception);
                }
                string2 = string6;
            }
            string4 = string2;
            return string4 + string3;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final String a(String string) {
        Object object = b;
        synchronized (object) {
            String string2 = c.get(string);
            if (string2 != null) {
                return string2;
            }
            Exception exception = a.get(string);
            try {
                if (exception != null) {
                    throw (Throwable)new RuntimeException("Previous attempt to retrieve home directory for `" + string + "` user failed", exception);
                }
            }
            catch (Exception exception2) {
                throw OpenSSHConfigUtil.a(exception2);
            }
            try {
                String string3 = OpenSSHConfigUtil.b(string);
                Map map = c;
                String string4 = string;
                String string5 = string3;
                map.put(string4, string5);
                return string3;
            }
            catch (Exception exception3) {
                Map map = a;
                String string6 = string;
                Exception exception4 = exception3;
                map.put(string6, exception4);
                throw (Throwable)exception3;
            }
        }
    }

    private static final String b(String string) {
        try {
            if (Intrinsics.areEqual((Object)SystemProperties.getUserName(), (Object)string)) {
                String string2 = SystemProperties.getUserHome();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SystemProperties.getUserHome()");
                return string2;
            }
        }
        catch (TildeExpandFilenameException tildeExpandFilenameException) {
            throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
        }
        try {
            if (SystemInfo.isLinux) {
                return OpenSSHConfigUtil.c(string);
            }
        }
        catch (TildeExpandFilenameException tildeExpandFilenameException) {
            throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
        }
        return ((Object)Paths.get(SystemProperties.getUserHome(), new String[0]).resolveSibling(string)).toString();
    }

    private static final String c(String string) {
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{"getent", "passwd", string});
        try {
            String string2;
            ProcessOutput processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)generalCommandLine, (int)1000);
            try {
                if (processOutput.getExitCode() == 2) {
                    throw (Throwable)new RuntimeException('`' + string + "` user could not be found in `passwd` database");
                }
            }
            catch (Exception exception) {
                throw OpenSSHConfigUtil.a(exception);
            }
            String string3 = string2 = processOutput.getStdout();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"output");
            return OpenSSHConfigUtil.parseUserHomeFromGetentPasswdOutput(string3);
        }
        catch (Exception exception) {
            throw (Throwable)new RuntimeException("Failed to retrieve home directory for `" + string + "` user using `" + generalCommandLine.getCommandLineString() + "` command", exception);
        }
    }

    @NotNull
    public static final String parseUserHomeFromGetentPasswdOutput(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"output");
        List list = StringsKt.split$default((CharSequence)string, (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null);
        try {
            if (list.size() == 7) {
                return (String)list.get(5);
            }
        }
        catch (TildeExpandFilenameException tildeExpandFilenameException) {
            throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
        }
        throw (Throwable)new IllegalArgumentException("Unknown format of `passwd` record: " + string);
    }

    private static final String a() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final String toProxyCommand(@NotNull ProxyJumpOptions proxyJumpOptions) {
        Intrinsics.checkParameterIsNotNull((Object)proxyJumpOptions, (String)"$receiver");
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (proxyJumpOptions.getUser() != null) {
                stringBuilder.append(" -l " + proxyJumpOptions.getUser());
            }
        }
        catch (TildeExpandFilenameException tildeExpandFilenameException) {
            throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
        }
        try {
            if (proxyJumpOptions.getPort() != null) {
                stringBuilder.append(" -p " + proxyJumpOptions.getPort());
            }
        }
        catch (TildeExpandFilenameException tildeExpandFilenameException) {
            throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
        }
        try {
            if (proxyJumpOptions.getExtra() != null) {
                stringBuilder.append(" -J " + proxyJumpOptions.getExtra());
            }
        }
        catch (TildeExpandFilenameException tildeExpandFilenameException) {
            throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
        }
        String string = stringBuilder.toString();
        return "ssh" + string + " -W '[%h]:%p' " + proxyJumpOptions.getHost();
    }

    @NotNull
    public static final ProxyJumpOptions parseJump(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"value");
        Object object = OpenSSHConfigUtil.splitMinHead(string, ',');
        String string2 = (String)object.component1();
        String string3 = (String)object.component2();
        if (StringsKt.startsWith$default((String)string2, (String)"ssh://", (boolean)false, (int)2, null)) {
            Integer n2;
            object = URI.create(string2);
            String string4 = ((URI)object).getUserInfo();
            String string5 = ((URI)object).getHost();
            try {
                n2 = ((URI)object).getPort() == -1 ? null : Integer.valueOf(((URI)object).getPort());
            }
            catch (TildeExpandFilenameException tildeExpandFilenameException) {
                throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
            }
            Integer n3 = n2;
            String string6 = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"host");
            return new ProxyJumpOptions(string4, string6, n3, string3);
        }
        Object object2 = OpenSSHConfigUtil.splitMinTail(string2, '@');
        object = (String)object2.component1();
        String string7 = (String)object2.component2();
        Pair<String, Integer> pair2 = OpenSSHConfigUtil.splitHostPort(string7);
        object2 = (String)pair2.component1();
        Integer n4 = (Integer)pair2.component2();
        return new ProxyJumpOptions((String)object, (String)object2, n4, string3);
    }

    @NotNull
    public static final Pair<String, String> splitMinHead(@NotNull String string, char c2) {
        Pair pair2;
        block3: {
            int n2;
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"value");
                n2 = StringsKt.indexOf$default((CharSequence)string, (char)c2, (int)0, (boolean)false, (int)6, null);
                try {
                    if (n2 != -1) break block2;
                    pair2 = TuplesKt.to((Object)string, null);
                    break block3;
                }
                catch (TildeExpandFilenameException tildeExpandFilenameException) {
                    throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
                }
            }
            String string2 = string;
            int n3 = 0;
            String string3 = string2.substring(n3, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string2 = string;
            n3 = n2 + 1;
            String string4 = string3;
            String string5 = string2.substring(n3);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            String string6 = string5;
            pair2 = TuplesKt.to((Object)string4, (Object)string6);
        }
        return pair2;
    }

    @NotNull
    public static final Pair<String, String> splitMinTail(@NotNull String string, char c2) {
        Pair pair2;
        block3: {
            int n2;
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"value");
                n2 = StringsKt.lastIndexOf$default((CharSequence)string, (char)c2, (int)0, (boolean)false, (int)6, null);
                try {
                    if (n2 != -1) break block2;
                    pair2 = TuplesKt.to(null, (Object)string);
                    break block3;
                }
                catch (TildeExpandFilenameException tildeExpandFilenameException) {
                    throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
                }
            }
            String string2 = string;
            int n3 = 0;
            String string3 = string2.substring(n3, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string2 = string;
            n3 = n2 + 1;
            String string4 = string3;
            String string5 = string2.substring(n3);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            String string6 = string5;
            pair2 = TuplesKt.to((Object)string4, (Object)string6);
        }
        return pair2;
    }

    @NotNull
    public static final Pair<String, Integer> splitHostPort(@NotNull String string) {
        Pair pair2;
        CharSequence charSequence;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"hostPort");
        CharSequence charSequence2 = string;
        try {
            bl2 = charSequence2.length() == 0;
        }
        catch (TildeExpandFilenameException tildeExpandFilenameException) {
            throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
        }
        try {
            if (bl2) {
                throw (Throwable)new IllegalArgumentException("host[:port] must not be empty");
            }
        }
        catch (TildeExpandFilenameException tildeExpandFilenameException) {
            throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
        }
        try {
            if (StringsKt.endsWith$default((CharSequence)string, (char)':', (boolean)false, (int)2, null)) {
                throw (Throwable)new IllegalArgumentException("Port is not specified after the colon `:`");
            }
        }
        catch (TildeExpandFilenameException tildeExpandFilenameException) {
            throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
        }
        CharSequence charSequence3 = charSequence = (charSequence2 = HostAndPort.fromString((String)string).requireBracketsForIPv6());
        try {
            pair2 = charSequence3.hasPort() ? TuplesKt.to((Object)charSequence3.getHost(), (Object)charSequence3.getPort()) : TuplesKt.to((Object)charSequence3.getHost(), null);
        }
        catch (TildeExpandFilenameException tildeExpandFilenameException) {
            throw OpenSSHConfigUtil.a(tildeExpandFilenameException);
        }
        return pair2;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

