/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.FileStructureTestFixture;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightFixtureTestCase;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileStructureTestBase
extends CodeInsightFixtureTestCase {
    protected FileStructureTestFixture myPopupFixture;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myPopupFixture = new FileStructureTestFixture(this.myFixture);
    }

    protected void configureDefault() {
        this.myFixture.configureByFile(PathUtil.makeFileName((String)this.getTestName(false), (String)this.getFileExtension()));
    }

    protected abstract String getFileExtension();

    @Override
    public void tearDown() throws Exception {
        try {
            Disposer.dispose((Disposable)this.myPopupFixture);
            this.myPopupFixture = null;
        }
        finally {
            super.tearDown();
        }
    }

    protected void checkTree(String string) {
        this.checkTree(string, true);
    }

    protected void checkTree() {
        this.checkTree(null, true);
    }

    protected void checkTree(boolean bl2) {
        this.checkTree(null, bl2);
    }

    protected void checkTree(@Nullable String string, boolean bl2) {
        try {
            this.configureDefault();
            this.myPopupFixture.update();
            if (string != null) {
                this.setSearchFilter(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw FileStructureTestBase.a(illegalArgumentException);
        }
        try {
            if (bl2) {
                TreeUtil.expandAll((JTree)this.myPopupFixture.getTree());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw FileStructureTestBase.a(illegalArgumentException);
        }
        this.checkResult();
    }

    protected void setSearchFilter(@NotNull String string) {
        try {
            if (string == null) {
                FileStructureTestBase.b(0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw FileStructureTestBase.a(illegalArgumentException);
        }
        this.myPopupFixture.getPopup().setSearchFilterForTests(string);
        PlatformTestUtil.waitForPromise(this.myPopupFixture.getPopup().rebuildAndUpdate());
        this.myPopupFixture.getSpeedSearch().findAndSelectElement(string);
    }

    protected void checkResult() {
        String string = this.getTestDataPath() + "/" + PathUtil.makeFileName((String)this.getTestName(false), (String)"tree");
        FileStructureTestBase.assertSameLinesWithFile(string, PlatformTestUtil.print((JTree)this.myPopupFixture.getTree(), true).trim());
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/testFramework/FileStructureTestBase", "setSearchFilter"));
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

