/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.util.ResourceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;

public abstract class IdeResourcesTestCase
extends PlatformTestCase {
    public void testFeatureTipsRegistered() {
        ProductivityFeaturesRegistry productivityFeaturesRegistry = ProductivityFeaturesRegistry.getInstance();
        Set set = productivityFeaturesRegistry.getFeatureIds();
        IdeResourcesTestCase.assertNotEmpty(set);
        TreeSet treeSet = ContainerUtil.newTreeSet();
        for (String string : set) {
            FeatureDescriptor featureDescriptor = productivityFeaturesRegistry.getFeatureDescriptor(string);
            TipAndTrickBean tipAndTrickBean = TipAndTrickBean.findByFileName((String)featureDescriptor.getTipFileName());
            if (tipAndTrickBean != null) continue;
            treeSet.add("<tipAndTrick file=\"" + featureDescriptor.getTipFileName() + "\" feature-id=\"" + string + "\"/>");
        }
        IdeResourcesTestCase.assertEquals((String)("Register the following extensions:\n" + StringUtil.join((Collection)treeSet, (String)"\n")), (int)0, (int)treeSet.size());
    }

    public void testTipFilesPresent() {
        TreeSet treeSet = ContainerUtil.newTreeSet();
        TipAndTrickBean[] tipAndTrickBeanArray = (TipAndTrickBean[])TipAndTrickBean.EP_NAME.getExtensions();
        IdeResourcesTestCase.assertNotEmpty(Arrays.asList(tipAndTrickBeanArray));
        for (TipAndTrickBean tipAndTrickBean : tipAndTrickBeanArray) {
            URL uRL = ResourceUtil.getResource((ClassLoader)tipAndTrickBean.getPluginDescriptor().getPluginClassLoader(), (String)"/tips/", (String)tipAndTrickBean.fileName);
            if (uRL != null) continue;
            treeSet.add(tipAndTrickBean.fileName);
        }
        IdeResourcesTestCase.assertEquals((String)(tipAndTrickBeanArray.length + " tips are checked, the following files are missing:\n" + StringUtil.join((Collection)treeSet, (String)"\n")), (int)0, (int)treeSet.size());
    }

    public void testTipFilesDuplicates() {
        TreeSet treeSet = ContainerUtil.newTreeSet();
        TipAndTrickBean[] tipAndTrickBeanArray = (TipAndTrickBean[])TipAndTrickBean.EP_NAME.getExtensions();
        IdeResourcesTestCase.assertNotEmpty(Arrays.asList(tipAndTrickBeanArray));
        LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
        for (TipAndTrickBean tipAndTrickBean : tipAndTrickBeanArray) {
            if (linkedHashSet.add(tipAndTrickBean.fileName)) continue;
            treeSet.add(tipAndTrickBean.fileName);
        }
        IdeResourcesTestCase.assertEquals((String)("The following tip files are registered more than once:\n" + StringUtil.join((Collection)treeSet, (String)"\n")), (int)0, (int)treeSet.size());
    }
}

