/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class ProjectViewTestUtil {
    public static VirtualFile[] getFiles(AbstractTreeNode abstractTreeNode, Function<AbstractTreeNode, VirtualFile[]> function) {
        if (abstractTreeNode instanceof BasePsiNode) {
            Object object = abstractTreeNode.getValue();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)object));
            return new VirtualFile[]{virtualFile};
        }
        if (function != null) {
            VirtualFile[] virtualFileArray = (VirtualFile[])function.fun((Object)abstractTreeNode);
            try {
                if (virtualFileArray != null) {
                    return virtualFileArray;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ProjectViewTestUtil.a(illegalArgumentException);
            }
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    public static void collect(AbstractTreeNode abstractTreeNode, MultiValuesMap<VirtualFile, AbstractTreeNode> multiValuesMap, AbstractTreeStructure abstractTreeStructure, Function<AbstractTreeNode, VirtualFile[]> function) {
        Object[] objectArray;
        for (Object object : objectArray = abstractTreeStructure.getChildElements((Object)abstractTreeNode)) {
            VirtualFile[] virtualFileArray;
            ProjectViewNode projectViewNode = (ProjectViewNode)object;
            for (VirtualFile virtualFile : virtualFileArray = ProjectViewTestUtil.getFiles((AbstractTreeNode)projectViewNode, function)) {
                multiValuesMap.put((Object)virtualFile, (Object)projectViewNode);
                for (ProjectViewNode projectViewNode2 = (ProjectViewNode)projectViewNode.getParent(); projectViewNode2 != null; projectViewNode2 = (ProjectViewNode)projectViewNode2.getParent()) {
                    multiValuesMap.put((Object)virtualFile, (Object)projectViewNode2);
                }
            }
            ProjectViewTestUtil.collect((AbstractTreeNode)projectViewNode, multiValuesMap, abstractTreeStructure, function);
        }
    }

    public static void checkContainsMethod(Object object, AbstractTreeStructure abstractTreeStructure, Function<AbstractTreeNode, VirtualFile[]> function) {
        MultiValuesMap multiValuesMap = new MultiValuesMap();
        ProjectViewTestUtil.collect((AbstractTreeNode)object, (MultiValuesMap<VirtualFile, AbstractTreeNode>)multiValuesMap, abstractTreeStructure, function);
        for (VirtualFile virtualFile : multiValuesMap.keySet()) {
            Collection collection = multiValuesMap.values();
            for (AbstractTreeNode abstractTreeNode : collection) {
                boolean bl2;
                ProjectViewNode projectViewNode = (ProjectViewNode)abstractTreeNode;
                boolean bl3 = projectViewNode.contains(virtualFile);
                if (bl3 == (bl2 = multiValuesMap.get((Object)virtualFile).contains(projectViewNode))) continue;
                boolean bl4 = projectViewNode.contains(virtualFile);
                boolean bl5 = multiValuesMap.get((Object)virtualFile).contains(projectViewNode);
                Assert.assertTrue((String)("file=" + virtualFile + " node=" + projectViewNode.getTestPresentation() + " expected:" + bl2), (boolean)false);
            }
        }
    }

    public static void checkGetParentConsistency(AbstractTreeStructure abstractTreeStructure, Object object) {
        Object[] objectArray;
        for (Object object2 : objectArray = abstractTreeStructure.getChildElements(object)) {
            Assert.assertSame((Object)object, (Object)abstractTreeStructure.getParentElement(object2));
            ProjectViewTestUtil.checkGetParentConsistency(abstractTreeStructure, object2);
        }
    }

    public static void assertStructureEqual(AbstractTreeStructure abstractTreeStructure, String string, @Nullable Queryable.PrintInfo printInfo) {
        ProjectViewTestUtil.assertStructureEqual(abstractTreeStructure, string, 27, null, abstractTreeStructure.getRootElement(), printInfo);
    }

    public static void assertStructureEqual(AbstractTreeStructure abstractTreeStructure, String string, int n2, @Nullable Comparator comparator, Object object, @Nullable Queryable.PrintInfo printInfo) {
        ProjectViewTestUtil.checkGetParentConsistency(abstractTreeStructure, object);
        String string2 = PlatformTestUtil.print(abstractTreeStructure, object, 0, comparator, n2, ' ', printInfo).toString();
        Assert.assertEquals((Object)string, (Object)string2);
    }

    protected static boolean isExpanded(DefaultMutableTreeNode defaultMutableTreeNode, AbstractProjectViewPSIPane abstractProjectViewPSIPane) {
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        return abstractProjectViewPSIPane.getTree().isExpanded(treePath.getParentPath());
    }

    public static DefaultMutableTreeNode getNodeForElement(PsiElement psiElement, AbstractProjectViewPSIPane abstractProjectViewPSIPane) {
        JTree jTree = abstractProjectViewPSIPane.getTree();
        TreeModel treeModel = jTree.getModel();
        Object object = treeModel.getRoot();
        return ProjectViewTestUtil.a(object, treeModel, psiElement);
    }

    private static DefaultMutableTreeNode a(Object object, TreeModel treeModel, PsiElement psiElement) {
        Object object2;
        if (object instanceof DefaultMutableTreeNode && (object2 = ((DefaultMutableTreeNode)object).getUserObject()) instanceof AbstractTreeNode) {
            AbstractTreeNode abstractTreeNode = (AbstractTreeNode)object2;
            try {
                if (psiElement.equals(abstractTreeNode.getValue())) {
                    return (DefaultMutableTreeNode)object;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ProjectViewTestUtil.a(illegalArgumentException);
            }
            for (int i2 = 0; i2 < treeModel.getChildCount(object); ++i2) {
                DefaultMutableTreeNode defaultMutableTreeNode = ProjectViewTestUtil.a(treeModel.getChild(object, i2), treeModel, psiElement);
                try {
                    if (defaultMutableTreeNode == null) continue;
                    return defaultMutableTreeNode;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ProjectViewTestUtil.a(illegalArgumentException);
                }
            }
        }
        return null;
    }

    public static boolean isExpanded(PsiElement psiElement, AbstractProjectViewPSIPane abstractProjectViewPSIPane) {
        boolean bl2;
        block5: {
            block4: {
                DefaultMutableTreeNode defaultMutableTreeNode = ProjectViewTestUtil.getNodeForElement(psiElement, abstractProjectViewPSIPane);
                try {
                    try {
                        if (defaultMutableTreeNode == null || !ProjectViewTestUtil.isExpanded((DefaultMutableTreeNode)defaultMutableTreeNode.getParent(), abstractProjectViewPSIPane)) break block4;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ProjectViewTestUtil.a(illegalArgumentException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ProjectViewTestUtil.a(illegalArgumentException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    public static void setupImpl(@NotNull Project project2, boolean bl2) {
        try {
            if (project2 == null) {
                ProjectViewTestUtil.a(0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ProjectViewTestUtil.a(illegalArgumentException);
        }
        ToolWindowManagerEx toolWindowManagerEx = ToolWindowManagerEx.getInstanceEx((Project)project2);
        ToolWindow toolWindow = toolWindowManagerEx.getToolWindow(ToolWindowId.PROJECT_VIEW);
        if (toolWindow == null) {
            ToolWindowEP[] toolWindowEPArray;
            for (ToolWindowEP toolWindowEP : toolWindowEPArray = (ToolWindowEP[])Extensions.getExtensions((ExtensionPointName)ToolWindowEP.EP_NAME)) {
                if (!toolWindowEP.id.equals(ToolWindowId.PROJECT_VIEW)) continue;
                toolWindow = toolWindowManagerEx.registerToolWindow(toolWindowEP.id, (JComponent)new JLabel(), ToolWindowAnchor.fromText((String)toolWindowEP.anchor), (Disposable)project2, false, toolWindowEP.canCloseContents);
                break;
            }
        }
        ((ProjectViewImpl)ProjectView.getInstance((Project)project2)).setupImpl(toolWindow, bl2);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/ProjectViewTestUtil", "setupImpl"));
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

