/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.exceptionCases.AbstractExceptionCase;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.ui.UIUtil;
import gnu.trove.Equality;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.intellij.lang.annotations.RegExp;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class UsefulTestCase
extends TestCase {
    public static final boolean IS_UNDER_TEAMCITY;
    public static final String TEMP_DIR_MARKER = "unitTest_";
    public static final boolean OVERWRITE_TESTDATA;
    private static final String g;
    private static final String b;
    private static final Map<String, Long> f;
    private static final Map<String, Long> h;
    protected static final Logger LOG;
    @NotNull
    private final Disposable j = new TestDisposable();
    static String ourPathToKeep;
    private final List<String> i = new ArrayList<String>();
    private CodeStyleSettings c;
    private String a;
    static final Key<String> CREATION_PLACE;
    private static final Set<String> d;
    private static final Class e;
    @Deprecated
    public static final String IDEA_MARKER_CLASS = "com.intellij.openapi.roots.IdeaModifiableModelsProvider";

    protected boolean shouldContainTempFiles() {
        return true;
    }

    protected void setUp() throws Exception {
        boolean bl2;
        super.setUp();
        if (this.shouldContainTempFiles()) {
            String string = FileUtil.sanitizeFileName((String)this.getTestName(true));
            if (StringUtil.isEmptyOrSpaces((String)string)) {
                string = "";
            }
            string = new File(string).getName();
            this.a = new File(b, "unitTest_" + string).getPath();
            FileUtil.resetCanonicalTempPathCache((String)this.a);
        }
        boolean bl3 = this.isStressTest();
        try {
            ApplicationInfoImpl.setInStressTest((boolean)bl3);
            if (this.isPerformanceTest()) {
                Timings.getStatistics();
            }
        }
        catch (Exception exception) {
            throw UsefulTestCase.b(exception);
        }
        try {
            bl2 = !bl3;
        }
        catch (Exception exception) {
            throw UsefulTestCase.b(exception);
        }
        Disposer.setDebugMode((boolean)bl2);
    }

    protected void tearDown() throws Exception {
        try {
            new RunAll(() -> this.disposeRootDisposable(), () -> UsefulTestCase.c(), () -> UsefulTestCase.g(), () -> Disposer.setDebugMode((boolean)true), () -> {
                block6: {
                    block7: {
                        try {
                            if (!this.shouldContainTempFiles()) break block6;
                            FileUtil.resetCanonicalTempPathCache((String)b);
                            if (!this.e()) break block7;
                        }
                        catch (Throwable throwable) {
                            throw UsefulTestCase.b(throwable);
                        }
                        File[] fileArray = new File(this.a).listFiles();
                        if (fileArray != null) {
                            for (File file : fileArray) {
                                try {
                                    if (this.b(file)) continue;
                                    FileUtil.delete((File)file);
                                }
                                catch (Throwable throwable) {
                                    throw UsefulTestCase.b(throwable);
                                }
                            }
                        }
                        break block6;
                    }
                    FileUtil.delete((File)new File(this.a));
                }
            }, () -> UIUtil.removeLeakingAppleListeners()).run();
        }
        finally {
            super.tearDown();
        }
    }

    protected final void disposeRootDisposable() {
        Disposer.dispose((Disposable)this.getTestRootDisposable());
    }

    protected void addTmpFileToKeep(@NotNull File file) {
        try {
            if (file == null) {
                UsefulTestCase.a(0);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        this.i.add(file.getPath());
    }

    private boolean e() {
        boolean bl2;
        block8: {
            block7: {
                try {
                    block6: {
                        try {
                            try {
                                if (ourPathToKeep != null && FileUtil.isAncestor((String)this.a, (String)ourPathToKeep, (boolean)false)) break block6;
                            }
                            catch (RuntimeException runtimeException) {
                                throw UsefulTestCase.b(runtimeException);
                            }
                            if (this.i.isEmpty()) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw UsefulTestCase.b(runtimeException);
                        }
                    }
                    bl2 = true;
                    break block8;
                }
                catch (RuntimeException runtimeException) {
                    throw UsefulTestCase.b(runtimeException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    private boolean b(@NotNull File file) {
        try {
            if (file == null) {
                UsefulTestCase.a(1);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        String string = file.getPath();
        try {
            if (FileUtil.pathsEqual((String)string, (String)ourPathToKeep)) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        for (String string2 : this.i) {
            try {
                if (!FileUtil.pathsEqual((String)string, (String)string2)) continue;
                return true;
            }
            catch (RuntimeException runtimeException) {
                throw UsefulTestCase.b(runtimeException);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void g() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        ArrayList<String> arrayList;
        Class clazz = e;
        synchronized (clazz) {
            if (d.isEmpty()) {
                return;
            }
            arrayList = new ArrayList<String>(d);
        }
        for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
            String string = (String)arrayList.get(i2);
            File file = new File(string);
            try {
                if (!file.delete() && file.exists()) continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw UsefulTestCase.b(classNotFoundException);
            }
            Class clazz2 = e;
            synchronized (clazz2) {
                d.remove(string);
                continue;
            }
        }
    }

    private static void c() throws Exception {
        Object object = ReflectionUtil.getDeclaredMethod(Class.forName("javax.swing.KeyboardManager"), (String)"getCurrentManager", (Class[])new Class[0]).invoke(null, new Object[0]);
        Map map = (Map)ReflectionUtil.getField(object.getClass(), (Object)object, Hashtable.class, (String)"componentKeyStrokeMap");
        map.clear();
        Map map2 = (Map)ReflectionUtil.getField(object.getClass(), (Object)object, Hashtable.class, (String)"containerMap");
        map2.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkForJdkTableLeaks(@NotNull Sdk[] sdkArray) {
        Sdk[] sdkArray2;
        try {
            if (sdkArray == null) {
                UsefulTestCase.a(2);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        if (projectJdkTable != null && (sdkArray2 = projectJdkTable.getAllJdks()).length != 0) {
            THashSet tHashSet = new THashSet(Arrays.asList(sdkArray2));
            THashSet tHashSet2 = new THashSet(Arrays.asList(sdkArray));
            tHashSet.removeAll((Collection<?>)tHashSet2);
            try {
                if (!tHashSet.isEmpty()) {
                    UsefulTestCase.fail((String)("Leaked SDKs: " + tHashSet));
                }
            }
            finally {
                for (Sdk sdk : tHashSet) {
                    WriteAction.run(() -> projectJdkTable.removeJdk(sdk));
                }
            }
        }
    }

    protected void checkForSettingsDamage() {
        block10: {
            Application application = ApplicationManager.getApplication();
            try {
                block9: {
                    try {
                        try {
                            if (this.isStressTest() || application == null) break block9;
                        }
                        catch (RuntimeException runtimeException) {
                            throw UsefulTestCase.b(runtimeException);
                        }
                        if (!(application instanceof MockApplication)) break block10;
                    }
                    catch (RuntimeException runtimeException) {
                        throw UsefulTestCase.b(runtimeException);
                    }
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                throw UsefulTestCase.b(runtimeException);
            }
        }
        CodeStyleSettings codeStyleSettings = this.c;
        try {
            if (codeStyleSettings == null) {
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        this.c = null;
        UsefulTestCase.doCheckForSettingsDamage(codeStyleSettings, this.getCurrentCodeStyleSettings());
    }

    public static void doCheckForSettingsDamage(@NotNull CodeStyleSettings codeStyleSettings, @NotNull CodeStyleSettings codeStyleSettings2) {
        try {
            if (codeStyleSettings == null) {
                UsefulTestCase.a(3);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (codeStyleSettings2 == null) {
                UsefulTestCase.a(4);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        new RunAll(new ThrowableRunnable[0]).append(() -> {
            try {
                Element element = new Element("temp");
                codeInsightSettings.writeExternal(element);
                Assert.assertEquals((String)"Code insight settings damaged", (Object)g, (Object)JDOMUtil.writeElement((Element)element));
            }
            catch (AssertionError assertionError) {
                CodeInsightSettings codeInsightSettings2 = new CodeInsightSettings();
                for (Field field : codeInsightSettings2.getClass().getFields()) {
                    try {
                        ReflectionUtil.copyFieldValue((Object)codeInsightSettings2, (Object)codeInsightSettings, (Field)field);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw assertionError;
            }
        }).append(() -> {
            try {
                if (codeStyleSettings2 == null) {
                    UsefulTestCase.a(88);
                }
            }
            catch (Throwable throwable) {
                throw UsefulTestCase.b(throwable);
            }
            try {
                if (codeStyleSettings == null) {
                    UsefulTestCase.a(89);
                }
            }
            catch (Throwable throwable) {
                throw UsefulTestCase.b(throwable);
            }
            codeStyleSettings2.getIndentOptions((FileType)StdFileTypes.JAVA);
            try {
                UsefulTestCase.b(codeStyleSettings, codeStyleSettings2);
            }
            finally {
                codeStyleSettings2.clearCodeStyleSettings();
            }
        }).append(() -> InplaceRefactoring.checkCleared()).append(() -> StartMarkAction.checkCleared()).run();
    }

    void storeSettings() {
        block4: {
            try {
                try {
                    if (this.isStressTest() || ApplicationManager.getApplication() == null) break block4;
                }
                catch (RuntimeException runtimeException) {
                    throw UsefulTestCase.b(runtimeException);
                }
                this.c = this.getCurrentCodeStyleSettings().clone();
                this.c.getIndentOptions((FileType)StdFileTypes.JAVA);
            }
            catch (RuntimeException runtimeException) {
                throw UsefulTestCase.b(runtimeException);
            }
        }
    }

    @NotNull
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        CodeStyleSettings codeStyleSettings;
        try {
            codeStyleSettings = CodeStyleSettingsManager.getInstance().getCurrentSettings();
            if (codeStyleSettings == null) {
                UsefulTestCase.a(5);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        return codeStyleSettings;
    }

    @NotNull
    public Disposable getTestRootDisposable() {
        Disposable disposable;
        try {
            disposable = this.j;
            if (disposable == null) {
                UsefulTestCase.a(6);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        return disposable;
    }

    protected void runTest() throws Throwable {
        Throwable[] throwableArray = new Throwable[1];
        Runnable runnable = () -> {
            try {
                super.runTest();
                TestLoggerFactory.onTestFinished(true);
            }
            catch (InvocationTargetException invocationTargetException) {
                TestLoggerFactory.onTestFinished(false);
                invocationTargetException.fillInStackTrace();
                throwableArray[0] = invocationTargetException.getTargetException();
            }
            catch (IllegalAccessException illegalAccessException) {
                TestLoggerFactory.onTestFinished(false);
                illegalAccessException.fillInStackTrace();
                throwableArray[0] = illegalAccessException;
            }
            catch (Throwable throwable) {
                TestLoggerFactory.onTestFinished(false);
                throwableArray[0] = throwable;
            }
        };
        try {
            this.invokeTestRunnable(runnable);
            if (throwableArray[0] != null) {
                throw throwableArray[0];
            }
        }
        catch (Throwable throwable) {
            throw UsefulTestCase.b(throwable);
        }
    }

    protected boolean shouldRunTest() {
        return TestFrameworkUtil.canRunTest(((Object)((Object)this)).getClass());
    }

    protected void invokeTestRunnable(@NotNull Runnable runnable) throws Exception {
        try {
            if (runnable == null) {
                UsefulTestCase.a(7);
            }
        }
        catch (Exception exception) {
            throw UsefulTestCase.b(exception);
        }
        EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)() -> {
            try {
                if (runnable == null) {
                    UsefulTestCase.a(87);
                }
            }
            catch (RuntimeException runtimeException) {
                throw UsefulTestCase.b(runtimeException);
            }
            runnable.run();
            return null;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void defaultRunBare() throws Throwable {
        long l2;
        long l3;
        Throwable throwable = null;
        try {
            l3 = System.nanoTime();
            this.setUp();
            l2 = (System.nanoTime() - l3) / 1000000L;
            this.a(l2, f);
            this.runTest();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        finally {
            block15: {
                try {
                    l3 = System.nanoTime();
                    this.tearDown();
                    l2 = (System.nanoTime() - l3) / 1000000L;
                    this.a(l2, h);
                }
                catch (Throwable throwable3) {
                    if (throwable != null) break block15;
                    throwable = throwable3;
                }
            }
        }
        try {
            if (throwable != null) {
                throw throwable;
            }
        }
        catch (Throwable throwable4) {
            throw UsefulTestCase.b(throwable4);
        }
    }

    private void a(long l2, @NotNull Map<String, Long> map) {
        long l3;
        try {
            if (map == null) {
                UsefulTestCase.a(8);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        Class<?> clazz = ((Object)((Object)this)).getClass().getSuperclass();
        Long l4 = map.get(clazz.getName());
        try {
            l3 = l4 == null ? l2 : l4 + l2;
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        long l5 = l3;
        map.put(clazz.getName(), l5);
    }

    static void logSetupTeardownCosts() {
        System.out.println("Setup costs");
        long l2 = 0L;
        for (Map.Entry<String, Long> entry : f.entrySet()) {
            System.out.println(String.format("  %s: %d ms", entry.getKey(), entry.getValue()));
            l2 += entry.getValue().longValue();
        }
        System.out.println("Teardown costs");
        long l3 = 0L;
        for (Map.Entry<String, Long> entry : h.entrySet()) {
            System.out.println(String.format("  %s: %d ms", entry.getKey(), entry.getValue()));
            l3 += entry.getValue().longValue();
        }
        System.out.println(String.format("Total overhead: setup %d ms, teardown %d ms", l2, l3));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.totalSetupMs' value='%d']", l2));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.totalTeardownMs' value='%d']", l3));
    }

    public void runBare() throws Throwable {
        block6: {
            block5: {
                try {
                    if (!this.shouldRunTest()) {
                        return;
                    }
                }
                catch (Throwable throwable) {
                    throw UsefulTestCase.b(throwable);
                }
                try {
                    if (!this.runInDispatchThread()) break block5;
                    TestRunnerUtil.replaceIdeEventQueueSafely();
                    EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)this::defaultRunBare));
                    break block6;
                }
                catch (Throwable throwable) {
                    throw UsefulTestCase.b(throwable);
                }
            }
            this.defaultRunBare();
        }
    }

    protected boolean runInDispatchThread() {
        return true;
    }

    protected void edt(@NotNull ThrowableRunnable<Throwable> throwableRunnable) {
        try {
            if (throwableRunnable == null) {
                UsefulTestCase.a(9);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        EdtTestUtil.runInEdtAndWait(throwableRunnable);
    }

    public static String toString(@NotNull Iterable<?> iterable) {
        try {
            if (iterable == null) {
                UsefulTestCase.a(10);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (!iterable.iterator().hasNext()) {
                return "<empty>";
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : iterable) {
            block10: {
                block9: {
                    try {
                        if (!(obj instanceof THashSet)) break block9;
                        stringBuilder.append(new TreeSet((THashSet)obj));
                        break block10;
                    }
                    catch (RuntimeException runtimeException) {
                        throw UsefulTestCase.b(runtimeException);
                    }
                }
                stringBuilder.append(obj);
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull T[] TArray, T ... TArray2) {
        try {
            if (TArray == null) {
                UsefulTestCase.a(11);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (TArray2 == null) {
                UsefulTestCase.a(12);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertOrderedEquals(Arrays.asList(TArray), TArray2);
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull Iterable<T> iterable, T ... TArray) {
        try {
            if (iterable == null) {
                UsefulTestCase.a(13);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (TArray == null) {
                UsefulTestCase.a(14);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertOrderedEquals(null, iterable, TArray);
    }

    public static void assertOrderedEquals(@NotNull byte[] byArray, @NotNull byte[] byArray2) {
        try {
            if (byArray == null) {
                UsefulTestCase.a(15);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (byArray2 == null) {
                UsefulTestCase.a(16);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertEquals((int)byArray.length, (int)byArray2.length);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by2 = byArray[i2];
            byte by3 = byArray2[i2];
            UsefulTestCase.assertEquals((String)("not equals at index: " + i2), (byte)by3, (byte)by2);
        }
    }

    public static void assertOrderedEquals(@NotNull int[] nArray, @NotNull int[] nArray2) {
        try {
            if (nArray == null) {
                UsefulTestCase.a(17);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (nArray2 == null) {
                UsefulTestCase.a(18);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (nArray.length != nArray2.length) {
                UsefulTestCase.fail((String)("Expected size: " + nArray2.length + "; actual: " + nArray.length + "\nexpected: " + Arrays.toString(nArray2) + "\nactual  : " + Arrays.toString(nArray)));
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            int n3 = nArray2[i2];
            UsefulTestCase.assertEquals((String)("not equals at index: " + i2), (int)n3, (int)n2);
        }
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(String string, @NotNull Iterable<T> iterable, T ... TArray) {
        try {
            if (iterable == null) {
                UsefulTestCase.a(19);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (TArray == null) {
                UsefulTestCase.a(20);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertOrderedEquals(string, iterable, Arrays.asList(TArray));
    }

    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> iterable, @NotNull Iterable<? extends T> iterable2) {
        try {
            if (iterable == null) {
                UsefulTestCase.a(21);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (iterable2 == null) {
                UsefulTestCase.a(22);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertOrderedEquals(null, iterable, iterable2);
    }

    public static <T> void assertOrderedEquals(String string, @NotNull Iterable<? extends T> iterable, @NotNull Iterable<? extends T> iterable2) {
        try {
            if (iterable == null) {
                UsefulTestCase.a(23);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (iterable2 == null) {
                UsefulTestCase.a(24);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertOrderedEquals(string, iterable, iterable2, Equality.CANONICAL);
    }

    public static <T> void assertOrderedEquals(String string, @NotNull Iterable<? extends T> iterable, @NotNull Iterable<? extends T> iterable2, @NotNull Equality<? super T> equality) {
        try {
            if (iterable == null) {
                UsefulTestCase.a(25);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (iterable2 == null) {
                UsefulTestCase.a(26);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (equality == null) {
                UsefulTestCase.a(27);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        if (!UsefulTestCase.a(iterable, iterable2, equality)) {
            String string2 = UsefulTestCase.toString(iterable2);
            String string3 = UsefulTestCase.toString(iterable);
            Assert.assertEquals((String)string, (Object)string2, (Object)string3);
            Assert.fail((String)("Warning! 'toString' does not reflect the difference.\nExpected: " + string2 + "\nActual: " + string3));
        }
    }

    /*
     * Unable to fully structure code
     */
    private static <T> boolean a(@NotNull Iterable<? extends T> var0, @NotNull Iterable<? extends T> var1_1, @NotNull Equality<? super T> var2_2) {
        block16: {
            try {
                if (var0 == null) {
                    UsefulTestCase.a(28);
                }
            }
            catch (RuntimeException v0) {
                throw UsefulTestCase.b(v0);
            }
            try {
                if (var1_1 == null) {
                    UsefulTestCase.a(29);
                }
            }
            catch (RuntimeException v1) {
                throw UsefulTestCase.b(v1);
            }
            try {
                if (var2_2 == null) {
                    UsefulTestCase.a(30);
                }
            }
            catch (RuntimeException v2) {
                throw UsefulTestCase.b(v2);
            }
            var3_3 = var0.iterator();
            var4_4 = var1_1.iterator();
            do {
                if (var3_3.hasNext()) ** GOTO lbl27
                try {
                    block17: {
                        try {
                            try {
                                if (!var4_4.hasNext()) break block16;
lbl27:
                                // 2 sources

                                if (!var3_3.hasNext()) break block17;
                            }
                            catch (RuntimeException v3) {
                                throw UsefulTestCase.b(v3);
                            }
                            if (var4_4.hasNext()) continue;
                        }
                        catch (RuntimeException v4) {
                            throw UsefulTestCase.b(v4);
                        }
                    }
                    return false;
                }
                catch (RuntimeException v5) {
                    throw UsefulTestCase.b(v5);
                }
            } while (var2_2.equals(var3_3.next(), var4_4.next()));
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull T[] TArray, Consumer<T> ... consumerArray) {
        try {
            if (TArray == null) {
                UsefulTestCase.a(31);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (consumerArray == null) {
                UsefulTestCase.a(32);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertOrderedCollection(Arrays.asList(TArray), consumerArray);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull T[] TArray, T ... TArray2) {
        try {
            if (TArray == null) {
                UsefulTestCase.a(33);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (TArray2 == null) {
                UsefulTestCase.a(34);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertSameElements(Arrays.asList(TArray), TArray2);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull Collection<? extends T> collection, T ... TArray) {
        try {
            if (collection == null) {
                UsefulTestCase.a(35);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (TArray == null) {
                UsefulTestCase.a(36);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertSameElements(collection, Arrays.asList(TArray));
    }

    public static <T> void assertSameElements(@NotNull Collection<? extends T> collection, @NotNull Collection<T> collection2) {
        try {
            if (collection == null) {
                UsefulTestCase.a(37);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (collection2 == null) {
                UsefulTestCase.a(38);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertSameElements(null, collection, collection2);
    }

    public static <T> void assertSameElements(String string, @NotNull Collection<? extends T> collection, @NotNull Collection<T> collection2) {
        block8: {
            try {
                if (collection == null) {
                    UsefulTestCase.a(39);
                }
            }
            catch (RuntimeException runtimeException) {
                throw UsefulTestCase.b(runtimeException);
            }
            try {
                if (collection2 == null) {
                    UsefulTestCase.a(40);
                }
            }
            catch (RuntimeException runtimeException) {
                throw UsefulTestCase.b(runtimeException);
            }
            try {
                if (collection.size() == collection2.size() && new HashSet<T>(collection2).equals(new HashSet<T>(collection))) break block8;
            }
            catch (RuntimeException runtimeException) {
                throw UsefulTestCase.b(runtimeException);
            }
            Assert.assertEquals((String)string, (Object)UsefulTestCase.toString(collection2, "\n"), (Object)UsefulTestCase.toString(collection, "\n"));
            Assert.assertEquals((String)string, new HashSet<T>(collection2), new HashSet<T>(collection));
        }
    }

    @SafeVarargs
    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, T ... TArray) {
        try {
            if (collection == null) {
                UsefulTestCase.a(41);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (TArray == null) {
                UsefulTestCase.a(42);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertContainsOrdered(collection, Arrays.asList(TArray));
    }

    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, @NotNull Collection<T> collection2) {
        try {
            if (collection == null) {
                UsefulTestCase.a(43);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (collection2 == null) {
                UsefulTestCase.a(44);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        arrayList.retainAll(collection2);
        UsefulTestCase.assertOrderedEquals(UsefulTestCase.toString(collection), arrayList, collection2);
    }

    @SafeVarargs
    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, T ... TArray) {
        try {
            if (collection == null) {
                UsefulTestCase.a(45);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (TArray == null) {
                UsefulTestCase.a(46);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertContainsElements(collection, Arrays.asList(TArray));
    }

    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, @NotNull Collection<T> collection2) {
        try {
            if (collection == null) {
                UsefulTestCase.a(47);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (collection2 == null) {
                UsefulTestCase.a(48);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        arrayList.retainAll(collection2);
        UsefulTestCase.assertSameElements(UsefulTestCase.toString(collection), arrayList, collection2);
    }

    @NotNull
    public static String toString(@NotNull Object[] objectArray, @NotNull String string) {
        String string2;
        try {
            if (objectArray == null) {
                UsefulTestCase.a(49);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (string == null) {
                UsefulTestCase.a(50);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            string2 = UsefulTestCase.toString(Arrays.asList(objectArray), string);
            if (string2 == null) {
                UsefulTestCase.a(51);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        return string2;
    }

    @SafeVarargs
    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, T ... TArray) {
        try {
            if (collection == null) {
                UsefulTestCase.a(52);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (TArray == null) {
                UsefulTestCase.a(53);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertDoesntContain(collection, Arrays.asList(TArray));
    }

    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, @NotNull Collection<T> collection2) {
        try {
            if (collection == null) {
                UsefulTestCase.a(54);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (collection2 == null) {
                UsefulTestCase.a(55);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        arrayList.removeAll(collection2);
        UsefulTestCase.assertSameElements(collection, arrayList);
    }

    @NotNull
    public static String toString(@NotNull Collection<?> collection, @NotNull String string) {
        String string2;
        try {
            if (collection == null) {
                UsefulTestCase.a(56);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (string == null) {
                UsefulTestCase.a(57);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        List list = ContainerUtil.map2List(collection, String::valueOf);
        Collections.sort(list);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        for (String string3 : list) {
            try {
                if (bl2) {
                    stringBuilder.append(string);
                }
            }
            catch (RuntimeException runtimeException) {
                throw UsefulTestCase.b(runtimeException);
            }
            stringBuilder.append(string3);
            bl2 = true;
        }
        try {
            string2 = stringBuilder.toString();
            if (string2 == null) {
                UsefulTestCase.a(58);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        return string2;
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull Collection<? extends T> collection, Consumer<T> ... consumerArray) {
        try {
            if (collection == null) {
                UsefulTestCase.a(59);
            }
        }
        catch (AssertionFailedError assertionFailedError) {
            throw UsefulTestCase.b(assertionFailedError);
        }
        try {
            if (consumerArray == null) {
                UsefulTestCase.a(60);
            }
        }
        catch (AssertionFailedError assertionFailedError) {
            throw UsefulTestCase.b(assertionFailedError);
        }
        try {
            if (collection.size() != consumerArray.length) {
                Assert.fail((String)UsefulTestCase.toString(collection));
            }
        }
        catch (AssertionFailedError assertionFailedError) {
            throw UsefulTestCase.b(assertionFailedError);
        }
        int n2 = 0;
        for (T t2 : collection) {
            try {
                consumerArray[n2].consume(t2);
            }
            catch (AssertionFailedError assertionFailedError) {
                System.out.println(n2 + ": " + t2);
                throw assertionFailedError;
            }
            ++n2;
        }
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull T[] TArray, Consumer<T> ... consumerArray) {
        try {
            if (TArray == null) {
                UsefulTestCase.a(61);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (consumerArray == null) {
                UsefulTestCase.a(62);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertUnorderedCollection(Arrays.asList(TArray), consumerArray);
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull Collection<? extends T> collection, Consumer<T> ... consumerArray) {
        try {
            if (collection == null) {
                UsefulTestCase.a(63);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (consumerArray == null) {
                UsefulTestCase.a(64);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            if (collection.size() != consumerArray.length) {
                Assert.fail((String)UsefulTestCase.toString(collection));
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        HashSet<Consumer<T>> hashSet = new HashSet<Consumer<T>>(Arrays.asList(consumerArray));
        int n2 = 0;
        Throwable throwable = null;
        for (T t2 : collection) {
            boolean bl2 = true;
            for (Consumer consumer : hashSet) {
                Throwable throwable2 = UsefulTestCase.a(consumer, t2);
                if (throwable2 == null) {
                    hashSet.remove(consumer);
                    bl2 = false;
                    break;
                }
                throwable = throwable2;
            }
            try {
                if (bl2) {
                    throwable.printStackTrace();
                    Assert.fail((String)("Incorrect element(" + n2 + "): " + t2));
                }
            }
            catch (RuntimeException runtimeException) {
                throw UsefulTestCase.b(runtimeException);
            }
            ++n2;
        }
    }

    private static <T> Throwable a(@NotNull Consumer<T> consumer, T t2) {
        try {
            if (consumer == null) {
                UsefulTestCase.a(65);
            }
        }
        catch (Throwable throwable) {
            throw UsefulTestCase.b(throwable);
        }
        try {
            consumer.consume(t2);
            return null;
        }
        catch (Throwable throwable) {
            return throwable;
        }
    }

    @Contract(value="null, _ -> fail")
    public static <T> T assertInstanceOf(Object object, @NotNull Class<T> clazz) {
        try {
            if (clazz == null) {
                UsefulTestCase.a(66);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        Assert.assertNotNull((String)("Expected instance of: " + clazz.getName() + " actual: " + null), (Object)object);
        Assert.assertTrue((String)("Expected instance of: " + clazz.getName() + " actual: " + object.getClass().getName()), (boolean)clazz.isInstance(object));
        Object object2 = object;
        return (T)object2;
    }

    public static <T> T assertOneElement(@NotNull Collection<T> collection) {
        try {
            if (collection == null) {
                UsefulTestCase.a(67);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        Iterator<T> iterator = collection.iterator();
        String string = UsefulTestCase.toString(collection);
        Assert.assertTrue((String)string, (boolean)iterator.hasNext());
        T t2 = iterator.next();
        Assert.assertFalse((String)string, (boolean)iterator.hasNext());
        return t2;
    }

    public static <T> T assertOneElement(@NotNull T[] TArray) {
        try {
            if (TArray == null) {
                UsefulTestCase.a(68);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        Assert.assertEquals((String)Arrays.asList(TArray).toString(), (long)1L, (long)TArray.length);
        return TArray[0];
    }

    @SafeVarargs
    public static <T> void assertOneOf(T t2, T ... TArray) {
        try {
            if (TArray == null) {
                UsefulTestCase.a(69);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        boolean bl2 = false;
        for (T t3 : TArray) {
            block8: {
                try {
                    try {
                        if (t2 == t3) break block8;
                        if (t2 == null) continue;
                    }
                    catch (RuntimeException runtimeException) {
                        throw UsefulTestCase.b(runtimeException);
                    }
                    if (!t2.equals(t3)) continue;
                }
                catch (RuntimeException runtimeException) {
                    throw UsefulTestCase.b(runtimeException);
                }
            }
            bl2 = true;
        }
        Assert.assertTrue((String)(t2 + " should be equal to one of " + Arrays.toString(TArray)), (boolean)bl2);
    }

    public static void printThreadDump() {
        PerformanceWatcher.dumpThreadsToConsole((String)"Thread dump:");
    }

    public static void assertEmpty(@NotNull Object[] objectArray) {
        try {
            if (objectArray == null) {
                UsefulTestCase.a(70);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertOrderedEquals(objectArray, new Object[0]);
    }

    public static void assertNotEmpty(Collection<?> collection) {
        boolean bl2;
        try {
            if (collection == null) {
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            bl2 = !collection.isEmpty();
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertTrue((boolean)bl2);
    }

    public static void assertEmpty(@NotNull Collection<?> collection) {
        try {
            if (collection == null) {
                UsefulTestCase.a(71);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertEmpty(collection.toString(), collection);
    }

    public static void assertNullOrEmpty(@Nullable Collection<?> collection) {
        try {
            if (collection == null) {
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertEmpty(null, collection);
    }

    public static void assertEmpty(String string) {
        UsefulTestCase.assertTrue((String)string, (boolean)StringUtil.isEmpty((String)string));
    }

    public static <T> void assertEmpty(String string, Collection<T> collection) {
        UsefulTestCase.assertOrderedEquals(string, collection, Collections.emptyList());
    }

    public static void assertSize(int n2, Object[] objectArray) {
        UsefulTestCase.assertEquals((String)UsefulTestCase.toString(Arrays.asList(objectArray)), (int)n2, (int)objectArray.length);
    }

    public static void assertSize(int n2, Collection<?> collection) {
        UsefulTestCase.assertEquals((String)UsefulTestCase.toString(collection), (int)n2, (int)collection.size());
    }

    protected <T extends Disposable> T disposeOnTearDown(T t2) {
        Disposer.register((Disposable)this.getTestRootDisposable(), t2);
        return t2;
    }

    public static void assertSameLines(String string, String string2) {
        String string3 = StringUtil.convertLineSeparators((String)string.trim());
        String string4 = StringUtil.convertLineSeparators((String)string2.trim());
        Assert.assertEquals((Object)string3, (Object)string4);
    }

    public static void assertExists(@NotNull File file) {
        try {
            if (file == null) {
                UsefulTestCase.a(72);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertTrue((String)("File should exist " + file), (boolean)file.exists());
    }

    public static void assertDoesntExist(@NotNull File file) {
        try {
            if (file == null) {
                UsefulTestCase.a(73);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        UsefulTestCase.assertFalse((String)("File should not exist " + file), (boolean)file.exists());
    }

    @NotNull
    protected String getTestName(boolean bl2) {
        String string;
        try {
            string = UsefulTestCase.getTestName(this.getName(), bl2);
            if (string == null) {
                UsefulTestCase.a(74);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        return string;
    }

    @NotNull
    public static String getTestName(String string, boolean bl2) {
        String string2;
        String string3;
        try {
            string3 = string == null ? "" : PlatformTestUtil.getTestName(string, bl2);
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        try {
            string2 = string3;
            if (string3 == null) {
                UsefulTestCase.a(75);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        return string2;
    }

    protected String getTestDirectoryName() {
        String string = this.getTestName(true);
        return string.replaceAll("_.*", "");
    }

    public static void assertSameLinesWithFile(String string, String string2) {
        UsefulTestCase.assertSameLinesWithFile(string, string2, true);
    }

    public static void assertSameLinesWithFile(String string, String string2, boolean bl2) {
        String string3;
        String string4;
        String string5;
        try {
            try {
                if (OVERWRITE_TESTDATA) {
                    VfsTestUtil.overwriteTestData(string, string2);
                    System.out.println("File " + string + " created.");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw UsefulTestCase.b(fileNotFoundException);
            }
            string5 = FileUtil.loadFile((File)new File(string), (Charset)CharsetToolkit.UTF8_CHARSET);
        }
        catch (FileNotFoundException fileNotFoundException) {
            VfsTestUtil.overwriteTestData(string, string2);
            throw new AssertionFailedError("No output text found. File " + string + " created.");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        try {
            string4 = bl2 ? string5.trim() : string5;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw UsefulTestCase.b(fileNotFoundException);
        }
        String string6 = StringUtil.convertLineSeparators((String)string4);
        try {
            string3 = bl2 ? string2.trim() : string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw UsefulTestCase.b(fileNotFoundException);
        }
        String string7 = StringUtil.convertLineSeparators((String)string3);
        try {
            if (!Comparing.equal((String)string6, (String)string7)) {
                throw new FileComparisonFailure(null, string6, string7, string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw UsefulTestCase.b(fileNotFoundException);
        }
    }

    protected static void clearFields(@NotNull Object object) throws IllegalAccessException {
        try {
            if (object == null) {
                UsefulTestCase.a(76);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw UsefulTestCase.b(illegalAccessException);
        }
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            UsefulTestCase.clearDeclaredFields(object, clazz);
        }
    }

    public static void clearDeclaredFields(Object object, Class clazz) throws IllegalAccessException {
        try {
            if (clazz == null) {
                return;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw UsefulTestCase.b(illegalAccessException);
        }
        for (Field field : clazz.getDeclaredFields()) {
            String string = field.getDeclaringClass().getName();
            try {
                if (string.startsWith("junit.framework.") || string.startsWith("com.intellij.testFramework.")) continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw UsefulTestCase.b(illegalAccessException);
            }
            int n2 = field.getModifiers();
            try {
                try {
                    try {
                        if ((n2 & 0x10) != 0 || (n2 & 8) != 0) continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw UsefulTestCase.b(illegalAccessException);
                    }
                    if (field.getType().isPrimitive()) continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw UsefulTestCase.b(illegalAccessException);
                }
                field.setAccessible(true);
                field.set(object, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw UsefulTestCase.b(illegalAccessException);
            }
        }
    }

    private static void b(CodeStyleSettings codeStyleSettings, CodeStyleSettings codeStyleSettings2) throws Exception {
        block4: {
            try {
                try {
                    if (codeStyleSettings != null && codeStyleSettings2 != null) break block4;
                }
                catch (Exception exception) {
                    throw UsefulTestCase.b(exception);
                }
                return;
            }
            catch (Exception exception) {
                throw UsefulTestCase.b(exception);
            }
        }
        Element element = new Element("temp");
        codeStyleSettings.writeExternal(element);
        Element element2 = new Element("temp");
        codeStyleSettings2.writeExternal(element2);
        String string = JDOMUtil.writeElement((Element)element2);
        String string2 = JDOMUtil.writeElement((Element)element);
        Assert.assertEquals((String)"Code style settings damaged", (Object)string2, (Object)string);
    }

    public boolean isPerformanceTest() {
        String string = this.getName();
        String string2 = ((Object)((Object)this)).getClass().getName();
        return TestFrameworkUtil.isPerformanceTest((String)string, (String)string2);
    }

    public boolean isStressTest() {
        return UsefulTestCase.a(this.getName(), ((Object)((Object)this)).getClass().getName());
    }

    private static boolean a(String string, String string2) {
        boolean bl2;
        block8: {
            block7: {
                try {
                    block6: {
                        try {
                            try {
                                if (TestFrameworkUtil.isPerformanceTest((String)string, (String)string2) || UsefulTestCase.a(string)) break block6;
                            }
                            catch (RuntimeException runtimeException) {
                                throw UsefulTestCase.b(runtimeException);
                            }
                            if (!UsefulTestCase.a(string2)) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw UsefulTestCase.b(runtimeException);
                        }
                    }
                    bl2 = true;
                    break block8;
                }
                catch (RuntimeException runtimeException) {
                    throw UsefulTestCase.b(runtimeException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    private static boolean a(@Nullable String string) {
        boolean bl2;
        block8: {
            block6: {
                try {
                    block7: {
                        try {
                            try {
                                if (string == null) break block6;
                                if (string.contains("Stress")) break block7;
                            }
                            catch (RuntimeException runtimeException) {
                                throw UsefulTestCase.b(runtimeException);
                            }
                            if (!string.contains("Slow")) break block6;
                        }
                        catch (RuntimeException runtimeException) {
                            throw UsefulTestCase.b(runtimeException);
                        }
                    }
                    bl2 = true;
                    break block8;
                }
                catch (RuntimeException runtimeException) {
                    throw UsefulTestCase.b(runtimeException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    public static void doPostponedFormatting(Project project2) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            PostprocessReformattingAspect.getInstance((Project)project2).doPostponedFormatting();
        });
    }

    protected void assertException(AbstractExceptionCase abstractExceptionCase) throws Throwable {
        this.assertException(abstractExceptionCase, null);
    }

    protected void assertException(AbstractExceptionCase abstractExceptionCase, @Nullable String string) throws Throwable {
        UsefulTestCase.a(true, abstractExceptionCase, string);
    }

    public static <T extends Throwable> void assertThrows(@NotNull Class<? extends Throwable> clazz, @NotNull ThrowableRunnable<T> throwableRunnable) throws T {
        try {
            if (clazz == null) {
                UsefulTestCase.a(77);
            }
        }
        catch (Throwable throwable) {
            throw UsefulTestCase.b(throwable);
        }
        try {
            if (throwableRunnable == null) {
                UsefulTestCase.a(78);
            }
        }
        catch (Throwable throwable) {
            throw UsefulTestCase.b(throwable);
        }
        UsefulTestCase.assertThrows(clazz, null, throwableRunnable);
    }

    public static <T extends Throwable> void assertThrows(final @NotNull Class<? extends Throwable> clazz, @Nullable String string, final @NotNull ThrowableRunnable<T> throwableRunnable) throws T {
        try {
            if (clazz == null) {
                UsefulTestCase.a(79);
            }
        }
        catch (Throwable throwable) {
            throw UsefulTestCase.b(throwable);
        }
        try {
            if (throwableRunnable == null) {
                UsefulTestCase.a(80);
            }
        }
        catch (Throwable throwable) {
            throw UsefulTestCase.b(throwable);
        }
        UsefulTestCase.a(true, new AbstractExceptionCase(){

            public Class<Throwable> getExpectedExceptionClass() {
                return clazz;
            }

            @Override
            public void tryClosure() throws Throwable {
                throwableRunnable.run();
            }
        }, string);
    }

    protected <T extends Throwable> void assertNoException(AbstractExceptionCase<T> abstractExceptionCase) throws T {
        UsefulTestCase.a(false, abstractExceptionCase, null);
    }

    protected void assertNoThrowable(Runnable runnable) {
        String string = null;
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            string = throwable.getClass().getName();
        }
        UsefulTestCase.assertNull(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T extends Throwable> void a(boolean bl2, AbstractExceptionCase<T> abstractExceptionCase, String string) throws T {
        boolean bl3 = false;
        abstractExceptionCase.tryClosure();
        if (!bl2) return;
        try {
            if (bl3) return;
            UsefulTestCase.fail((String)abstractExceptionCase.getAssertionErrorMessage());
            return;
        }
        catch (Throwable throwable) {
            throw UsefulTestCase.b(throwable);
        }
        catch (Throwable throwable) {
            block18: {
                try {
                    if (bl2) {
                        bl3 = true;
                        String string2 = abstractExceptionCase.getAssertionErrorMessage();
                        try {
                            UsefulTestCase.assertEquals((String)string2, abstractExceptionCase.getExpectedExceptionClass(), throwable.getClass());
                            if (string != null) {
                                UsefulTestCase.assertEquals((String)"Compare error messages", (String)string, (String)throwable.getMessage());
                            }
                            break block18;
                        }
                        catch (Throwable throwable2) {
                            throw UsefulTestCase.b(throwable2);
                        }
                    }
                    if (!abstractExceptionCase.getExpectedExceptionClass().equals(throwable.getClass())) throw throwable;
                    bl3 = true;
                    System.out.println("");
                    throwable.printStackTrace(System.out);
                    UsefulTestCase.fail((String)("Exception isn't expected here. Exception message: " + throwable.getMessage()));
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            if (!bl2 || bl3) throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throw UsefulTestCase.b(throwable4);
                        }
                        UsefulTestCase.fail((String)abstractExceptionCase.getAssertionErrorMessage());
                        throw throwable3;
                    }
                    catch (Throwable throwable5) {
                        throw UsefulTestCase.b(throwable5);
                    }
                }
            }
            if (!bl2) return;
            try {
                block19: {
                    if (bl3) return;
                    break block19;
                    catch (Throwable throwable6) {
                        throw UsefulTestCase.b(throwable6);
                    }
                }
                UsefulTestCase.fail((String)abstractExceptionCase.getAssertionErrorMessage());
                return;
            }
            catch (Throwable throwable7) {
                throw UsefulTestCase.b(throwable7);
            }
        }
    }

    protected boolean annotatedWith(@NotNull Class<? extends Annotation> clazz) {
        try {
            if (clazz == null) {
                UsefulTestCase.a(81);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        Class<?> clazz2 = ((Object)((Object)this)).getClass();
        String string = "test" + this.getTestName(false);
        boolean bl2 = false;
        while (true) {
            block16: {
                block15: {
                    try {
                        try {
                            try {
                                if (clazz2 == null || clazz2 == Object.class) break;
                            }
                            catch (RuntimeException runtimeException) {
                                throw UsefulTestCase.b(runtimeException);
                            }
                            if (clazz2.getAnnotation(clazz) == null) break block15;
                        }
                        catch (RuntimeException runtimeException) {
                            throw UsefulTestCase.b(runtimeException);
                        }
                        return true;
                    }
                    catch (RuntimeException runtimeException) {
                        throw UsefulTestCase.b(runtimeException);
                    }
                }
                if (!bl2) {
                    block17: {
                        Method method = ReflectionUtil.getDeclaredMethod(clazz2, (String)string, (Class[])new Class[0]);
                        try {
                            try {
                                if (method == null) break block16;
                                if (method.getAnnotation(clazz) == null) break block17;
                            }
                            catch (RuntimeException runtimeException) {
                                throw UsefulTestCase.b(runtimeException);
                            }
                            return true;
                        }
                        catch (RuntimeException runtimeException) {
                            throw UsefulTestCase.b(runtimeException);
                        }
                    }
                    bl2 = true;
                }
            }
            clazz2 = clazz2.getSuperclass();
        }
        return false;
    }

    protected String getHomePath() {
        return PathManager.getHomePath().replace(File.separatorChar, '/');
    }

    public static void refreshRecursively(@NotNull VirtualFile virtualFile) {
        try {
            if (virtualFile == null) {
                UsefulTestCase.a(82);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile virtualFile) {
                try {
                    if (virtualFile == null) {
                        2.a(0);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 2.a(illegalArgumentException);
                }
                virtualFile.getChildren();
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/UsefulTestCase$2", "visitFile"));
            }

            private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
                return illegalArgumentException;
            }
        });
        virtualFile.refresh(false, true);
    }

    @NotNull
    public static Test filteredSuite(@RegExp String string, @NotNull Test test) {
        TestSuite testSuite;
        try {
            if (test == null) {
                UsefulTestCase.a(83);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        final Pattern pattern = Pattern.compile(string);
        final TestSuite testSuite2 = new TestSuite();
        try {
            new Processor<Test>(){

                public boolean process(Test test) {
                    if (test instanceof TestSuite) {
                        int n2 = ((TestSuite)test).testCount();
                        for (int i2 = 0; i2 < n2; ++i2) {
                            this.process(((TestSuite)test).testAt(i2));
                        }
                    } else if (pattern.matcher(test.toString()).find()) {
                        testSuite2.addTest(test);
                    }
                    return false;
                }
            }.process(test);
            testSuite = testSuite2;
            if (testSuite == null) {
                UsefulTestCase.a(84);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        return testSuite;
    }

    @Nullable
    public static VirtualFile refreshAndFindFile(@NotNull File file) {
        try {
            if (file == null) {
                UsefulTestCase.a(85);
            }
        }
        catch (RuntimeException runtimeException) {
            throw UsefulTestCase.b(runtimeException);
        }
        return (VirtualFile)UIUtil.invokeAndWaitIfNeeded(() -> {
            try {
                if (file == null) {
                    UsefulTestCase.a(86);
                }
            }
            catch (RuntimeException runtimeException) {
                throw UsefulTestCase.b(runtimeException);
            }
            return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        });
    }

    static {
        Object object;
        Object object2;
        boolean bl2;
        try {
            bl2 = System.getenv("TEAMCITY_VERSION") != null;
        }
        catch (Exception exception) {
            throw UsefulTestCase.b(exception);
        }
        IS_UNDER_TEAMCITY = bl2;
        OVERWRITE_TESTDATA = Boolean.getBoolean("idea.tests.overwrite.data");
        b = FileUtil.getTempDirectory();
        f = new HashMap();
        h = new HashMap();
        IdeaForkJoinWorkerThreadFactory.setupPoisonFactory();
        Logger.setFactory(TestLoggerFactory.class);
        LOG = Logger.getInstance(UsefulTestCase.class);
        CREATION_PLACE = Key.create((String)"CREATION_PLACE");
        System.setProperty("apple.awt.UIElement", "true");
        try {
            object2 = new CodeInsightSettings();
            object = new Element("temp");
            object2.writeExternal(object);
            g = JDOMUtil.writeElement((Element)object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        try {
            object2 = Class.forName("java.io.DeleteOnExitHook");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        object = (Set)ReflectionUtil.getStaticFieldValue((Class)object2, Set.class, (String)"files");
        e = object2;
        d = object;
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void a(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Throwable b(Throwable throwable) {
        return throwable;
    }

    protected class TestDisposable
    implements Disposable {
        private volatile boolean a;

        public void dispose() {
            this.a = true;
        }

        public boolean isDisposed() {
            return this.a;
        }

        public String toString() {
            String string = UsefulTestCase.this.getTestName(false);
            return ((Object)((Object)UsefulTestCase.this)).getClass() + (StringUtil.isEmpty((String)string) ? "" : ".test" + string);
        }
    }
}

