/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.junit.Assert;

public class EditorMouseFixture {
    private final EditorImpl d;
    private int a;
    private int b;
    private int e;
    private int f = 1;
    private int g;
    private Component c;

    public EditorMouseFixture(EditorImpl editorImpl) {
        this.d = editorImpl;
    }

    public EditorMouseFixture pressAtXY(int n2, int n3) {
        return this.a(1, new Point(n2, n3));
    }

    public EditorMouseFixture pressAt(int n2, int n3) {
        return this.a(1, this.a(n2, n3));
    }

    public EditorMouseFixture pressAtLineNumbers(int n2) {
        assert (this.d.getSettings().isLineNumbersShown());
        return this.a((Component)this.d.getGutterComponentEx(), 1, new Point(0, this.d.visibleLineToY(n2)));
    }

    private EditorMouseFixture a(int n2, Point point) {
        EditorComponentImpl editorComponentImpl = this.d.getContentComponent();
        return this.a((Component)editorComponentImpl, n2, point);
    }

    private EditorMouseFixture a(Component component, int n2, Point point) {
        this.c = component;
        this.g = 501;
        this.a = point.x;
        this.b = point.y;
        component.dispatchEvent(new MouseEvent(this.c, 501, System.currentTimeMillis(), this.a(), this.a, this.b, n2, false, this.f));
        return this;
    }

    public EditorMouseFixture release() {
        return this.a(1);
    }

    private EditorMouseFixture a(int n2) {
        int n3 = this.g;
        this.g = 502;
        this.c.dispatchEvent(new MouseEvent(this.c, 502, System.currentTimeMillis(), this.a(), this.a, this.b, n2, false, this.f));
        if (n3 == 501) {
            this.g = 500;
            this.c.dispatchEvent(new MouseEvent(this.c, 500, System.currentTimeMillis(), this.a(), this.a, this.b, n2, false, this.f));
        }
        this.c = null;
        return this;
    }

    public EditorMouseFixture clickAt(int n2, int n3) {
        return this.pressAt(n2, n3).release();
    }

    public EditorMouseFixture doubleClickAt(int n2, int n3) {
        return this.clickAt(n2, n3).a(2, this.a(n2, n3)).a(2);
    }

    public EditorMouseFixture tripleClickAt(int n2, int n3) {
        return this.doubleClickAt(n2, n3).a(3, this.a(n2, n3)).a(3);
    }

    public EditorMouseFixture dragTo(int n2, int n3) {
        Point point = this.a(n2, n3);
        return this.dragToXY(point.x, point.y);
    }

    public EditorMouseFixture dragToLineNumbers(int n2) {
        assert (this.d.getSettings().isLineNumbersShown());
        return this.a((JComponent)this.d.getGutterComponentEx(), 0, this.d.visibleLineToY(n2));
    }

    public EditorMouseFixture dragToXY(int n2, int n3) {
        Assert.assertFalse((String)"Cannot test mouse dragging: editor visible size is not set. Use EditorTestUtil.setEditorVisibleSize(width, height)", (boolean)this.d.getScrollingModel().getVisibleArea().isEmpty());
        EditorComponentImpl editorComponentImpl = this.d.getContentComponent();
        return this.a((JComponent)editorComponentImpl, n2, n3);
    }

    private EditorMouseFixture a(JComponent jComponent, int n2, int n3) {
        this.g = 506;
        this.a = n2;
        this.b = n3;
        jComponent.dispatchEvent(new MouseEvent(jComponent, 506, System.currentTimeMillis(), this.a(), this.a, this.b, 1, false, this.f));
        return this;
    }

    public EditorMouseFixture ctrl() {
        this.e |= SystemInfo.isMac ? 256 : 128;
        return this;
    }

    public EditorMouseFixture alt() {
        this.e |= 0x200;
        return this;
    }

    public EditorMouseFixture shift() {
        this.e |= 0x40;
        return this;
    }

    public EditorMouseFixture noModifiers() {
        this.e = 0;
        return this;
    }

    public EditorMouseFixture middle() {
        this.f = 2;
        return this;
    }

    public EditorMouseFixture right() {
        this.f = 3;
        return this;
    }

    private Point a(int n2, int n3) {
        return this.d.visualPositionToXY(new VisualPosition(n2, n3));
    }

    private int a() {
        if (this.f == 3) {
            return this.e | 4;
        }
        if (this.f == 2) {
            return this.e | 8;
        }
        return this.e;
    }
}

