/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.descriptors.impl.ConfigFileContainerImpl;
import com.intellij.util.descriptors.impl.ConfigFileImpl;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFileInfoSetImpl
implements ConfigFileInfoSet {
    private static final Logger d = Logger.getInstance((String)"#com.intellij.util.descriptors.impl.ConfigFileInfoSetImpl");
    @NonNls
    private static final String c = "deploymentDescriptor";
    @NonNls
    private static final String f = "name";
    @NonNls
    private static final String e = "url";
    private final MultiValuesMap<ConfigFileMetaData, ConfigFileInfo> a = new MultiValuesMap();
    @Nullable
    private ConfigFileContainerImpl g;
    private final ConfigFileMetaDataProvider b;

    public ConfigFileInfoSetImpl(ConfigFileMetaDataProvider configFileMetaDataProvider) {
        this.b = configFileMetaDataProvider;
    }

    public void addConfigFile(ConfigFileInfo configFileInfo) {
        this.a.put((Object)configFileInfo.getMetaData(), (Object)configFileInfo);
        this.a();
    }

    public void addConfigFile(ConfigFileMetaData configFileMetaData, String string) {
        this.addConfigFile(new ConfigFileInfo(configFileMetaData, string));
    }

    public void removeConfigFile(ConfigFileInfo configFileInfo) {
        this.a.remove((Object)configFileInfo.getMetaData(), (Object)configFileInfo);
        this.a();
    }

    public void replaceConfigFile(ConfigFileMetaData configFileMetaData, String string) {
        this.a.removeAll((Object)configFileMetaData);
        this.addConfigFile(new ConfigFileInfo(configFileMetaData, string));
    }

    public ConfigFileInfo updateConfigFile(ConfigFile configFile) {
        this.a.remove((Object)configFile.getMetaData(), (Object)configFile.getInfo());
        ConfigFileInfo configFileInfo = new ConfigFileInfo(configFile.getMetaData(), configFile.getUrl());
        this.a.put((Object)configFileInfo.getMetaData(), (Object)configFileInfo);
        ((ConfigFileImpl)configFile).setInfo(configFileInfo);
        return configFileInfo;
    }

    public void removeConfigFiles(ConfigFileMetaData ... configFileMetaDataArray) {
        for (ConfigFileMetaData configFileMetaData : configFileMetaDataArray) {
            this.a.removeAll((Object)configFileMetaData);
        }
        this.a();
    }

    @Nullable
    public ConfigFileInfo getConfigFileInfo(ConfigFileMetaData configFileMetaData) {
        Collection collection;
        block4: {
            collection = this.a.get((Object)configFileMetaData);
            try {
                try {
                    if (collection != null && !collection.isEmpty()) break block4;
                }
                catch (InvalidDataException invalidDataException) {
                    throw ConfigFileInfoSetImpl.b(invalidDataException);
                }
                return null;
            }
            catch (InvalidDataException invalidDataException) {
                throw ConfigFileInfoSetImpl.b(invalidDataException);
            }
        }
        return (ConfigFileInfo)collection.iterator().next();
    }

    public ConfigFileInfo[] getConfigFileInfos() {
        Collection collection = this.a.values();
        return collection.toArray(new ConfigFileInfo[collection.size()]);
    }

    public void setConfigFileInfos(Collection<ConfigFileInfo> collection) {
        this.a.clear();
        for (ConfigFileInfo configFileInfo : collection) {
            this.a.put((Object)configFileInfo.getMetaData(), (Object)configFileInfo);
        }
        this.a();
    }

    private void a() {
        try {
            if (this.g != null) {
                this.g.updateDescriptors(this.a);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ConfigFileInfoSetImpl.b(invalidDataException);
        }
    }

    public ConfigFileMetaDataProvider getMetaDataProvider() {
        return this.b;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.a.clear();
        List list = element.getChildren(c);
        for (Element element2 : list) {
            ConfigFileMetaData configFileMetaData;
            String string = element2.getAttributeValue(f);
            if (string == null || (configFileMetaData = this.b.findMetaData(string)) == null) continue;
            String string2 = element2.getAttributeValue(e);
            try {
                if (string2 == null) {
                    throw new InvalidDataException("url attribute not specified for " + string + " descriptor");
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw ConfigFileInfoSetImpl.b(invalidDataException);
            }
            this.a.put((Object)configFileMetaData, (Object)new ConfigFileInfo(configFileMetaData, string2));
        }
        this.a();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        TreeSet treeSet = new TreeSet((configFileInfo, configFileInfo2) -> {
            int n2;
            int n3 = Comparing.compare((Comparable)((Object)configFileInfo.getMetaData().getId()), (Comparable)((Object)configFileInfo2.getMetaData().getId()));
            try {
                n2 = n3 != 0 ? n3 : Comparing.compare((Comparable)((Object)configFileInfo.getUrl()), (Comparable)((Object)configFileInfo2.getUrl()));
            }
            catch (InvalidDataException invalidDataException) {
                throw ConfigFileInfoSetImpl.b(invalidDataException);
            }
            return n2;
        });
        treeSet.addAll(this.a.values());
        for (ConfigFileInfo configFileInfo3 : treeSet) {
            Element element2 = new Element(c);
            ConfigFileMetaData configFileMetaData = configFileInfo3.getMetaData();
            element2.setAttribute(f, configFileMetaData.getId());
            element2.setAttribute(e, configFileInfo3.getUrl());
            element.addContent(element2);
        }
    }

    public void setContainer(@NotNull ConfigFileContainerImpl configFileContainerImpl) {
        boolean bl2;
        Logger logger;
        try {
            if (configFileContainerImpl == null) {
                ConfigFileInfoSetImpl.a(0);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ConfigFileInfoSetImpl.b(invalidDataException);
        }
        try {
            logger = d;
            bl2 = this.g == null;
        }
        catch (InvalidDataException invalidDataException) {
            throw ConfigFileInfoSetImpl.b(invalidDataException);
        }
        logger.assertTrue(bl2);
        this.g = configFileContainerImpl;
        this.g.updateDescriptors(this.a);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/util/descriptors/impl/ConfigFileInfoSetImpl", "setContainer"));
    }

    private static InvalidDataException b(InvalidDataException invalidDataException) {
        return invalidDataException;
    }
}

