/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.ui.BaseModifiableControl;
import com.intellij.util.xml.ui.DomWrapper;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class EditorTextFieldControl<T extends JComponent>
extends BaseModifiableControl<T, String> {
    private static final JTextField a = new JTextField(){

        @Override
        public void addNotify() {
            throw new UnsupportedOperationException("Shouldn't be shown");
        }

        @Override
        public void setVisible(boolean bl2) {
            throw new UnsupportedOperationException("Shouldn't be shown");
        }
    };
    private final boolean b;
    private final DocumentListener c = new DocumentListener(){

        public void documentChanged(DocumentEvent documentEvent) {
            EditorTextFieldControl.this.setModified();
            if (EditorTextFieldControl.this.b) {
                EditorTextFieldControl.this.commit();
            }
        }
    };

    protected EditorTextFieldControl(DomWrapper<String> domWrapper, boolean bl2) {
        super(domWrapper);
        this.b = bl2;
    }

    protected EditorTextFieldControl(DomWrapper<String> domWrapper) {
        this(domWrapper, false);
    }

    protected abstract EditorTextField getEditorTextField(@NotNull T var1);

    protected void doReset() {
        EditorTextField editorTextField = this.getEditorTextField(this.getComponent());
        editorTextField.getDocument().removeDocumentListener(this.c);
        super.doReset();
        editorTextField.getDocument().addDocumentListener(this.c);
    }

    protected JComponent getComponentToListenFocusLost(T t2) {
        return this.getEditorTextField(this.getComponent());
    }

    protected JComponent getHighlightedComponent(T t2) {
        return a;
    }

    protected T createMainComponent(T t2) {
        Project project2 = this.getProject();
        t2 = this.createMainComponent(t2, project2);
        EditorTextField editorTextField = this.getEditorTextField(t2);
        editorTextField.setSupplementary(true);
        editorTextField.getDocument().addDocumentListener(this.c);
        return t2;
    }

    protected abstract T createMainComponent(T var1, Project var2);

    @NotNull
    protected String getValue() {
        String string;
        try {
            string = this.getEditorTextField(this.getComponent()).getText();
            if (string == null) {
                EditorTextFieldControl.a(0);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw EditorTextFieldControl.a(illegalStateException);
        }
        return string;
    }

    protected void setValue(final String string) {
        CommandProcessor.getInstance().runUndoTransparentAction(() -> new WriteAction(){

            protected void run(@NotNull Result result2) throws Throwable {
                String string2;
                int n2;
                int n3;
                Document document;
                try {
                    if (result2 == null) {
                        3.a(0);
                    }
                }
                catch (Throwable throwable) {
                    throw 3.b(throwable);
                }
                JComponent jComponent = EditorTextFieldControl.this.getComponent();
                Document document2 = EditorTextFieldControl.this.getEditorTextField(jComponent).getDocument();
                try {
                    document = document2;
                    n3 = 0;
                    n2 = document2.getTextLength();
                    string2 = string == null ? "" : string;
                }
                catch (Throwable throwable) {
                    throw 3.b(throwable);
                }
                document.replaceString(n3, n2, (CharSequence)string2);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/xml/ui/EditorTextFieldControl$3", "run"));
            }

            private static Throwable b(Throwable throwable) {
                return throwable;
            }
        }.execute());
    }

    protected void updateComponent() {
        block4: {
            DomElement domElement = this.getDomElement();
            try {
                try {
                    if (domElement != null && domElement.isValid()) break block4;
                }
                catch (IllegalStateException illegalStateException) {
                    throw EditorTextFieldControl.a(illegalStateException);
                }
                return;
            }
            catch (IllegalStateException illegalStateException) {
                throw EditorTextFieldControl.a(illegalStateException);
            }
        }
        EditorTextField editorTextField = this.getEditorTextField(this.getComponent());
        Project project2 = this.getProject();
        ApplicationManager.getApplication().invokeLater(() -> {
            Color color;
            block18: {
                List list;
                block19: {
                    ArrayList arrayList;
                    block17: {
                        DomElement domElement;
                        block16: {
                            try {
                                if (!project2.isOpen()) {
                                    return;
                                }
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw EditorTextFieldControl.a(illegalStateException);
                            }
                            try {
                                if (!this.getDomWrapper().isValid()) {
                                    return;
                                }
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw EditorTextFieldControl.a(illegalStateException);
                            }
                            domElement = this.getDomElement();
                            try {
                                try {
                                    if (domElement != null && domElement.isValid()) break block16;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw EditorTextFieldControl.a(illegalStateException);
                                }
                                return;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw EditorTextFieldControl.a(illegalStateException);
                            }
                        }
                        DomElementAnnotationsManager domElementAnnotationsManager = DomElementAnnotationsManager.getInstance((Project)project2);
                        DomElementsProblemsHolder domElementsProblemsHolder = domElementAnnotationsManager.getCachedProblemHolder(domElement);
                        list = domElementsProblemsHolder.getProblems(domElement);
                        arrayList = new ArrayList(domElementsProblemsHolder.getProblems(domElement, true, HighlightSeverity.WARNING));
                        arrayList.removeAll(list);
                        color = this.getDefaultBackground();
                        try {
                            if (list.size() <= 0 || editorTextField.getText().trim().length() != 0) break block17;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw EditorTextFieldControl.a(illegalStateException);
                        }
                        color = this.getErrorBackground();
                        break block19;
                    }
                    if (arrayList.size() > 0) {
                        color = this.getWarningBackground();
                    }
                }
                Editor editor = editorTextField.getEditor();
                if (editor != null) {
                    MarkupModel markupModel = editor.getMarkupModel();
                    try {
                        markupModel.removeAllHighlighters();
                        if (list.isEmpty() || editor.getDocument().getLineCount() <= 0) break block18;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw EditorTextFieldControl.a(illegalStateException);
                    }
                    TextAttributes textAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES.toTextAttributes();
                    textAttributes.setEffectType(EffectType.WAVE_UNDERSCORE);
                    textAttributes.setEffectColor(textAttributes.getForegroundColor());
                    markupModel.addLineHighlighter(0, 0, textAttributes);
                    editor.getContentComponent().setToolTipText(((DomElementProblemDescriptor)list.get(0)).getDescriptionTemplate());
                }
            }
            editorTextField.setBackground(color);
        });
    }

    public boolean canNavigate(DomElement domElement) {
        return this.getDomElement().equals(domElement);
    }

    public void navigate(DomElement domElement) {
        EditorTextField editorTextField = this.getEditorTextField(this.getComponent());
        SwingUtilities.invokeLater(() -> {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)editorTextField, true));
            editorTextField.selectAll();
        });
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ui/EditorTextFieldControl", "getValue"));
    }

    private static IllegalStateException a(IllegalStateException illegalStateException) {
        return illegalStateException;
    }
}

