/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rsa;

import com.intellij.a.b.p;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSADecoder {
    private final BigInteger a;
    private final BigInteger d;
    private final BigInteger e;
    private final int b;
    private final int c;

    public RSADecoder(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, bigInteger2, 16);
    }

    public RSADecoder(BigInteger bigInteger, BigInteger bigInteger2, int n2) {
        this.e = bigInteger2;
        this.d = bigInteger;
        int n3 = bigInteger2.bitLength();
        this.c = n3 / 8 - 1;
        int n4 = (int)Math.ceil((double)n3 / Math.log(n2) * Math.log(2.0));
        if (n4 % 5 != 0) {
            n4 = (n4 / 5 + 1) * 5;
        }
        this.b = n4;
        this.a = new BigInteger(Integer.toString(n2));
    }

    /*
     * Loose catch block
     */
    public byte[] decode(String string) throws p {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BigInteger bigInteger = BigInteger.ZERO;
            int n2 = 0;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2;
                block15: {
                    block17: {
                        block16: {
                            c2 = string.charAt(i2);
                            if (c2 == ' ') continue;
                            if (c2 == '\t') continue;
                            break block16;
                            catch (IOException iOException) {
                                throw RSADecoder.a(iOException);
                            }
                        }
                        if (c2 == '\n') continue;
                        break block17;
                        catch (IOException iOException) {
                            throw RSADecoder.a(iOException);
                        }
                    }
                    try {
                        if (c2 == '-') {
                            continue;
                        }
                        break block15;
                        catch (IOException iOException) {
                            throw RSADecoder.a(iOException);
                        }
                    }
                    catch (IOException iOException) {
                        throw RSADecoder.a(iOException);
                    }
                }
                bigInteger = bigInteger.multiply(this.a).add(RSADecoder.a(c2));
                if (++n2 != this.b) continue;
                BigInteger bigInteger2 = bigInteger.modPow(this.d, this.e);
                byte[] byArray = bigInteger2.toByteArray();
                byteArrayOutputStream.write(byArray, Math.max(byArray.length - this.c, 0), Math.min(byArray.length, this.c));
                bigInteger = BigInteger.ZERO;
                n2 = 0;
                continue;
            }
            try {
                if (n2 != 0) {
                    throw new p();
                }
            }
            catch (IOException iOException) {
                throw RSADecoder.a(iOException);
            }
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    private static BigInteger a(char c2) throws p {
        int n2;
        block12: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            try {
                                if ('0' > c2 || c2 > '9') break block8;
                            }
                            catch (p p2) {
                                throw RSADecoder.a(p2);
                            }
                            n2 = c2 - 48;
                            break block12;
                        }
                        try {
                            if ('A' > c2 || c2 > 'Z') break block9;
                        }
                        catch (p p3) {
                            throw RSADecoder.a(p3);
                        }
                        n2 = c2 - 65 + 10;
                        break block12;
                    }
                    try {
                        if ('a' > c2 || c2 > 'z') break block10;
                    }
                    catch (p p4) {
                        throw RSADecoder.a(p4);
                    }
                    n2 = c2 - 97 + 36;
                    break block12;
                }
                try {
                    if ('!' > c2 || c2 > ')') break block11;
                }
                catch (p p5) {
                    throw RSADecoder.a(p5);
                }
                n2 = c2 - 33 + 62;
                break block12;
            }
            throw new p();
        }
        return BigInteger.valueOf(n2);
    }

    public String decodeString(String string) throws p {
        try {
            return new String(this.decode(string), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public Map<String, String> decodeProperties(String string) throws p {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = this.decodeString(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

