/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rsa;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSAEncoder {
    private final BigInteger f;
    private final BigInteger c;
    private final int g;
    private final int a;
    private int e = 0;
    private final BigInteger d;
    private final boolean b;

    public RSAEncoder(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, bigInteger2, 16, true);
    }

    public RSAEncoder(BigInteger bigInteger, BigInteger bigInteger2, int n2, boolean bl2) {
        this.f = bigInteger;
        this.c = bigInteger2;
        this.b = bl2;
        int n3 = bigInteger2.bitLength();
        this.d = new BigInteger(String.valueOf(n2));
        int n4 = (int)Math.ceil((double)n3 / Math.log(n2) * Math.log(2.0));
        if (n4 % 5 != 0) {
            n4 = (n4 / 5 + 1) * 5;
        }
        this.a = n4;
        this.g = n3 / 8 - 1;
    }

    public String encode(byte[] byArray) {
        byte[] byArray2;
        int n2 = byArray.length % this.g;
        if (n2 == 0) {
            byArray2 = byArray;
        } else {
            byArray2 = new byte[byArray.length + this.g - n2];
            System.arraycopy(byArray, 0, byArray2, this.g - n2, byArray.length);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < byArray2.length; i2 += this.g) {
            this.a(byArray2, stringBuilder, i2, this.g);
        }
        return stringBuilder.toString();
    }

    public String encodeString(String string) {
        try {
            return this.encode(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private void a(byte[] byArray, StringBuilder stringBuilder, int n2, int n3) {
        try {
            if (n3 == 0) {
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw RSAEncoder.a(illegalArgumentException);
        }
        byte[] byArray2 = new byte[this.g];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        try {
            if (bigInteger.compareTo(this.c) >= 0) {
                throw new IllegalArgumentException("result is too long");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw RSAEncoder.a(illegalArgumentException);
        }
        BigInteger bigInteger2 = bigInteger.modPow(this.f, this.c);
        this.a(stringBuilder, this.b(bigInteger2));
    }

    private void a(StringBuilder stringBuilder, CharSequence charSequence) {
        try {
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                this.a(stringBuilder);
                stringBuilder.append(charSequence.charAt(i2));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw RSAEncoder.a(illegalArgumentException);
        }
    }

    private CharSequence b(BigInteger bigInteger) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.a; ++i2) {
            stringBuilder.append(RSAEncoder.a(bigInteger.mod(this.d)));
            bigInteger = bigInteger.divide(this.d);
        }
        return new ReverseCharSequence(stringBuilder);
    }

    private void a(StringBuilder stringBuilder) {
        block9: {
            block10: {
                try {
                    try {
                        try {
                            if (this.e <= 0 || this.e % 5 != 0) break block9;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw RSAEncoder.a(illegalArgumentException);
                        }
                        if (this.e % 30 != 0) break block10;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw RSAEncoder.a(illegalArgumentException);
                    }
                    stringBuilder.append('\n');
                    break block9;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw RSAEncoder.a(illegalArgumentException);
                }
            }
            try {
                if (this.b) {
                    stringBuilder.append('-');
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw RSAEncoder.a(illegalArgumentException);
            }
        }
        ++this.e;
    }

    private static char a(BigInteger bigInteger) {
        int n2 = bigInteger.intValue();
        char c2 = n2 < 10 ? (char)(48 + n2) : (n2 < 36 ? (char)(65 + n2 - 10) : (n2 < 62 ? (char)(97 + n2 - 36) : (char)(33 + n2 - 62)));
        return c2;
    }

    public String encodeProperties(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string;
            String string2;
            block5: {
                string2 = entry.getKey();
                string = entry.getValue();
                try {
                    try {
                        if (string2.indexOf(10) < 0 && string.indexOf(10) < 0) break block5;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw RSAEncoder.a(illegalArgumentException);
                    }
                    throw new RuntimeException("Keys and values are not allowed to contain linefeeds");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw RSAEncoder.a(illegalArgumentException);
                }
            }
            stringBuilder.append(string2).append('\n').append(string).append('\n');
        }
        return this.encodeString(stringBuilder.toString());
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static class ReverseCharSequence
    implements CharSequence {
        private final CharSequence a;

        public ReverseCharSequence(CharSequence charSequence) {
            this.a = charSequence;
        }

        public int length() {
            return this.a.length();
        }

        public char charAt(int n2) {
            return this.a.charAt(this.a.length() - n2 - 1);
        }

        public CharSequence subSequence(int n2, int n3) {
            int n4 = this.a.length();
            return new ReverseCharSequence(this.a.subSequence(n4 - n3, n4 - n2));
        }
    }
}

