/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot;

import com.intellij.internal.statistic.AbstractProjectsUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.properties.jam.ConfigurationProperties;
import com.intellij.spring.boot.model.properties.jam.NestedConfigurationProperty;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringBootUsagesCollector
extends AbstractProjectsUsagesCollector {
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            SpringBootUsagesCollector.$$$reportNull$$$0(0);
        }
        HashSet usages = new HashSet();
        ApplicationManager.getApplication().runReadAction(() -> SpringBootUsagesCollector.lambda$getProjectUsages$0(project, (Set)usages));
        HashSet hashSet = usages;
        if (hashSet == null) {
            SpringBootUsagesCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)"Spring Boot");
        if (groupDescriptor == null) {
            SpringBootUsagesCollector.$$$reportNull$$$0(2);
        }
        return groupDescriptor;
    }

    private static void recordConfigFileUsages(Set<UsageDescriptor> usages, Project project, GlobalSearchScope scope, String configFileName) {
        Collection files = FilenameIndex.getVirtualFilesByName((Project)project, (String)configFileName, (GlobalSearchScope)scope);
        if (!files.isEmpty()) {
            usages.add(new UsageDescriptor(configFileName, files.size()));
        }
    }

    private static /* synthetic */ void lambda$getProjectUsages$0(@NotNull Project project, Set usages) {
        if (project == null) {
            SpringBootUsagesCollector.$$$reportNull$$$0(3);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Project)project)) {
            return;
        }
        int springBootModulesPerProject = 0;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            List configurationPropertiesMethods;
            if (!SpringBootLibraryUtil.hasSpringBootLibrary((Module)module)) continue;
            ++springBootModulesPerProject;
            if (SpringBootLibraryUtil.hasDevtools((Module)module)) {
                usages.add(new UsageDescriptor("SpringBootDevTools"));
            }
            GlobalSearchScope scope = module.getModuleScope(false);
            SpringBootUsagesCollector.recordConfigFileUsages(usages, project, scope, "application.properties");
            SpringBootUsagesCollector.recordConfigFileUsages(usages, project, scope, "bootstrap.properties");
            SpringBootUsagesCollector.recordConfigFileUsages(usages, project, scope, "additional-spring-configuration-metadata.json");
            SpringBootUsagesCollector.recordConfigFileUsages(usages, project, scope, "application.yml");
            SpringBootUsagesCollector.recordConfigFileUsages(usages, project, scope, "application.yaml");
            SpringBootUsagesCollector.recordConfigFileUsages(usages, project, scope, "bootstrap.yml");
            SpringBootUsagesCollector.recordConfigFileUsages(usages, project, scope, "bootstrap.yaml");
            SpringBootUsagesCollector.recordConfigFileUsages(usages, project, scope, "devtools.properties");
            SpringBootUsagesCollector.recordConfigFileUsages(usages, project, scope, "devtools.yml");
            SpringBootUsagesCollector.recordConfigFileUsages(usages, project, scope, "devtools.yaml");
            List configurationProperties = JamService.getJamService((Project)project).getJamClassElements((JamMemberMeta)ConfigurationProperties.CLASS_META, "org.springframework.boot.context.properties.ConfigurationProperties", scope);
            if (!configurationProperties.isEmpty()) {
                usages.add(new UsageDescriptor("ConfigurationProperties_" + configurationProperties.size()));
                List nestedConfigurationProperties = JamService.getJamService((Project)project).getJamFieldElements((JamMemberMeta)NestedConfigurationProperty.FIELD_META, "org.springframework.boot.context.properties.NestedConfigurationProperty", scope);
                if (!nestedConfigurationProperties.isEmpty()) {
                    usages.add(new UsageDescriptor("NestedConfigurationProperty_" + configurationProperties.size()));
                }
            }
            if ((configurationPropertiesMethods = JamService.getJamService((Project)project).getJamMethodElements((JamMemberMeta)ConfigurationProperties.Method.METHOD_META, "org.springframework.boot.context.properties.ConfigurationProperties", scope)).isEmpty()) continue;
            usages.add(new UsageDescriptor("ConfigurationProperties_Methods_" + configurationPropertiesMethods.size()));
        }
        usages.add(new UsageDescriptor("SpringBootModulesPerProject_" + springBootModulesPerProject));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/SpringBootUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/SpringBootUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectUsages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectUsages";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getProjectUsages$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

