/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.config.hints.SpringBootHintReferenceProviderBase;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BeanReferenceProvider
extends SpringBootHintReferenceProviderBase {
    @Nullable
    private final String myBaseClass;

    BeanReferenceProvider(@Nullable String baseClass) {
        this.myBaseClass = baseClass;
    }

    @Override
    @NotNull
    protected PsiReference createReference(PsiElement element, TextRange textRange, ProcessingContext context) {
        PsiClass requiredClass = this.myBaseClass == null ? null : JavaPsiFacade.getInstance((Project)element.getProject()).findClass(this.myBaseClass, element.getResolveScope());
        SpringBeanReference springBeanReference = new SpringBeanReference(element, textRange, requiredClass, false);
        if (springBeanReference == null) {
            BeanReferenceProvider.$$$reportNull$$$0(0);
        }
        return springBeanReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/BeanReferenceProvider", "createReference"));
    }
}

