/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.spring.boot.application.config.hints.SpringBootHintReferenceProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LoggerNameReferenceProvider
implements SpringBootHintReferenceProvider {
    private final String myKeyPrefix;

    public LoggerNameReferenceProvider(String prefix) {
        this.myKeyPrefix = prefix;
    }

    @Override
    public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
        String packageText;
        if (element == null) {
            LoggerNameReferenceProvider.$$$reportNull$$$0(0);
        }
        if (textRanges == null) {
            LoggerNameReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            LoggerNameReferenceProvider.$$$reportNull$$$0(2);
        }
        if ((packageText = StringUtil.substringAfter((String)element.getText(), (String)this.myKeyPrefix)) == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] allReferences = PsiReference.EMPTY_ARRAY;
        for (TextRange range : textRanges) {
            int offset = range.getStartOffset() + this.myKeyPrefix.length();
            JavaClassReferenceSet set = new JavaClassReferenceSet(packageText, element, offset, false, new JavaClassReferenceProvider());
            PackageReferenceSet packageReferenceSet = new PackageReferenceSet(packageText, element, offset);
            allReferences = (PsiReference[])ArrayUtil.mergeArrays((Object[])set.getReferences(), (Object[])packageReferenceSet.getPsiReferences());
        }
        return allReferences;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "textRanges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/application/config/hints/LoggerNameReferenceProvider";
        objectArray[2] = "getReferences";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

