/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.config.hints.HintReferenceBase;
import com.intellij.spring.boot.application.config.hints.SpringBootHintReferenceProviderBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RegExReferenceProvider
extends SpringBootHintReferenceProviderBase {
    private final Pattern myPattern;

    RegExReferenceProvider(String regExPattern) {
        this.myPattern = Pattern.compile(regExPattern);
    }

    @Override
    @NotNull
    protected PsiReference createReference(PsiElement element, TextRange textRange, ProcessingContext context) {
        HintReferenceBase hintReferenceBase = new HintReferenceBase(element, textRange){

            @Nullable
            protected PsiElement doResolve() {
                if (RegExReferenceProvider.this.myPattern.matcher(this.getValue()).matches()) {
                    return this.getElement();
                }
                return null;
            }

            @NotNull
            public Object[] getVariants() {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }

            @NotNull
            public String getUnresolvedMessagePattern() {
                String string = "Value ''{0}'' does not match pattern ''" + RegExReferenceProvider.this.myPattern + "''";
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/spring/boot/application/config/hints/RegExReferenceProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnresolvedMessagePattern";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (hintReferenceBase == null) {
            RegExReferenceProvider.$$$reportNull$$$0(0);
        }
        return hintReferenceBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/RegExReferenceProvider", "createReference"));
    }
}

