/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.config.hints.BeanReferenceProvider;
import com.intellij.spring.boot.application.config.hints.DurationReferenceProvider;
import com.intellij.spring.boot.application.config.hints.EncodingReferenceProvider;
import com.intellij.spring.boot.application.config.hints.EnumReferenceProvider;
import com.intellij.spring.boot.application.config.hints.FloatReferenceProvider;
import com.intellij.spring.boot.application.config.hints.IntegerReferenceProvider;
import com.intellij.spring.boot.application.config.hints.LoggerNameReferenceProvider;
import com.intellij.spring.boot.application.config.hints.LongReferenceProvider;
import com.intellij.spring.boot.application.config.hints.RegExReferenceProvider;
import com.intellij.spring.boot.application.config.hints.ResourceReferenceProvider;
import com.intellij.spring.boot.application.config.hints.SpringBootHintReferenceProvider;
import com.intellij.spring.boot.application.config.hints.SpringBootHintReferenceProviderBase;
import com.intellij.spring.boot.application.config.hints.SpringBootHintRegistryInfo;
import com.intellij.spring.boot.application.config.hints.SpringBootHintRegistryKey;
import com.intellij.spring.boot.application.config.hints.StaticValuesReferenceProvider;
import com.intellij.spring.boot.application.config.hints.ValueHintReferenceProvider;
import com.intellij.spring.boot.application.config.keyPath.ConfigKeyPathReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootValueProvider;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.model.converters.PatternFileReferenceSet;
import com.intellij.spring.profiles.SpringProfilePsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.xml.util.HtmlUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootHintReferencesProviderImpl
extends SpringBootHintReferencesProvider {
    private static final String STATIC = "static";
    private static final String ENUM_VALUES = "enumValues";
    private static final String REGEX = "regex";
    private static final String RESOURCE = "resource";
    private static final String PATH_PATTERN = "pathPattern";
    private static final String SPRING_PROFILE_NAME = SpringBootValueProvider.SPRING_PROFILE_NAME.getId();
    private final SpringBootHintReferenceProvider mySpringProfileHintReferenceProvider = new SpringBootHintReferenceProviderBase(){

        @Override
        protected boolean canProcess(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (textRanges == null) {
                1.$$$reportNull$$$0(1);
            }
            if (context == null) {
                1.$$$reportNull$$$0(2);
            }
            return ModuleUtilCore.findModuleForPsiElement((PsiElement)element) != null;
        }

        @Override
        @NotNull
        protected PsiReference createReference(PsiElement element, TextRange textRange, ProcessingContext context) {
            String elementText = ElementManipulators.getValueText((PsiElement)element);
            String tokenText = textRange.substring(elementText);
            if (StringUtil.startsWithChar((CharSequence)tokenText, (char)'!')) {
                textRange = textRange.shiftRight(1).grown(-1);
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            assert (module != null);
            SpringProfilePsiReference springProfilePsiReference = new SpringProfilePsiReference(element, textRange, module, false);
            if (springProfilePsiReference == null) {
                1.$$$reportNull$$$0(3);
            }
            return springProfilePsiReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRanges";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$1";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "canProcess";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private final SpringBootHintReferenceProvider myDummyProvider = new SpringBootHintReferenceProvider(){

        @Override
        public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
            if (element == null) {
                2.$$$reportNull$$$0(0);
            }
            if (textRanges == null) {
                2.$$$reportNull$$$0(1);
            }
            if (context == null) {
                2.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "textRanges";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$2";
            objectArray[2] = "getReferences";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final StaticValuesReferenceProvider myLocaleProvider = new StaticValuesReferenceProvider(true, true, null, (String[])ContainerUtil.map2Array((Object[])Locale.getAvailableLocales(), String.class, locale -> {
        String country = locale.getCountry();
        String language = locale.getLanguage();
        return country.isEmpty() ? language : language + "_" + country;
    }));
    private final StaticValuesReferenceProvider myContentTypeProvider = new StaticValuesReferenceProvider(true, true, null, HtmlUtil.CONTENT_TYPES);
    private final EncodingReferenceProvider myEncodingProvider = new EncodingReferenceProvider();
    private final Map<String, String> myExplicitMappings = new THashMap();
    private final Map<String, SpringBootHintReferenceProvider> myExplicitProviders = new THashMap();
    private final Map<String, SpringBootHintReferenceProvider> myBuiltinProviders = new THashMap();
    private final Set<String> myOverrideKeys = new THashSet();
    private final Map<String, SpringBootHintReferenceProvider> myByTypeProviders = ContainerUtil.immutableMapBuilder().put((Object)"java.lang.Boolean", (Object)new StaticValuesReferenceProvider(false, false, DefaultLanguageHighlighterColors.KEYWORD, "true", "false")).put((Object)"java.lang.Integer", (Object)new IntegerReferenceProvider()).put((Object)"java.lang.Long", (Object)new LongReferenceProvider()).put((Object)"java.lang.Float", (Object)new FloatReferenceProvider()).put((Object)"java.nio.charset.Charset", (Object)this.myEncodingProvider).put((Object)"org.springframework.util.MimeType", (Object)this.myContentTypeProvider).put((Object)"org.springframework.core.io.Resource", (Object)new ResourceReferenceProvider()).put((Object)"java.util.Locale", (Object)this.myLocaleProvider).put((Object)"java.time.Duration", (Object)new DurationReferenceProvider()).build();

    protected SpringBootHintReferencesProviderImpl() {
        this.myBuiltinProviders.put(SPRING_PROFILE_NAME, this.mySpringProfileHintReferenceProvider);
        this.myBuiltinProviders.put(RESOURCE, new ResourceReferenceProvider());
        this.myBuiltinProviders.put(PATH_PATTERN, new SpringBootHintReferenceProvider(){

            @Override
            public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (textRanges == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(2);
                }
                String valueText = ElementManipulators.getValueText((PsiElement)element);
                Object[] allReferences = PsiReference.EMPTY_ARRAY;
                for (TextRange range : textRanges) {
                    Object[] references = new PatternFileReferenceSet(range.substring(valueText), element, range.getStartOffset(), true).getAllReferences();
                    allReferences = (PsiReference[])ArrayUtil.mergeArrays((Object[])allReferences, (Object[])references);
                }
                return allReferences;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "textRanges";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$3";
                objectArray[2] = "getReferences";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.loadExplicitMappings();
    }

    private void loadExplicitMappings() {
        URL url = SpringBootHintReferencesProviderImpl.class.getResource("spring-boot-hint-registry.xml");
        SpringBootHintRegistryInfo info = (SpringBootHintRegistryInfo)XmlSerializer.deserialize((URL)url, SpringBootHintRegistryInfo.class);
        for (SpringBootHintRegistryKey key : ((SpringBootHintRegistryInfo)ObjectUtils.assertNotNull((Object)info)).myKeys) {
            String providerId = key.myProvider;
            if (key.myOverride) {
                this.myOverrideKeys.add(key.myId);
            }
            if (providerId.equals(STATIC) || providerId.equals(ENUM_VALUES)) {
                this.myExplicitProviders.put(key.myId, SpringBootHintReferencesProviderImpl.createStaticOrEnumReferenceProvider(key));
                continue;
            }
            if (providerId.equals(SpringBootValueProvider.SPRING_BEAN_REFERENCE.getId())) {
                this.myExplicitProviders.put(key.myId, new BeanReferenceProvider(key.myValue));
                continue;
            }
            if (providerId.equals(SpringBootValueProvider.CLASS_REFERENCE.getId())) {
                this.myExplicitProviders.put(key.myId, SpringBootHintReferencesProviderImpl.createClassReferenceProvider(key.myValue, key.myAllowOtherValues, true));
                continue;
            }
            if (providerId.equals(REGEX)) {
                this.myExplicitProviders.put(key.myId, new RegExReferenceProvider(key.myValue));
                continue;
            }
            if (providerId.equals(RESOURCE) || providerId.equals(PATH_PATTERN) || providerId.equals(SPRING_PROFILE_NAME)) {
                this.myExplicitMappings.put(key.myId, providerId);
                continue;
            }
            throw new IllegalArgumentException(providerId);
        }
    }

    @NotNull
    public PsiReference[] getKeyReferences(Module module, SpringBootApplicationMetaConfigKey configKey, PsiElement keyPsiElement, ProcessingContext context) {
        if (configKey.getKeyItemHint() != SpringBootApplicationMetaConfigKey.ItemHint.NONE) {
            PsiReference[] psiReferenceArray = this.getItemHintReferences(configKey, ItemHintType.KEY, keyPsiElement, Collections.singletonList(ElementManipulators.getValueTextRange((PsiElement)keyPsiElement)), context);
            if (psiReferenceArray == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(0);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(1);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @NotNull
    public PsiReference[] getValueReferences(Module module, SpringBootApplicationMetaConfigKey configKey, @Nullable PsiElement keyPsiElement, PsiElement valuePsiElement, List<TextRange> valueTextRanges, ProcessingContext context) {
        if (!SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0)) {
            PsiReference[] psiReferenceArray = this.getFallbackProvider(configKey).getReferences(valuePsiElement, valueTextRanges, context);
            if (psiReferenceArray == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        if (configKey.getItemHint() != SpringBootApplicationMetaConfigKey.ItemHint.NONE) {
            PsiReference[] psiReferenceArray = this.getItemHintReferences(configKey, ItemHintType.VALUE, valuePsiElement, valueTextRanges, context);
            if (psiReferenceArray == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        SpringBootHintReferenceProvider byTypeOrExplicitProvider = this.getByTypeOrExplicitProvider(configKey);
        if (byTypeOrExplicitProvider != this.myDummyProvider) {
            PsiReference[] psiReferenceArray = byTypeOrExplicitProvider.getReferences(valuePsiElement, valueTextRanges, context);
            if (psiReferenceArray == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }
        if (keyPsiElement == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] overrideOtherReferences = new PsiReference[]{PsiReferenceBase.createSelfReference((PsiElement)valuePsiElement, (PsiElement)valuePsiElement)};
        if (!MAP_OR_INDEXED_WITHOUT_KEY_HINTS_CONDITION.value((Object)configKey)) {
            if (overrideOtherReferences == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(6);
            }
            return overrideOtherReferences;
        }
        SpringBootHintReferenceProvider pojoReferenceProvider = this.getPojoValueProvider(keyPsiElement);
        if (pojoReferenceProvider != null) {
            PsiReference[] psiReferenceArray = pojoReferenceProvider.getReferences(valuePsiElement, valueTextRanges, context);
            if (psiReferenceArray == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(7);
            }
            return psiReferenceArray;
        }
        if (overrideOtherReferences == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(8);
        }
        return overrideOtherReferences;
    }

    @Nullable
    private SpringBootHintReferenceProvider getPojoValueProvider(@NotNull PsiElement keyPsiElement) {
        PsiReference lastReference;
        if (keyPsiElement == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(9);
        }
        if (!((lastReference = (PsiReference)ArrayUtil.getLastElement((Object[])keyPsiElement.getReferences())) instanceof ConfigKeyPathReference)) {
            return null;
        }
        ConfigKeyPathReference configKeyPathReference = (ConfigKeyPathReference)lastReference;
        if (configKeyPathReference.getPathType() != ConfigKeyPathReference.PathType.BEAN_PROPERTY) {
            return null;
        }
        PsiElement resolve = configKeyPathReference.resolve();
        if (!(resolve instanceof BeanPropertyElement)) {
            return null;
        }
        PsiType type = ((BeanPropertyElement)resolve).getPropertyType();
        if (type instanceof PsiPrimitiveType) {
            type = ((PsiPrimitiveType)type).getBoxedType(keyPsiElement);
        }
        return this.getByTypeProvider(type);
    }

    @NotNull
    private SpringBootHintReferenceProvider getByTypeOrExplicitProvider(SpringBootApplicationMetaConfigKey configKey) {
        SpringBootHintReferenceProvider byTypeProvider = this.getByTypeProvider(configKey);
        if (byTypeProvider != null) {
            SpringBootHintReferenceProvider springBootHintReferenceProvider = byTypeProvider;
            if (springBootHintReferenceProvider == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(10);
            }
            return springBootHintReferenceProvider;
        }
        SpringBootHintReferenceProvider explicitValuesProvider = this.getExplicitProvider(configKey, true);
        if (explicitValuesProvider != null) {
            SpringBootHintReferenceProvider springBootHintReferenceProvider = explicitValuesProvider;
            if (springBootHintReferenceProvider == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(11);
            }
            return springBootHintReferenceProvider;
        }
        SpringBootHintReferenceProvider springBootHintReferenceProvider = this.myDummyProvider;
        if (springBootHintReferenceProvider == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(12);
        }
        return springBootHintReferenceProvider;
    }

    @NotNull
    private PsiReference[] getItemHintReferences(SpringBootApplicationMetaConfigKey configKey, ItemHintType itemHintType, PsiElement element, List<TextRange> valueTextRanges, ProcessingContext context) {
        List<SpringBootHintReferenceProvider> providers = this.getItemHintProviders(element, configKey, itemHintType);
        if (providers.isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(13);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Object[] allReferences = PsiReference.EMPTY_ARRAY;
        for (SpringBootHintReferenceProvider provider : providers) {
            Object[] references = provider.getReferences(element, valueTextRanges, context);
            allReferences = (PsiReference[])ArrayUtil.mergeArrays((Object[])allReferences, (Object[])references);
        }
        if (allReferences == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(14);
        }
        return allReferences;
    }

    private List<SpringBootHintReferenceProvider> getItemHintProviders(PsiElement element, SpringBootApplicationMetaConfigKey configKey, ItemHintType itemHintType) {
        SpringBootApplicationMetaConfigKey.ItemHint keyOrValueHint = itemHintType == ItemHintType.VALUE ? configKey.getItemHint() : configKey.getKeyItemHint();
        String prefix = itemHintType == ItemHintType.VALUE ? "" : configKey.getName() + ".";
        List valueProviders = keyOrValueHint.getValueProviders();
        boolean hasAnyProvider = ContainerUtil.exists((Iterable)valueProviders, provider -> {
            SpringBootValueProvider byId = SpringBootValueProvider.findById(provider.getName());
            return byId == SpringBootValueProvider.ANY;
        });
        SmartList providers = new SmartList();
        List valueHints = keyOrValueHint.getValueHints();
        if (!valueHints.isEmpty()) {
            providers.add(new ValueHintReferenceProvider(configKey, valueHints, prefix, hasAnyProvider));
        }
        if (valueProviders.isEmpty()) {
            return providers;
        }
        SpringBootValueProvider valueProvider = null;
        Map parameters = null;
        for (SpringBootApplicationMetaConfigKey.ValueProvider provider2 : valueProviders) {
            valueProvider = SpringBootValueProvider.findById(provider2.getName());
            if (valueProvider == null) continue;
            parameters = provider2.getParameters();
            break;
        }
        if (valueProvider == null) {
            return providers;
        }
        if (itemHintType == ItemHintType.VALUE) {
            String target;
            if (valueProvider == SpringBootValueProvider.CLASS_REFERENCE) {
                target = (String)parameters.get("target");
                String concreteParameter = (String)parameters.get("concrete");
                Boolean concrete = concreteParameter == null ? Boolean.TRUE : Boolean.valueOf(concreteParameter);
                providers.add(SpringBootHintReferencesProviderImpl.createClassReferenceProvider(target, false, concrete));
            } else if (valueProvider == SpringBootValueProvider.SPRING_PROFILE_NAME) {
                providers.add(this.mySpringProfileHintReferenceProvider);
            } else if (valueProvider == SpringBootValueProvider.SPRING_BEAN_REFERENCE) {
                target = (String)parameters.get("target");
                providers.add(new BeanReferenceProvider(target));
            } else if (valueProvider == SpringBootValueProvider.HANDLE_AS && parameters.containsKey("target")) {
                target = (String)parameters.get("target");
                PsiType targetType = JavaPsiFacade.getElementFactory((Project)element.getProject()).createTypeFromText(target.replace('$', '.'), null);
                ContainerUtil.addIfNotNull((Collection)providers, (Object)this.getByTypeProvider(targetType));
            }
        }
        if (valueProvider == SpringBootValueProvider.LOGGER_NAME) {
            providers.add(new LoggerNameReferenceProvider(prefix));
        }
        return providers;
    }

    @Nullable
    private SpringBootHintReferenceProvider getByTypeProvider(SpringBootApplicationMetaConfigKey configKey) {
        PsiType valueType = configKey.getEffectiveValueType();
        return this.getByTypeProvider(valueType);
    }

    @Nullable
    private SpringBootHintReferenceProvider getByTypeProvider(@Nullable PsiType valueType) {
        if (valueType == null) {
            return null;
        }
        PsiClass typeClass = PsiTypesUtil.getPsiClass((PsiType)valueType);
        if (typeClass == null) {
            return null;
        }
        if (typeClass.isEnum()) {
            return new EnumReferenceProvider(typeClass);
        }
        String typeFqn = typeClass.getQualifiedName();
        if (typeFqn == null) {
            return null;
        }
        if ("java.lang.Class".equals(typeFqn)) {
            PsiType[] parameters = ((PsiClassType)valueType).getParameters();
            if (parameters.length != 1) {
                return SpringBootHintReferencesProviderImpl.createClassReferenceProvider(null, false, Boolean.TRUE);
            }
            PsiType typeParameter = parameters[0];
            if (!(typeParameter instanceof PsiWildcardType)) {
                return null;
            }
            PsiWildcardType parameter = (PsiWildcardType)typeParameter;
            return SpringBootHintReferencesProviderImpl.createClassReferenceProvider(parameter.getExtendsBound().getCanonicalText(), false, Boolean.TRUE);
        }
        return this.myByTypeProviders.get(typeFqn);
    }

    @Nullable
    private SpringBootHintReferenceProvider getExplicitProvider(SpringBootApplicationMetaConfigKey configKey, boolean isSpringBoot13OrHigher) {
        String configKeyName = configKey.getName();
        if (isSpringBoot13OrHigher && !this.myOverrideKeys.contains(configKeyName)) {
            return null;
        }
        SpringBootHintReferenceProvider byKey = this.myExplicitProviders.get(configKeyName);
        if (byKey != null) {
            return byKey;
        }
        String explicitProviderId = this.myExplicitMappings.get(configKeyName);
        if (explicitProviderId == null) {
            return null;
        }
        SpringBootHintReferenceProvider provider = this.myBuiltinProviders.get(explicitProviderId);
        if (provider == null) {
            throw new IllegalStateException("provider id '" + explicitProviderId + "' not found, configured for " + configKey);
        }
        return provider;
    }

    private SpringBootHintReferenceProvider getFallbackProvider(SpringBootApplicationMetaConfigKey configKey) {
        SpringBootHintReferenceProvider byTypeProvider = this.getByTypeProvider(configKey);
        if (byTypeProvider != null) {
            return byTypeProvider;
        }
        SpringBootHintReferenceProvider explicitReferenceProvider = this.getExplicitProvider(configKey, false);
        if (explicitReferenceProvider != null) {
            return explicitReferenceProvider;
        }
        String configKeyName = configKey.getName();
        if (StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"encoding") || StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"charset")) {
            return this.myEncodingProvider;
        }
        if (StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"content-type") || StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"mime-types")) {
            return this.myContentTypeProvider;
        }
        if (StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"locale")) {
            return this.myLocaleProvider;
        }
        return this.myDummyProvider;
    }

    private static SpringBootHintReferenceProvider createStaticOrEnumReferenceProvider(SpringBootHintRegistryKey key) {
        String[] values = (String[])ContainerUtil.map2Array((Collection)StringUtil.split((String)key.myValue, (String)","), String.class, (Function)StringUtil.TRIMMER);
        return new StaticValuesReferenceProvider(key.myAllowOtherValues, key.myProvider.equals(ENUM_VALUES), null, values);
    }

    @NotNull
    private static SpringBootHintReferenceProvider createClassReferenceProvider(String baseClass, boolean allowOtherValues, Boolean concrete) {
        final JavaClassReferenceProvider provider = new JavaClassReferenceProvider();
        if (StringUtil.isNotEmpty((String)baseClass)) {
            provider.setOption(JavaClassReferenceProvider.SUPER_CLASSES, Collections.singletonList(baseClass));
        }
        if (allowOtherValues) {
            provider.setSoft(true);
        }
        if (concrete.booleanValue()) {
            provider.setOption(JavaClassReferenceProvider.CONCRETE, (Object)Boolean.TRUE);
        }
        provider.setOption(JavaClassReferenceProvider.RESOLVE_QUALIFIED_CLASS_NAME, (Object)Boolean.TRUE);
        provider.setOption(JavaClassReferenceProvider.ADVANCED_RESOLVE, (Object)Boolean.TRUE);
        SpringBootHintReferenceProvider springBootHintReferenceProvider = new SpringBootHintReferenceProvider(){

            @Override
            public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (textRanges == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    4.$$$reportNull$$$0(2);
                }
                String valueText = ElementManipulators.getValueText((PsiElement)element);
                Object[] allReferences = PsiReference.EMPTY_ARRAY;
                for (TextRange range : textRanges) {
                    Object[] references = provider.getReferencesByString(range.substring(valueText), element, range.getStartOffset());
                    allReferences = (PsiReference[])ArrayUtil.mergeArrays((Object[])allReferences, (Object[])references);
                }
                return allReferences;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "textRanges";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$4";
                objectArray[2] = "getReferences";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (springBootHintReferenceProvider == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(15);
        }
        return springBootHintReferenceProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPsiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyReferences";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueReferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getByTypeOrExplicitProvider";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemHintReferences";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPojoValueProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum ItemHintType {
        VALUE,
        KEY;

    }
}

