/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.json.psi.JsonFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.metadata.SpringBootConfigurationMetadataParser;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationMetaConfigKeyManagerImpl
extends SpringBootApplicationMetaConfigKeyManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManagerImpl");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SpringBootApplicationMetaConfigKey> getAllMetaConfigKeys(@Nullable Module module) {
        if (!SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return Collections.emptyList();
        }
        Module module2 = module;
        synchronized (module2) {
            List fromLibraries = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
                List metaInfConfigFiles = SpringCommonUtils.findConfigFilesInMetaInf((Module)module, (boolean)true, (String)"spring-configuration-metadata.json", JsonFile.class);
                ArrayList<SpringBootApplicationMetaConfigKey> allKeys = new ArrayList<SpringBootApplicationMetaConfigKey>();
                for (JsonFile configMetadataFile : metaInfConfigFiles) {
                    List<SpringBootApplicationMetaConfigKey> keys = SpringBootApplicationMetaConfigKeyManagerImpl.getConfigKeysForFile(module, configMetadataFile);
                    allKeys.addAll(keys);
                }
                return CachedValueProvider.Result.create(allKeys, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            });
            List<SpringBootApplicationMetaConfigKey> localKeys = SpringBootApplicationMetaConfigKeyManagerImpl.getLocalMetaConfigKeys(module);
            return ContainerUtil.concat((List)fromLibraries, localKeys);
        }
    }

    private static List<SpringBootApplicationMetaConfigKey> getConfigKeysForFile(Module module, JsonFile jsonFile) {
        return (List)CachedValuesManager.getCachedValue((PsiElement)jsonFile, () -> {
            ArrayList keys = new ArrayList();
            Processor collect = Processors.cancelableCollectProcessor(keys);
            try {
                SpringBootConfigurationMetadataParser parser = new SpringBootConfigurationMetadataParser(jsonFile);
                parser.processKeys(module, (Processor<SpringBootApplicationMetaConfigKey>)collect);
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.warn("Error parsing " + jsonFile.getVirtualFile().getPath(), e);
            }
            return CachedValueProvider.Result.create(keys, (Object[])new Object[]{jsonFile, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    private static List<SpringBootApplicationMetaConfigKey> getLocalMetaConfigKeys(Module localModule) {
        return (List)CachedValuesManager.getManager((Project)localModule.getProject()).getCachedValue((UserDataHolder)localModule, () -> {
            LinkedHashSet allModules = new LinkedHashSet();
            ModuleUtilCore.getDependencies((Module)localModule, allModules);
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            if (ContainerUtil.process(allModules, module -> !SpringBootLibraryUtil.hasConfigurationMetadataAnnotationProcessor((Module)module))) {
                Key libraryCheckDependency = unitTestMode ? PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT : ProjectRootManager.getInstance((Project)localModule.getProject());
                return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{libraryCheckDependency});
            }
            ArrayList allKeys = new ArrayList();
            for (Module module2 : allModules) {
                File localJsonFile = SpringBootApplicationMetaConfigKeyManagerImpl.findLocalMetadataJsonFile(module2, unitTestMode);
                if (localJsonFile == null) continue;
                ArrayList keys = new ArrayList();
                Processor collect = Processors.cancelableCollectProcessor(keys);
                try {
                    SpringBootConfigurationMetadataParser parser = new SpringBootConfigurationMetadataParser(module2, localJsonFile);
                    parser.processKeys(module2, (Processor<SpringBootApplicationMetaConfigKey>)collect);
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.warn("Error parsing " + localJsonFile.getPath(), e);
                }
                allKeys.addAll(keys);
            }
            return CachedValueProvider.Result.create(allKeys, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
    }

    @Nullable
    private static File findLocalMetadataJsonFile(Module module, boolean unitTestMode) {
        if (!unitTestMode) {
            String outputDir = CompilerPaths.getModuleOutputPath((Module)module, (boolean)false);
            if (outputDir == null) {
                return null;
            }
            String metadataJsonPath = outputDir + "/META-INF/" + "spring-configuration-metadata.json";
            File localJsonFile = new File(metadataJsonPath);
            if (!localJsonFile.exists()) {
                return null;
            }
            return localJsonFile;
        }
        VirtualFile tempFSVirtualFile = TempFileSystem.getInstance().findFileByPath("/src/spring-configuration-metadata.json");
        if (tempFSVirtualFile == null) {
            return null;
        }
        try {
            File localJsonFile = FileUtil.createTempFile((String)"sb-test", (String)"whatever", (boolean)true);
            FileUtil.writeToFile((File)localJsonFile, (String)VfsUtilCore.loadText((VirtualFile)tempFSVirtualFile));
            return localJsonFile;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nullable
    public SpringBootApplicationMetaConfigKey findApplicationMetaConfigKey(@Nullable Module module, @Nullable String configKey) {
        if (configKey == null || module == null) {
            return null;
        }
        List<SpringBootApplicationMetaConfigKey> allKeys = this.getAllMetaConfigKeys(module);
        if (allKeys.isEmpty()) {
            return null;
        }
        SpringBootApplicationMetaConfigKey exact = (SpringBootApplicationMetaConfigKey)ContainerUtil.find(allKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createNormalAccessTypeMatchingCondition(configKey));
        if (exact != null) {
            return exact;
        }
        return (SpringBootApplicationMetaConfigKey)ContainerUtil.find(allKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createMatchesCondition(configKey));
    }

    @NotNull
    public List<SpringBootApplicationMetaConfigKey> findAllApplicationMetaConfigKeys(PsiElement psiElement, @Nullable String configKey) {
        if (configKey == null) {
            List<SpringBootApplicationMetaConfigKey> list = Collections.emptyList();
            if (list == null) {
                SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(0);
            }
            return list;
        }
        List allKeys = this.getAllMetaConfigKeys(psiElement);
        if (allKeys.isEmpty()) {
            List<SpringBootApplicationMetaConfigKey> list = Collections.emptyList();
            if (list == null) {
                SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(1);
            }
            return list;
        }
        List exact = ContainerUtil.findAll((Collection)allKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createNormalAccessTypeMatchingCondition(configKey));
        if (!exact.isEmpty()) {
            List list = exact;
            if (list == null) {
                SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = ContainerUtil.findAll((Collection)allKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createMatchesCondition(configKey));
        if (list == null) {
            SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static Condition<SpringBootApplicationMetaConfigKey> createNormalAccessTypeMatchingCondition(@NotNull String configKey) {
        if (configKey == null) {
            SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(4);
        }
        Condition condition = key -> {
            if (configKey == null) {
                SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(8);
            }
            return key.isAccessType(new SpringBootApplicationMetaConfigKey.AccessType[]{SpringBootApplicationMetaConfigKey.AccessType.NORMAL}) && StringUtil.equalsIgnoreCase((CharSequence)key.getName(), (CharSequence)configKey);
        };
        if (condition == null) {
            SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(5);
        }
        return condition;
    }

    private static Condition<SpringBootApplicationMetaConfigKey> createMatchesCondition(@NotNull String configKey) {
        if (configKey == null) {
            SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(6);
        }
        return key -> {
            if (configKey == null) {
                SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(7);
            }
            return key.matches(configKey);
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllApplicationMetaConfigKeys";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createNormalAccessTypeMatchingCondition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNormalAccessTypeMatchingCondition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMatchesCondition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createMatchesCondition$5";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createNormalAccessTypeMatchingCondition$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

