/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata.additional;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.spring.boot.application.metadata.SpringBootValueProvider;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigMetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigValueProviderReference;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootAdditionalConfigInspection
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SpringBootAdditionalConfigInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringBootAdditionalConfigInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!file.getName().equals("additional-spring-configuration-metadata.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (!SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile jsonFile = (JsonFile)file;
        JsonValue topValue = jsonFile.getTopLevelValue();
        if (topValue == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        boolean isAtLeast13 = SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0);
        PropertyVisitor visitor = new PropertyVisitor(holder, isAtLeast13);
        topValue.acceptChildren((PsiElementVisitor)visitor);
        SpringBootAdditionalConfigInspection.visitTopLevelValues(topValue, (Condition<JsonProperty>)Conditions.alwaysTrue(), (NotNullProducer<JsonElementVisitor>)((NotNullProducer)() -> new NameAttributeVisitor(holder)));
        if (isAtLeast13) {
            SpringBootAdditionalConfigInspection.visitTopLevelValues(topValue, (Condition<JsonProperty>)((Condition)jsonProperty -> jsonProperty.getName().equals("hints")), (NotNullProducer<JsonElementVisitor>)((NotNullProducer)() -> new HintsVisitor(holder)));
        }
        return holder.getResultsArray();
    }

    private static void visitTopLevelValues(JsonValue topValue, Condition<JsonProperty> runVisitorCondition, NotNullProducer<JsonElementVisitor> visitorProducer) {
        if (!(topValue instanceof JsonObject)) {
            return;
        }
        JsonObject jsonObject = (JsonObject)topValue;
        for (JsonProperty property : jsonObject.getPropertyList()) {
            JsonValue propertyValue = property.getValue();
            if (!(propertyValue instanceof JsonArray) || !runVisitorCondition.value((Object)property)) continue;
            JsonElementVisitor elementVisitor = (JsonElementVisitor)visitorProducer.produce();
            propertyValue.acceptChildren((PsiElementVisitor)elementVisitor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HintsVisitor
    extends JsonRecursiveElementVisitor {
        private final ProblemsHolder myHolder;

        private HintsVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitProperty(@NotNull JsonProperty jsonProperty) {
            JsonObject provider;
            JsonArray providersArray;
            JsonValue providersValue;
            if (jsonProperty == null) {
                HintsVisitor.$$$reportNull$$$0(0);
            }
            if (jsonProperty.getName().equals("providers")) {
                providersValue = jsonProperty.getValue();
                providersArray = (JsonArray)ObjectUtils.tryCast((Object)providersValue, JsonArray.class);
                if (providersArray == null) {
                    return;
                }
                for (JsonValue value : providersArray.getValueList()) {
                    provider = (JsonObject)ObjectUtils.tryCast((Object)value, JsonObject.class);
                    if (provider == null) continue;
                    JsonProperty providerName = provider.findProperty("name");
                    if (providerName == null) {
                        this.myHolder.registerProblem((PsiElement)provider, "Missing required 'name'", new LocalQuickFix[0]);
                        continue;
                    }
                    JsonValue providerNameValue = providerName.getValue();
                    if (!(providerNameValue instanceof JsonStringLiteral)) continue;
                    SpringBootValueProvider valueProvider = null;
                    for (PsiReference reference : providerNameValue.getReferences()) {
                        if (!(reference instanceof SpringBootAdditionalConfigValueProviderReference)) continue;
                        valueProvider = ((SpringBootAdditionalConfigValueProviderReference)reference).getValueProvider();
                        break;
                    }
                    if (valueProvider == null || !valueProvider.hasRequiredParameters()) continue;
                    JsonProperty parameters = provider.findProperty("parameters");
                    JsonObject parametersValue = parameters == null ? null : (JsonObject)ObjectUtils.tryCast((Object)parameters.getValue(), JsonObject.class);
                    SmartList missingParameters = new SmartList();
                    for (SpringBootValueProvider.Parameter parameter : valueProvider.getParameters()) {
                        if (!parameter.isRequired() || parametersValue != null && parametersValue.findProperty(parameter.getName()) != null) continue;
                        missingParameters.add(parameter.getName());
                    }
                    if (missingParameters.isEmpty()) continue;
                    this.myHolder.registerProblem((PsiElement)providerNameValue, ElementManipulators.getValueTextRange((PsiElement)providerNameValue), "Missing required " + StringUtil.pluralize((String)"parameter", (int)missingParameters.size()) + ": " + StringUtil.join((Collection)missingParameters, (String)", "), new LocalQuickFix[0]);
                }
            }
            if (jsonProperty.getName().equals("values")) {
                providersValue = jsonProperty.getValue();
                providersArray = (JsonArray)ObjectUtils.tryCast((Object)providersValue, JsonArray.class);
                if (providersArray == null) {
                    return;
                }
                for (JsonValue value : providersArray.getValueList()) {
                    JsonProperty valueProperty;
                    provider = (JsonObject)ObjectUtils.tryCast((Object)value, JsonObject.class);
                    if (provider == null || (valueProperty = provider.findProperty("value")) != null) continue;
                    this.myHolder.registerProblem((PsiElement)provider, "Missing required 'value'", new LocalQuickFix[0]);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonProperty", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection$HintsVisitor", "visitProperty"));
        }
    }

    private static class NameAttributeVisitor
    extends JsonElementVisitor {
        private final ProblemsHolder myHolder;
        private final Map<String, JsonValue> myExistingNames = new HashMap<String, JsonValue>();

        private NameAttributeVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitObject(@NotNull JsonObject jsonObject) {
            if (jsonObject == null) {
                NameAttributeVisitor.$$$reportNull$$$0(0);
            }
            if (jsonObject.findProperty("name") == null) {
                this.myHolder.registerProblem((PsiElement)jsonObject, "Missing required 'name'", new LocalQuickFix[0]);
            }
            jsonObject.acceptChildren((PsiElementVisitor)this);
        }

        public void visitProperty(@NotNull JsonProperty jsonProperty) {
            if (jsonProperty == null) {
                NameAttributeVisitor.$$$reportNull$$$0(1);
            }
            if (jsonProperty.getName().equals("name")) {
                JsonStringLiteral value = (JsonStringLiteral)ObjectUtils.tryCast((Object)jsonProperty.getValue(), JsonStringLiteral.class);
                if (value == null) {
                    return;
                }
                String nameValue = value.getValue();
                if (!this.myExistingNames.containsKey(nameValue)) {
                    this.myExistingNames.put(nameValue, (JsonValue)value);
                    return;
                }
                String message = "Duplicate entry for '" + nameValue + "'";
                this.registerDuplicate((JsonValue)value, message);
                JsonValue existingValue = this.myExistingNames.get(nameValue);
                this.registerDuplicate(existingValue, message);
            }
        }

        private void registerDuplicate(JsonValue valueElement, String message) {
            this.myHolder.registerProblem((PsiElement)valueElement, ElementManipulators.getValueTextRange((PsiElement)valueElement), message, new LocalQuickFix[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jsonObject";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jsonProperty";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection$NameAttributeVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitObject";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitProperty";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PropertyVisitor
    extends JsonElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myIsAtLeast13;

        private PropertyVisitor(ProblemsHolder holder, boolean isAtLeast13) {
            this.myHolder = holder;
            this.myIsAtLeast13 = isAtLeast13;
        }

        public void visitObject(@NotNull JsonObject jsonObject) {
            if (jsonObject == null) {
                PropertyVisitor.$$$reportNull$$$0(0);
            }
            jsonObject.acceptChildren((PsiElementVisitor)this);
        }

        public void visitArray(@NotNull JsonArray jsonArray) {
            if (jsonArray == null) {
                PropertyVisitor.$$$reportNull$$$0(1);
            }
            jsonArray.acceptChildren((PsiElementVisitor)this);
        }

        public void visitProperty(@NotNull JsonProperty jsonProperty) {
            JsonValue value;
            if (jsonProperty == null) {
                PropertyVisitor.$$$reportNull$$$0(2);
            }
            if ((value = jsonProperty.getValue()) != null) {
                String text;
                String propertyName = jsonProperty.getName();
                for (PsiReference reference : value.getReferences()) {
                    boolean unresolved;
                    if (reference.isSoft()) continue;
                    boolean bl = reference instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)reference).multiResolve(false).length == 0 : (unresolved = reference.resolve() == null);
                    if (!unresolved) continue;
                    this.myHolder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), PropertyVisitor.getUnresolvedReferenceProblemHighlightType(propertyName, reference));
                }
                if (value instanceof JsonStringLiteral && (propertyName.equals("description") || propertyName.equals("reason")) && !StringUtil.endsWithChar((CharSequence)(text = ((JsonStringLiteral)value).getValue()), (char)'.')) {
                    this.myHolder.registerProblem((PsiElement)value, "Text should end with '.'", ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                }
                if (this.myIsAtLeast13 && propertyName.equals("deprecated")) {
                    this.myHolder.registerProblem((PsiElement)jsonProperty, "Property 'deprecated' should be replaced with 'deprecation'", ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                }
                value.accept((PsiElementVisitor)this);
            }
        }

        @NotNull
        private static ProblemHighlightType getUnresolvedReferenceProblemHighlightType(String propertyName, PsiReference reference) {
            if (reference instanceof SpringBootAdditionalConfigMetaConfigKeyReference) {
                ProblemHighlightType problemHighlightType = ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
                if (problemHighlightType == null) {
                    PropertyVisitor.$$$reportNull$$$0(3);
                }
                return problemHighlightType;
            }
            if (!(reference instanceof JavaClassReference)) {
                ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                if (problemHighlightType == null) {
                    PropertyVisitor.$$$reportNull$$$0(4);
                }
                return problemHighlightType;
            }
            if (propertyName.equals("target")) {
                ProblemHighlightType problemHighlightType = ProblemHighlightType.WEAK_WARNING;
                if (problemHighlightType == null) {
                    PropertyVisitor.$$$reportNull$$$0(5);
                }
                return problemHighlightType;
            }
            ProblemHighlightType problemHighlightType = ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
            if (problemHighlightType == null) {
                PropertyVisitor.$$$reportNull$$$0(6);
            }
            return problemHighlightType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jsonObject";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jsonArray";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jsonProperty";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection$PropertyVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection$PropertyVisitor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedReferenceProblemHighlightType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitObject";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitArray";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitProperty";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

