/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.config.keyPath.ConfigKeyPathReference;
import com.intellij.spring.boot.application.metadata.RelaxedNames;
import com.intellij.spring.boot.application.properties.ConfigKeyPathReferenceSet;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConfigKeyPathBeanPropertyReference
extends ConfigKeyPathReferenceSet.Reference
implements EmptyResolveMessageProvider {
    ConfigKeyPathBeanPropertyReference(PsiElement element, TextRange textRange, ConfigKeyPathReferenceSet referenceSet, int index) {
        super(element, textRange, referenceSet, index);
    }

    public ConfigKeyPathReference.PathType getPathType() {
        return ConfigKeyPathReference.PathType.BEAN_PROPERTY;
    }

    static boolean stopResolvingProperty(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(0);
        }
        return psiClass.getQualifiedName() == null || psiClass.getQualifiedName().startsWith("java.lang.");
    }

    @Nullable
    private static PsiClass getTypeParameterIfMap(PsiMethod method, int idx) {
        if (method == null) {
            return null;
        }
        PsiType returnType = method.getReturnType();
        return ConfigKeyPathReferenceSet.getTypeParameterClass(returnType, "java.util.Map", idx);
    }

    @Nullable
    public PsiElement resolve() {
        PsiClass psiClass = this.getValueClassForLocalResolving();
        if (psiClass == null) {
            return null;
        }
        if (this.isEnumMapKey() && ConfigKeyPathBeanPropertyReference.stopResolvingProperty(psiClass)) {
            return this.getElement();
        }
        return this.resolveProperty(psiClass, this.getValue());
    }

    @Nullable
    private PsiClass getValueClassForLocalResolving() {
        if (this.isUsedInIndexedConfigKeyPropertyChain()) {
            return this.getInitialValueClass();
        }
        if (this.getPrevious() instanceof ConfigKeyPathBeanPropertyReference) {
            return this.getValueClass();
        }
        return this.getPrevious().getValueClass();
    }

    private boolean isUsedInIndexedConfigKeyPropertyChain() {
        return this.isFirst();
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = ContainerUtil.map2Array(this.getAllBeanProperties(), LookupElement.class, property -> {
            PsiNamedElement element = property.getPsiElement();
            LookupElementBuilder builder = LookupElementBuilder.createWithIcon((PsiNamedElement)element).withTypeText(property.getPropertyType().getPresentableText());
            return TailTypeDecorator.withTail((LookupElement)builder, (TailType)this.getVariantTailType((BeanProperty)property));
        });
        if (objectArray == null) {
            ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    @NotNull
    private TailType getVariantTailType(BeanProperty beanProperty) {
        final PsiType type = beanProperty.getPropertyType();
        if (type instanceof PsiClassType && InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.List")) {
            TailType tailType = new TailType(){

                public int processTail(Editor editor, int tailOffset) {
                    tailOffset = 1.insertChar((Editor)editor, (int)tailOffset, (char)'[');
                    tailOffset = 1.insertChar((Editor)editor, (int)tailOffset, (char)']');
                    PsiClass listElementType = ConfigKeyPathReferenceSet.getTypeParameterClass(type, "java.util.List", 0);
                    boolean canHaveDotTail = listElementType != null && !ConfigKeyPathBeanPropertyReference.stopResolvingProperty(listElementType);
                    tailOffset = 1.insertChar((Editor)editor, (int)tailOffset, (char)(canHaveDotTail ? (char)'.' : ConfigKeyPathBeanPropertyReference.this.getKeyValueDelimiter()));
                    return 1.moveCaret((Editor)editor, (int)tailOffset, (int)-2);
                }
            };
            if (tailType == null) {
                ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(2);
            }
            return tailType;
        }
        if (ConfigKeyPathBeanPropertyReference.canHaveDotTail(type)) {
            TailType tailType = TailType.DOT;
            if (tailType == null) {
                ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(3);
            }
            return tailType;
        }
        TailType tailType = TailType.createSimpleTailType((char)this.getKeyValueDelimiter());
        if (tailType == null) {
            ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(4);
        }
        return tailType;
    }

    private static boolean canHaveDotTail(PsiType type) {
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)type);
        return psiClass != null && !ConfigKeyPathBeanPropertyReference.stopResolvingProperty(psiClass);
    }

    private List<BeanProperty> getAllBeanProperties() {
        PsiClass psiClass = this.getValueClassForLocalResolving();
        if (psiClass == null || ConfigKeyPathBeanPropertyReference.stopResolvingProperty(psiClass)) {
            return Collections.emptyList();
        }
        Map properties = PropertyUtilBase.getAllProperties((PsiClass)psiClass, (boolean)true, (!this.isLast() ? 1 : 0) != 0);
        return ContainerUtil.mapNotNull(properties.values(), (Function)((NullableFunction)BeanProperty::createBeanProperty));
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String location = this.getValueClass() == null ? "" : " in " + this.getValueClass().getQualifiedName();
        String string = "Cannot resolve property '" + this.getValue() + "'" + location;
        if (string == null) {
            ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(5);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String name = PropertyUtilBase.getPropertyName((String)newElementName);
        return super.handleElementRename(name == null ? newElementName : name);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String propertyName;
        if (element == null) {
            ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(6);
        }
        if (element instanceof PsiMethod && (propertyName = PropertyUtilBase.getPropertyName((PsiMember)((PsiMember)element))) != null) {
            return super.handleElementRename(propertyName);
        }
        return this.getElement();
    }

    @Nullable
    private PsiNamedElement resolveProperty(@NotNull PsiClass psiClass, String propertyName) {
        PsiMethod method;
        if (psiClass == null) {
            ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(7);
        }
        if ((method = PropertyUtilBase.findPropertyGetter((PsiClass)psiClass, (String)propertyName, (boolean)false, (boolean)true)) == null) {
            method = PropertyUtilBase.findPropertyGetter((PsiClass)psiClass, (String)RelaxedNames.separatedPropertyNameToCamelCase((String)propertyName), (boolean)false, (boolean)true);
        }
        if (method == null || !method.hasModifierProperty("public")) {
            return null;
        }
        BeanProperty property = BeanProperty.createBeanProperty((PsiMethod)method);
        return property == null ? null : property.getPsiElement();
    }

    @Override
    @Nullable
    protected PsiClass getValueClass() {
        PsiMethod method;
        PsiClass type;
        if (this.isUsedInIndexedConfigKeyPropertyChain()) {
            return this.getInitialValueClass();
        }
        ConfigKeyPathReferenceSet.Reference previous = this.getPrevious();
        if (previous instanceof ConfigKeyPathBeanPropertyReference) {
            ConfigKeyPathBeanPropertyReference previousProp = (ConfigKeyPathBeanPropertyReference)previous;
            PsiMethod method2 = previousProp.getResolvedMethod();
            if (method2 == null) {
                return null;
            }
            PsiType returnType = method2.getReturnType();
            PsiClass listType = ConfigKeyPathReferenceSet.getTypeParameterClass(returnType, "java.util.List", 0);
            if (listType != null) {
                return listType;
            }
            return PsiTypesUtil.getPsiClass((PsiType)returnType);
        }
        PsiClass previousValueClass = previous.getValueClass();
        if (previousValueClass == null) {
            return null;
        }
        PsiNamedElement myLocalMethod = this.resolveProperty(previousValueClass, this.getValue());
        if (myLocalMethod instanceof BeanPropertyElement && (type = ConfigKeyPathBeanPropertyReference.getTypeParameterIfMap(method = ((BeanPropertyElement)myLocalMethod).getMethod(), 1)) != null) {
            return type;
        }
        return previousValueClass;
    }

    @Override
    @Nullable
    protected PsiClass getKeyClass() {
        PsiMethod method;
        PsiClass type;
        if (this.isUsedInIndexedConfigKeyPropertyChain()) {
            return null;
        }
        ConfigKeyPathReferenceSet.Reference previous = this.getPrevious();
        PsiClass previousValueClass = previous.getValueClass();
        if (previousValueClass == null) {
            return null;
        }
        PsiNamedElement myLocalMethod = this.resolveProperty(previousValueClass, this.getValue());
        if (myLocalMethod instanceof BeanPropertyElement && (type = ConfigKeyPathBeanPropertyReference.getTypeParameterIfMap(method = ((BeanPropertyElement)myLocalMethod).getMethod(), 0)) != null) {
            return type;
        }
        return null;
    }

    @Nullable
    private PsiMethod getResolvedMethod() {
        PsiElement resolve = this.resolve();
        if (resolve instanceof BeanPropertyElement) {
            return ((BeanPropertyElement)resolve).getMethod();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/properties/ConfigKeyPathBeanPropertyReference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/properties/ConfigKeyPathBeanPropertyReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariantTailType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stopResolvingProperty";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

