/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.config.SpringBootConfigFileAnnotatorBase;
import com.intellij.spring.boot.application.config.keyPath.ConfigKeyPathReference;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;

public class SpringBootApplicationPropertiesAnnotator
extends SpringBootConfigFileAnnotatorBase {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            SpringBootApplicationPropertiesAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringBootApplicationPropertiesAnnotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PropertyValueImpl) && !(element instanceof PropertyKeyImpl)) {
            return;
        }
        PsiFile file = holder.getCurrentAnnotationSession().getFile();
        if (!(file instanceof PropertiesFile)) {
            return;
        }
        if (!SpringCommonUtils.hasSpringFacets((Project)file.getProject()) || !SpringBootApplicationPropertiesUtil.isApplicationPropertiesFile((PropertiesFile)file)) {
            return;
        }
        if (element instanceof PropertyValueImpl) {
            this.annotateValue(element, holder);
        }
        if (element instanceof PropertyKeyImpl) {
            SpringBootApplicationPropertiesAnnotator.annotateKey((PropertyKeyImpl)element, holder);
        }
    }

    protected TextAttributesKey getPlaceholderTextAttributesKey() {
        return PropertiesHighlighter.PROPERTY_KEY;
    }

    private static void annotateKey(PropertyKeyImpl element, AnnotationHolder holder) {
        SpringBootApplicationMetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)element);
        if (configKey == null) {
            return;
        }
        String keyText = element.getText();
        int elementStartOffset = element.getNode().getStartOffset();
        SpringBootApplicationPropertiesAnnotator.annotateIndexAccessExpressions(holder, keyText, configKey, elementStartOffset);
        if (configKey.isAccessType(new SpringBootApplicationMetaConfigKey.AccessType[]{SpringBootApplicationMetaConfigKey.AccessType.NORMAL})) {
            return;
        }
        block5: for (PsiReference psiReference : element.getReferences()) {
            if (!(psiReference instanceof ConfigKeyPathReference)) continue;
            ConfigKeyPathReference configKeyPathReference = (ConfigKeyPathReference)psiReference;
            TextRange referenceRange = configKeyPathReference.getRangeInElement().shiftRight(elementStartOffset);
            switch (configKeyPathReference.getPathType()) {
                case ENUM: {
                    SpringBootApplicationPropertiesAnnotator.doAnnotate((AnnotationHolder)holder, (TextRange)referenceRange, (TextAttributesKey)DefaultLanguageHighlighterColors.CONSTANT);
                    continue block5;
                }
                case BEAN_PROPERTY: {
                    SpringBootApplicationPropertiesAnnotator.doAnnotate((AnnotationHolder)holder, (TextRange)referenceRange, (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_METHOD);
                    continue block5;
                }
                case ARBITRARY_ENTRY_KEY: {
                    SpringBootApplicationPropertiesAnnotator.doAnnotateEnforced((AnnotationHolder)holder, (TextRange)referenceRange, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES, (String)"REGULAR_ITALIC_ATTRIBUTES");
                }
            }
        }
        if (configKey.isAccessType(new SpringBootApplicationMetaConfigKey.AccessType[]{SpringBootApplicationMetaConfigKey.AccessType.MAP}) && configKey.getKeyItemHint() != SpringBootApplicationMetaConfigKey.ItemHint.NONE) {
            int configKeyNameLength = -1;
            for (PsiReference reference : element.getReferences()) {
                if (!(reference instanceof MetaConfigKeyReference)) continue;
                configKeyNameLength = reference.getRangeInElement().getEndOffset();
                break;
            }
            assert (configKeyNameLength != -1) : keyText;
            int endOffset = keyText.length() - configKeyNameLength - (StringUtil.endsWithChar((CharSequence)keyText, (char)']') ? 2 : 1);
            if (endOffset < 0) {
                return;
            }
            TextRange genericKeyRange = TextRange.from((int)(configKeyNameLength + 1), (int)endOffset).shiftRight(elementStartOffset);
            SpringBootApplicationPropertiesAnnotator.doAnnotateEnforced((AnnotationHolder)holder, (TextRange)genericKeyRange, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES, (String)"REGULAR_ITALIC_ATTRIBUTES");
        }
    }

    private static void annotateIndexAccessExpressions(final AnnotationHolder holder, String text, SpringBootApplicationMetaConfigKey configKey, final int elementStartOffset) {
        new IndexAccessTextProcessor(text, configKey){

            @Override
            protected void onMissingClosingBracket(int startIdx) {
            }

            @Override
            protected void onMissingIndexValue(int startIdx) {
            }

            @Override
            protected void onBracket(int startIdx) {
                SpringBootApplicationPropertiesAnnotator.doAnnotate((AnnotationHolder)holder, (TextRange)TextRange.from((int)startIdx, (int)1).shiftRight(elementStartOffset), (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
            }

            @Override
            protected void onIndexValue(TextRange indexValueRange) {
                SpringBootApplicationPropertiesAnnotator.doAnnotate((AnnotationHolder)holder, (TextRange)indexValueRange.shiftRight(elementStartOffset), (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
            }

            @Override
            protected void onIndexValueNotInteger(TextRange indexValueRange) {
            }
        }.process();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static abstract class IndexAccessTextProcessor {
        private final String myText;
        private final SpringBootApplicationMetaConfigKey myConfigKey;

        IndexAccessTextProcessor(String text, SpringBootApplicationMetaConfigKey configKey) {
            this.myText = text;
            this.myConfigKey = configKey;
        }

        protected abstract void onMissingClosingBracket(int var1);

        protected abstract void onMissingIndexValue(int var1);

        protected abstract void onBracket(int var1);

        protected abstract void onIndexValue(TextRange var1);

        protected abstract void onIndexValueNotInteger(TextRange var1);

        void process() {
            int parseOffset = 0;
            int startIdx;
            while ((startIdx = StringUtil.indexOf((CharSequence)this.myText, (char)'[', (int)parseOffset)) != -1) {
                int endIdx;
                parseOffset = endIdx = StringUtil.indexOf((CharSequence)this.myText, (char)']', (int)startIdx);
                if (endIdx == -1) {
                    this.onMissingClosingBracket(startIdx);
                    parseOffset = startIdx + 1;
                    continue;
                }
                if (startIdx + 1 == endIdx) {
                    this.onMissingIndexValue(startIdx);
                    continue;
                }
                this.onBracket(startIdx);
                boolean isPlainMapKey = this.myConfigKey.isAccessType(new SpringBootApplicationMetaConfigKey.AccessType[]{SpringBootApplicationMetaConfigKey.AccessType.MAP});
                if (!isPlainMapKey) {
                    TextRange indexValueRange = TextRange.create((int)(startIdx + 1), (int)endIdx);
                    String indexValueText = indexValueRange.substring(this.myText);
                    try {
                        Integer.decode(indexValueText);
                        this.onIndexValue(indexValueRange);
                    }
                    catch (NumberFormatException e) {
                        this.onIndexValueNotInteger(indexValueRange);
                    }
                }
                this.onBracket(endIdx);
            }
            return;
        }
    }
}

