/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.refactoring.rename.BeanPropertyRenameHandler;
import com.intellij.spring.boot.application.config.keyPath.ConfigKeyPathReference;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationPropertiesConfigKeyPathBeanPropertyRenameHandler
extends BeanPropertyRenameHandler {
    @Nullable
    protected BeanProperty getProperty(DataContext context) {
        PsiMethod method;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (editor == null || !(file instanceof PropertiesFile)) {
            return null;
        }
        PsiReference reference = file.findReferenceAt(editor.getCaretModel().getOffset());
        if (!(reference instanceof ConfigKeyPathReference)) {
            return null;
        }
        ConfigKeyPathReference.PathType type = ((ConfigKeyPathReference)reference).getPathType();
        if (type != ConfigKeyPathReference.PathType.BEAN_PROPERTY) {
            return null;
        }
        PsiElement resolve = reference.resolve();
        if (resolve instanceof BeanPropertyElement && PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)(method = ((BeanPropertyElement)resolve).getMethod()))) {
            return BeanProperty.createBeanProperty((PsiMethod)method);
        }
        return null;
    }
}

