/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesInspectionBase;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.config.SpringBootConfigFileHighlightingUtil;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.config.keyPath.ConfigKeyPathReference;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesAnnotator;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SpringBootApplicationPropertiesInspection
extends PropertiesInspectionBase {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SpringBootApplicationPropertiesInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringBootApplicationPropertiesInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof PropertiesFile)) {
            return null;
        }
        PropertiesFile propertiesFile = (PropertiesFile)file;
        if (!SpringCommonUtils.hasSpringFacets((Project)manager.getProject()) || !SpringBootApplicationPropertiesUtil.isApplicationPropertiesFile(propertiesFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (!SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        SpringBootConfigFileHighlightingUtil configFileHighlightingUtil = new SpringBootConfigFileHighlightingUtil(holder);
        for (IProperty iProperty : propertiesFile.getProperties()) {
            PropertyValueImpl valueElement;
            PropertyImpl property;
            PropertyKeyImpl propertyKey;
            ProgressManager.checkCanceled();
            if (!(iProperty instanceof PropertyImpl) || (propertyKey = SpringBootApplicationPropertiesUtil.getPropertyKey(property = (PropertyImpl)iProperty)) == null) continue;
            SpringBootApplicationMetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)propertyKey);
            if (configKey == null) {
                PsiReference[] keyName = property.getName();
                configFileHighlightingUtil.highlightUnresolvedConfigKey((PsiElement)propertyKey, (String)keyName);
                continue;
            }
            if (configKey.getDeprecation() != SpringBootApplicationMetaConfigKey.Deprecation.NOT_DEPRECATED) {
                configFileHighlightingUtil.highlightDeprecatedConfigKey((PsiElement)propertyKey, configKey, SpringBootApplicationPropertiesInspection.getDeprecationFix(property, configKey));
            }
            if (configKey.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.MAP_GROUP) && propertyKey.getText().length() == configKey.getName().length()) {
                holder.registerProblem((PsiElement)propertyKey, "Missing map key", ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                continue;
            }
            SpringBootApplicationPropertiesInspection.highlightIndexAccessExpressions(holder, propertyKey, configKey);
            if (SpringBootHintReferencesProvider.MAP_OR_INDEXED_WITHOUT_KEY_HINTS_CONDITION.value((Object)configKey)) {
                for (PsiReference reference : propertyKey.getReferences()) {
                    if (!(reference instanceof ConfigKeyPathReference) || reference.isSoft() || reference.resolve() != null) continue;
                    holder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), ProblemHighlightType.ERROR);
                }
            }
            if ((valueElement = SpringBootApplicationPropertiesUtil.getPropertyValue(property)) == null) continue;
            configFileHighlightingUtil.highlightValueReferences((PsiElement)valueElement);
        }
        return holder.getResultsArray();
    }

    private static void highlightIndexAccessExpressions(final ProblemsHolder holder, final PropertyKeyImpl propertyKey, SpringBootApplicationMetaConfigKey configKey) {
        new SpringBootApplicationPropertiesAnnotator.IndexAccessTextProcessor(propertyKey.getText(), configKey){

            @Override
            protected void onMissingClosingBracket(int startIdx) {
                holder.registerProblem((PsiElement)propertyKey, "Missing closing ']'", ProblemHighlightType.ERROR, TextRange.from((int)startIdx, (int)1), new LocalQuickFix[0]);
            }

            @Override
            protected void onMissingIndexValue(int startIdx) {
                holder.registerProblem((PsiElement)propertyKey, "Missing index value", ProblemHighlightType.ERROR, TextRange.from((int)startIdx, (int)2), new LocalQuickFix[0]);
            }

            @Override
            protected void onBracket(int startIdx) {
            }

            @Override
            protected void onIndexValue(TextRange indexValueRange) {
            }

            @Override
            protected void onIndexValueNotInteger(TextRange indexValueRange) {
                holder.registerProblem((PsiElement)propertyKey, "Index value must be Integer", ProblemHighlightType.ERROR, indexValueRange, new LocalQuickFix[0]);
            }
        }.process();
    }

    private static LocalQuickFix[] getDeprecationFix(PropertyImpl property, SpringBootApplicationMetaConfigKey configKey) {
        final String replacement = configKey.getDeprecation().getReplacement();
        if (replacement == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{new LocalQuickFixOnPsiElement((PsiElement)property){

            @NotNull
            public String getText() {
                String string = "Use replacement key '" + replacement + "'";
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (file == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (startElement == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (endElement == null) {
                    2.$$$reportNull$$$0(4);
                }
                PropertyImpl property = (PropertyImpl)startElement;
                property.setName(replacement);
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                if ("Use replacement key" == null) {
                    2.$$$reportNull$$$0(5);
                }
                return "Use replacement key";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "startElement";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "endElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection$2";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

