/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.banner;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.banner.AnsiColor;
import com.intellij.spring.boot.banner.AnsiStyle;
import com.intellij.spring.boot.banner.BuiltinProperty;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootBannerPropertyReference
extends PsiReferenceBase.Poly<PsiElement> {
    private final boolean myBoot13;

    SpringBootBannerPropertyReference(PsiElement element, TextRange range, boolean isSpringBoot13) {
        super(element, range, true);
        this.myBoot13 = isSpringBoot13;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] dummyResult = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.myElement});
        if (!this.myBoot13) {
            if (dummyResult == null) {
                SpringBootBannerPropertyReference.$$$reportNull$$$0(0);
            }
            return dummyResult;
        }
        String value = this.getValue();
        for (BuiltinProperty property : BuiltinProperty.values()) {
            if (!property.getPropertyName().equals(value)) continue;
            if (dummyResult == null) {
                SpringBootBannerPropertyReference.$$$reportNull$$$0(1);
            }
            return dummyResult;
        }
        if (StringUtil.startsWith((CharSequence)value, (CharSequence)"AnsiColor.")) {
            ResolveResult[] resolveResultArray = this.resolveAnsiColor(value, "AnsiColor.", "org.springframework.boot.ansi.AnsiColor");
            if (resolveResultArray == null) {
                SpringBootBannerPropertyReference.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }
        if (StringUtil.startsWith((CharSequence)value, (CharSequence)"AnsiBackground.")) {
            ResolveResult[] resolveResultArray = this.resolveAnsiColor(value, "AnsiBackground.", "org.springframework.boot.ansi.AnsiBackground");
            if (resolveResultArray == null) {
                SpringBootBannerPropertyReference.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        if (StringUtil.startsWith((CharSequence)value, (CharSequence)"AnsiStyle.")) {
            ResolveResult[] resolveResultArray = this.resolveAnsiStyle(value, "AnsiStyle.");
            if (resolveResultArray == null) {
                SpringBootBannerPropertyReference.$$$reportNull$$$0(4);
            }
            return resolveResultArray;
        }
        List<MetaConfigKeyReference> references = this.resolveConfigValue(value);
        if (references != null) {
            List targets = references.stream().map(MetaConfigKeyReference::createNavigationElement).collect(Collectors.toList());
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(targets);
            if (resolveResultArray == null) {
                SpringBootBannerPropertyReference.$$$reportNull$$$0(5);
            }
            return resolveResultArray;
        }
        if (dummyResult == null) {
            SpringBootBannerPropertyReference.$$$reportNull$$$0(6);
        }
        return dummyResult;
    }

    @Nullable
    private List<MetaConfigKeyReference> resolveConfigValue(String value) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            return null;
        }
        SmartList results = new SmartList();
        SpringBootConfigValueSearcher.productionForProfiles((Module)module, (String)value, null).process(arg_0 -> SpringBootBannerPropertyReference.lambda$resolveConfigValue$0((List)results, arg_0));
        return results.isEmpty() ? null : results;
    }

    @NotNull
    private ResolveResult[] resolveAnsiColor(String value, String prefix, String className) {
        String name = StringUtil.substringAfter((String)value, (String)prefix);
        AnsiColor ansiColor = AnsiColor.findByName(name);
        if (ansiColor == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                SpringBootBannerPropertyReference.$$$reportNull$$$0(7);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.findFieldInClass(className, name)});
        if (resolveResultArray == null) {
            SpringBootBannerPropertyReference.$$$reportNull$$$0(8);
        }
        return resolveResultArray;
    }

    @NotNull
    private ResolveResult[] resolveAnsiStyle(String value, String prefix) {
        String name = StringUtil.substringAfter((String)value, (String)prefix);
        AnsiStyle ansiStyle = AnsiStyle.findByName(name);
        if (ansiStyle == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                SpringBootBannerPropertyReference.$$$reportNull$$$0(9);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.findFieldInClass("org.springframework.boot.ansi.AnsiStyle", name)});
        if (resolveResultArray == null) {
            SpringBootBannerPropertyReference.$$$reportNull$$$0(10);
        }
        return resolveResultArray;
    }

    @Nullable
    private PsiField findFieldInClass(String className, String fieldName) {
        PsiClass psiClass = SpringCommonUtils.findLibraryClass((Module)ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement()), (String)className);
        return psiClass != null ? psiClass.findFieldByName(fieldName, false) : null;
    }

    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            SpringBootBannerPropertyReference.$$$reportNull$$$0(11);
        }
        return EMPTY_ARRAY;
    }

    private static /* synthetic */ boolean lambda$resolveConfigValue$0(List results, SpringBootModelConfigFileContributor.ConfigurationValueResult result) {
        ContainerUtil.addIfNotNull((Collection)results, (Object)result.getMetaConfigKeyReference());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/banner/SpringBootBannerPropertyReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAnsiColor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAnsiStyle";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

