/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.boot.model.autoconfigure.ConditionalCollector;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnJamElement;
import com.intellij.util.SystemProperties;
import java.util.Collection;

class AutoConfigClassConditionEvaluator {
    private static final boolean FILTER_AUTO_CONFIGS = SystemProperties.getBooleanProperty((String)"idea.spring.boot.filter.autoconfig", (boolean)true);
    private final boolean myNonStrictEvaluation;
    private final PsiClass myAutoConfigClass;
    private final ConditionalOnEvaluationContext myConditionalOnEvaluationContext;

    AutoConfigClassConditionEvaluator(PsiClass autoConfigClass, boolean nonStrictEvaluation, ConditionalOnEvaluationContext conditionalOnEvaluationContext) {
        this.myNonStrictEvaluation = nonStrictEvaluation;
        this.myAutoConfigClass = autoConfigClass;
        this.myConditionalOnEvaluationContext = conditionalOnEvaluationContext;
    }

    boolean isActive() {
        if (!FILTER_AUTO_CONFIGS) {
            return true;
        }
        PsiModifierList modifierList = this.myAutoConfigClass.getModifierList();
        if (modifierList == null) {
            return false;
        }
        ConditionalCollector collector = new ConditionalCollector((PsiModifierListOwner)this.myAutoConfigClass);
        Collection<ConditionalOnJamElement> allConditions = collector.getConditionals();
        if (allConditions.isEmpty()) {
            return true;
        }
        for (ConditionalOnJamElement condition : allConditions) {
            if (this.myNonStrictEvaluation && condition instanceof ConditionalOnJamElement.NonStrict || condition.value((Object)this.myConditionalOnEvaluationContext)) continue;
            return false;
        }
        return true;
    }
}

