/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.autoconfigure.SpringOrderClassSorter;
import com.intellij.spring.boot.model.autoconfigure.jam.AutoConfigureAfter;
import com.intellij.spring.boot.model.autoconfigure.jam.AutoConfigureBefore;
import com.intellij.spring.boot.model.autoconfigure.jam.AutoConfigureOrder;
import com.intellij.spring.model.jam.SpringOrder;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class AutoConfigClassSorter {
    private final Comparator<PsiClass> AUTOCONFIGURE_ORDER_COMPARATOR = (o1, o2) -> {
        int order1 = this.getAutoConfigureOrderValue((PsiClass)o1);
        int order2 = this.getAutoConfigureOrderValue((PsiClass)o2);
        return Comparing.compare((int)order1, (int)order2);
    };
    private final List<PsiClass> allConfigs;
    private final Integer autoConfigureOrderDefault;

    private int getAutoConfigureOrderValue(PsiClass psiClass) {
        AutoConfigureOrder autoConfigureOrder = (AutoConfigureOrder)AutoConfigureOrder.CLASS_META.getJamElement((PsiModifierListOwner)psiClass);
        if (autoConfigureOrder == null) {
            return this.autoConfigureOrderDefault;
        }
        return (Integer)ObjectUtils.notNull((Object)autoConfigureOrder.getValue(), (Object)this.autoConfigureOrderDefault);
    }

    AutoConfigClassSorter(Module module, List<PsiClass> allConfigs) {
        this.allConfigs = allConfigs;
        this.autoConfigureOrderDefault = AutoConfigClassSorter.getOrderDefaultValue(module);
    }

    @NotNull
    private static Integer getOrderDefaultValue(Module module) {
        PsiAnnotationMemberValue annotationMemberValue;
        Integer defaultValue;
        PsiClass autoConfigureOrder = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.boot.autoconfigure.AutoConfigureOrder");
        if (autoConfigureOrder == null) {
            Integer n = AutoConfigClassSorter.getOrderDefaultValueFallbackByVersion(module);
            if (n == null) {
                AutoConfigClassSorter.$$$reportNull$$$0(0);
            }
            return n;
        }
        Object[] methods = autoConfigureOrder.findMethodsByName("value", false);
        PsiMethod valueMethod = (PsiMethod)ArrayUtil.getFirstElement((Object[])methods);
        if (valueMethod instanceof PsiAnnotationMethod && (defaultValue = (Integer)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)(annotationMemberValue = ((PsiAnnotationMethod)valueMethod).getDefaultValue()), Integer.class)) != null) {
            Integer n = defaultValue;
            if (n == null) {
                AutoConfigClassSorter.$$$reportNull$$$0(1);
            }
            return n;
        }
        Integer n = AutoConfigClassSorter.getOrderDefaultValueFallbackByVersion(module);
        if (n == null) {
            AutoConfigClassSorter.$$$reportNull$$$0(2);
        }
        return n;
    }

    @NotNull
    private static Integer getOrderDefaultValueFallbackByVersion(Module module) {
        if (SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0)) {
            Integer n = 0;
            if (n == null) {
                AutoConfigClassSorter.$$$reportNull$$$0(3);
            }
            return n;
        }
        Integer n = SpringOrder.LOWEST_PRECEDENCE;
        if (n == null) {
            AutoConfigClassSorter.$$$reportNull$$$0(4);
        }
        return n;
    }

    List<PsiClass> getSortedConfigs() {
        ArrayList<PsiClass> configs = new ArrayList<PsiClass>(this.allConfigs);
        Collections.sort(configs, SpringOrderClassSorter.CLASS_NAME_COMPARATOR);
        Collections.sort(configs, this.AUTOCONFIGURE_ORDER_COMPARATOR);
        return this.sortByAutoConfigureAfterBefore(configs);
    }

    private List<PsiClass> sortByAutoConfigureAfterBefore(List<PsiClass> configs) {
        ArrayList<PsiClass> toSort = new ArrayList<PsiClass>(configs);
        LinkedHashSet<PsiClass> sorted = new LinkedHashSet<PsiClass>();
        LinkedHashSet<PsiClass> processing = new LinkedHashSet<PsiClass>();
        while (!toSort.isEmpty()) {
            this.doSortByAfterAnnotation(toSort, sorted, processing, null);
        }
        return new ArrayList<PsiClass>(sorted);
    }

    private void doSortByAfterAnnotation(List<PsiClass> toSort, Set<PsiClass> sorted, Set<PsiClass> processing, PsiClass current) {
        if (current == null) {
            current = toSort.remove(0);
        }
        processing.add(current);
        for (PsiClass after : this.getClassesRequestedAfter(current)) {
            if (sorted.contains(after) || !toSort.contains(after)) continue;
            this.doSortByAfterAnnotation(toSort, sorted, processing, after);
        }
        processing.remove(current);
        sorted.add(current);
    }

    private Set<PsiClass> getClassesRequestedAfter(PsiClass config) {
        LinkedHashSet<PsiClass> rtn = new LinkedHashSet<PsiClass>();
        AutoConfigureAfter autoConfigureAfter = (AutoConfigureAfter)AutoConfigureAfter.META.getJamElement((PsiModifierListOwner)config);
        if (autoConfigureAfter != null) {
            rtn.addAll(autoConfigureAfter.getClasses());
        }
        for (PsiClass all : this.allConfigs) {
            AutoConfigureBefore autoConfigureBefore = (AutoConfigureBefore)AutoConfigureBefore.META.getJamElement((PsiModifierListOwner)config);
            if (autoConfigureBefore == null || !autoConfigureBefore.getClasses().contains(config)) continue;
            rtn.add(all);
        }
        return rtn;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/model/autoconfigure/AutoConfigClassSorter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderDefaultValue";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderDefaultValueFallbackByVersion";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

