/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.boot.facet.SpringBootFileSetEditorCustomization;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.SpringBootModelConfigFileNameContributor;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassConditionEvaluator;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContextBase;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AutoConfigurationModelBase
extends LocalAnnotationModel {
    private final LocalAnnotationModel myLocalAnnotationModel;
    private final PsiClass myConfigClass;
    private Map<SpringBootModelConfigFileContributor, List<VirtualFile>> myConfigFilesCache = FactoryMap.create(contributor -> {
        SmartList configFiles = new SmartList();
        for (SpringBootModelConfigFileNameContributor nameContributor : (SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()) {
            if (!nameContributor.accept(this.getModule())) continue;
            List files = contributor.getConfigurationFiles(this.getModule(), nameContributor, false);
            configFiles.addAll(files);
        }
        return configFiles;
    });

    protected AutoConfigurationModelBase(LocalAnnotationModel localAnnotationModel, PsiClass configClass) {
        this.myLocalAnnotationModel = localAnnotationModel;
        this.myConfigClass = configClass;
    }

    protected Collection<SpringBeanPointer> calculateLocalBeans() {
        return Collections.emptySet();
    }

    @NotNull
    public PsiClass getConfig() {
        PsiClass psiClass = this.myConfigClass;
        if (psiClass == null) {
            AutoConfigurationModelBase.$$$reportNull$$$0(0);
        }
        return psiClass;
    }

    @NotNull
    public Set<Pair<LocalModel, LocalModelDependency>> getDependentLocalModels() {
        boolean nonStrictEvaluation = this.isNonStrictEvaluation();
        LinkedHashSet autoConfigModels = ContainerUtil.newLinkedHashSet();
        ConditionalOnEvaluationContext sharedContext = this.createContext(this.getConfig(), null);
        List<PsiClass> autoConfigClasses = this.getAutoConfigClasses();
        for (PsiClass autoConfigClass : autoConfigClasses) {
            sharedContext = this.processConfigurationClass(autoConfigModels, autoConfigClass, nonStrictEvaluation, sharedContext);
        }
        LinkedHashSet linkedHashSet = autoConfigModels;
        if (linkedHashSet == null) {
            AutoConfigurationModelBase.$$$reportNull$$$0(1);
        }
        return linkedHashSet;
    }

    private ConditionalOnEvaluationContext createContext(PsiClass configClass, @Nullable ConditionalOnEvaluationContext sharedContext) {
        ConditionalOnEvaluationContextBase useSharedContext = sharedContext instanceof ConditionalOnEvaluationContextBase ? (ConditionalOnEvaluationContextBase)sharedContext : null;
        return new ConditionalOnEvaluationContextBase(configClass, this.getModule(), this.getActiveProfiles(), this.myConfigFilesCache, useSharedContext);
    }

    private boolean isNonStrictEvaluation() {
        SpringFacet springFacet = SpringFacet.getInstance((Module)this.getModule());
        CustomSetting.BOOLEAN setting = springFacet != null ? (CustomSetting.BOOLEAN)springFacet.findSetting(SpringBootFileSetEditorCustomization.NON_STRICT_SETTING) : null;
        return setting == null || setting.getBooleanValue();
    }

    @NotNull
    private ConditionalOnEvaluationContext processConfigurationClass(Set<Pair<LocalModel, LocalModelDependency>> autoConfigModels, PsiClass autoConfigClass, boolean nonStrictEvaluation, @Nullable ConditionalOnEvaluationContext sharedContext) {
        ConditionalOnEvaluationContext context = this.createContext(autoConfigClass, sharedContext);
        AutoConfigClassConditionEvaluator evaluator = new AutoConfigClassConditionEvaluator(autoConfigClass, nonStrictEvaluation, context);
        if (!evaluator.isActive()) {
            ConditionalOnEvaluationContext conditionalOnEvaluationContext = context;
            if (conditionalOnEvaluationContext == null) {
                AutoConfigurationModelBase.$$$reportNull$$$0(2);
            }
            return conditionalOnEvaluationContext;
        }
        LocalAnnotationModel autoConfigModel = SpringManager.getInstance((Project)this.myConfigClass.getProject()).getLocalSpringModel(autoConfigClass, this.getModule());
        if (autoConfigModel == null) {
            ConditionalOnEvaluationContext conditionalOnEvaluationContext = context;
            if (conditionalOnEvaluationContext == null) {
                AutoConfigurationModelBase.$$$reportNull$$$0(3);
            }
            return conditionalOnEvaluationContext;
        }
        autoConfigModel.disableEvaluatingInnerConfigurationClasses();
        LocalModelDependency dependency = LocalModelDependency.create((String)("Auto-configuration @" + this.myConfigClass.getQualifiedName()), (LocalModelDependencyType)this.getModelDependencyType(), (PsiElement)autoConfigClass.getNavigationElement());
        autoConfigModels.add((Pair<LocalModel, LocalModelDependency>)Pair.create((Object)autoConfigModel, (Object)dependency));
        for (PsiClass innerConfig : autoConfigClass.getInnerClasses()) {
            if (!innerConfig.hasModifierProperty("static") || JamService.getJamService((Project)this.getModule().getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)innerConfig) == null) continue;
            this.processConfigurationClass(autoConfigModels, innerConfig, nonStrictEvaluation, context);
        }
        ConditionalOnEvaluationContext conditionalOnEvaluationContext = context;
        if (conditionalOnEvaluationContext == null) {
            AutoConfigurationModelBase.$$$reportNull$$$0(4);
        }
        return conditionalOnEvaluationContext;
    }

    protected LocalAnnotationModel getLocalAnnotationModel() {
        return this.myLocalAnnotationModel;
    }

    @NotNull
    protected abstract List<PsiClass> getAutoConfigClasses();

    @NotNull
    protected abstract LocalModelDependencyType getModelDependencyType();

    @NotNull
    public Module getModule() {
        Module module = this.myLocalAnnotationModel.getModule();
        if (module == null) {
            AutoConfigurationModelBase.$$$reportNull$$$0(5);
        }
        return module;
    }

    @NotNull
    public Set<String> getActiveProfiles() {
        Set set = this.myLocalAnnotationModel.getActiveProfiles();
        if (set == null) {
            AutoConfigurationModelBase.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public Set<String> getAllProfiles() {
        Set set = this.myLocalAnnotationModel.getAllProfiles();
        if (set == null) {
            AutoConfigurationModelBase.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public Set<PsiFile> getConfigFiles() {
        Set set = this.myLocalAnnotationModel.getConfigFiles();
        if (set == null) {
            AutoConfigurationModelBase.$$$reportNull$$$0(8);
        }
        return set;
    }

    public boolean hasConfigFile(@NotNull PsiFile configFile) {
        if (configFile == null) {
            AutoConfigurationModelBase.$$$reportNull$$$0(9);
        }
        return this.myLocalAnnotationModel.hasConfigFile(configFile);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AutoConfigurationModelBase model = (AutoConfigurationModelBase)((Object)o);
        return this.myConfigClass.equals(model.myConfigClass) && this.myLocalAnnotationModel.equals(model.myLocalAnnotationModel);
    }

    public int hashCode() {
        int result = this.myConfigClass.hashCode();
        result = 31 * result + this.myLocalAnnotationModel.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/autoconfigure/AutoConfigurationModelBase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentLocalModels";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "processConfigurationClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProfiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProfiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/autoconfigure/AutoConfigurationModelBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

