/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.boot.application.SpringBootApplicationUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.autoconfigure.EnableAutoConfigurationModel;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalAnnotationModelDependentModelsProvider;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.PairProcessor;

public class EnableAutoConfigDependentModelsProvider
extends LocalAnnotationModelDependentModelsProvider {
    public boolean processCustomDependentLocalModels(LocalAnnotationModel localAnnotationModel, PairProcessor<LocalModel, LocalModelDependency> processor2) {
        Module module = localAnnotationModel.getModule();
        if (!SpringCommonUtils.hasSpringFacet((Module)module) || !SpringBootLibraryUtil.hasSpringBootLibrary((Module)module)) {
            return true;
        }
        PsiClass localModelConfigClass = (PsiClass)localAnnotationModel.getConfig();
        if (!SpringBootApplicationUtil.isSpringApplication((PsiClass)localModelConfigClass)) {
            return true;
        }
        EnableAutoConfiguration enableAutoConfiguration = (EnableAutoConfiguration)EnableAutoConfiguration.META.getJamElement((PsiModifierListOwner)localModelConfigClass);
        if (enableAutoConfiguration == null || !enableAutoConfiguration.isValid()) {
            return true;
        }
        PsiClass enableAnnotationClass = JavaPsiFacade.getInstance((Project)localModelConfigClass.getProject()).findClass(enableAutoConfiguration.getAnnotationFqn(), localModelConfigClass.getResolveScope());
        if (enableAnnotationClass == null) {
            return true;
        }
        EnableAutoConfigurationModel enableAutoConfigModel = new EnableAutoConfigurationModel(localAnnotationModel, enableAutoConfiguration, enableAnnotationClass);
        PsiAnnotation enableAnnotation = enableAutoConfiguration.getAnnotation();
        return processor2.process((Object)enableAutoConfigModel, (Object)LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.UNKNOWN, (PsiElement)(enableAnnotation != null ? enableAnnotation : localModelConfigClass)));
    }
}

