/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions.jam;

import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemKey;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalContributor;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalContributors;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnJamElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class Conditional
implements ConditionalOnJamElement {
    private static final JamClassAttributeMeta.Collection VALUE_ATTRIBUTE = JamClassAttributeMeta.Collection.CLASS_COLLECTION_VALUE_META;
    private static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("org.springframework.context.annotation.Conditional").addAttribute((JamAttributeMeta)VALUE_ATTRIBUTE);
    private static final SemKey<Conditional> SEM_KEY = CONDITIONAL_JAM_ELEMENT_KEY.subKey("Conditional", new SemKey[0]);
    public static final JamClassMeta<Conditional> CLASS_META = new JamClassMeta(null, Conditional.class, SEM_KEY).addAnnotation(ANNOTATION_META);
    public static final JamMethodMeta<Conditional> METHOD_META = new JamMethodMeta(null, Conditional.class, SEM_KEY).addAnnotation(ANNOTATION_META);

    public boolean value(ConditionalOnEvaluationContext context) {
        boolean allConditionsEvaluated = true;
        boolean matchedAllConditions = false;
        for (PsiClass valueClass : this.getValue()) {
            matchedAllConditions = false;
            String fqn = valueClass != null ? valueClass.getQualifiedName() : null;
            if (fqn == null) continue;
            ConditionalContributor conditionalContributor = (ConditionalContributor)ConditionalContributors.INSTANCE.findSingle(fqn);
            if (conditionalContributor == null) {
                allConditionsEvaluated = false;
                continue;
            }
            boolean matches2 = conditionalContributor.value((Object)context);
            if (!matches2) {
                return false;
            }
            allConditionsEvaluated = true;
            matchedAllConditions = true;
        }
        if (allConditionsEvaluated) {
            return matchedAllConditions;
        }
        return true;
    }

    @JamPsiConnector
    @NotNull
    public abstract PsiModifierListOwner getPsiElement();

    public Collection<PsiClass> getValue() {
        List attribute = (List)ANNOTATION_META.getAttribute(this.getPsiElement(), (JamAttributeMeta)VALUE_ATTRIBUTE);
        return ContainerUtil.map((Collection)attribute, JamClassAttributeElement::getValue);
    }
}

