/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions.jam;

import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemKey;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnJamElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class ConditionalOnRepositoryType
implements ConditionalOnJamElement {
    private static final SemKey<ConditionalOnRepositoryType> SEM_KEY = CONDITIONAL_JAM_ELEMENT_KEY.subKey("ConditionalOnRepositoryType", new SemKey[0]);
    private static final JamStringAttributeMeta.Single<String> STORE_ATTRIBUTE_META = JamAttributeMeta.singleString((String)"store");
    private static final JamEnumAttributeMeta.Single<RepositoryType> TYPE_ATTRIBUTE_META = JamAttributeMeta.singleEnum((String)"type", RepositoryType.class);
    private static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("org.springframework.boot.autoconfigure.data.ConditionalOnRepositoryType").addAttribute(STORE_ATTRIBUTE_META).addAttribute(TYPE_ATTRIBUTE_META);
    public static final JamClassMeta<ConditionalOnRepositoryType> CLASS_META = new JamClassMeta(null, ConditionalOnRepositoryType.class, SEM_KEY).addAnnotation(ANNOTATION_META);
    public static final JamMethodMeta<ConditionalOnRepositoryType> METHOD_META = new JamMethodMeta(null, ConditionalOnRepositoryType.class, SEM_KEY).addAnnotation(ANNOTATION_META);
    private final PsiElementRef<PsiAnnotation> myAnnotationRef;

    public ConditionalOnRepositoryType(PsiModifierListOwner owner) {
        this.myAnnotationRef = ANNOTATION_META.getAnnotationRef(owner);
    }

    public boolean value(ConditionalOnEvaluationContext context) {
        String store = this.getStore();
        if (StringUtil.isEmpty((String)store)) {
            return false;
        }
        RepositoryType requiredType = this.getType();
        if (requiredType == null) {
            return false;
        }
        String storeConfigKeyName = "spring.data." + store + ".repositories.type";
        Ref configuredValueRef = Ref.create((Object)RepositoryType.AUTO.name());
        Processor findValueProcessor = results -> {
            SpringBootModelConfigFileContributor.ConfigurationValueResult item = (SpringBootModelConfigFileContributor.ConfigurationValueResult)ContainerUtil.getFirstItem((List)results);
            if (item != null) {
                configuredValueRef.set((Object)item.valueText);
            }
            return false;
        };
        context.processConfigurationValues(findValueProcessor, true, storeConfigKeyName);
        String configuredValue = (String)configuredValueRef.get();
        if (configuredValue == null) {
            return false;
        }
        try {
            RepositoryType configuredRepositoryType = Enum.valueOf(RepositoryType.class, configuredValue.toUpperCase(Locale.US));
            return configuredRepositoryType == requiredType || configuredRepositoryType == RepositoryType.AUTO;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Nullable
    public String getStore() {
        return STORE_ATTRIBUTE_META.getJam(this.myAnnotationRef).getStringValue();
    }

    @Nullable
    public RepositoryType getType() {
        return (RepositoryType)TYPE_ATTRIBUTE_META.getJam(this.myAnnotationRef).getValue();
    }

    static enum RepositoryType {
        AUTO,
        IMPERATIVE,
        NONE,
        REACTIVE;

    }
}

