/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.properties;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.spring.boot.application.config.SpringBootConfigurationPropertyReferenceSearcher;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringBootApiIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationPropertyRelatedItemLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    private static final String POPUP_TITLE = "Spring Boot Configuration Files";
    private static final NotNullFunction<PsiReference, Collection<? extends GotoRelatedItem>> RELATED_ITEM_CONVERTER = reference -> {
        final FakePsiElement fakeElement = ((MetaConfigKeyReference)reference).createNavigationElement();
        return Collections.singleton(new GotoRelatedItem((PsiElement)fakeElement, POPUP_TITLE){

            @Nullable
            public String getCustomContainerName() {
                return ((ItemPresentation)ObjectUtils.assertNotNull((Object)fakeElement.getPresentation())).getLocationString();
            }
        });
    };
    private static final NotNullFunction<PsiReference, Collection<? extends PsiElement>> PSI_REFERENCE_CONVERTER = reference -> Collections.singleton(((MetaConfigKeyReference)reference).createNavigationElement());
    private static final Processor<PsiReference> HAS_META_CONFIG_KEY_PROCESSOR = reference -> !(reference instanceof MetaConfigKeyReference);

    public String getId() {
        return "ConfigurationPropertyRelatedItemLineMarkerProvider";
    }

    public String getName() {
        return "Configuration Properties";
    }

    @Nullable
    public Icon getIcon() {
        return SpringBootApiIcons.SpringBoot;
    }

    public void collectNavigationMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            ConfigurationPropertyRelatedItemLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            ConfigurationPropertyRelatedItemLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringCommonUtils.hasSpringFacets((Project)psiElement.getProject()) || !SpringBootLibraryUtil.hasSpringBootLibrary((Project)psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (element == null) {
            ConfigurationPropertyRelatedItemLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            ConfigurationPropertyRelatedItemLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (!(element instanceof PsiMethod)) {
            return;
        }
        PsiMethod psiMethod = (PsiMethod)element;
        String prefix = SpringBootConfigurationPropertyReferenceSearcher.getPrefixIfRelevantPropertyMethod(psiMethod, true);
        if (prefix == null) {
            return;
        }
        GlobalSearchScope fakeScope = GlobalSearchScope.EMPTY_SCOPE;
        final Query search = MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)fakeScope, (boolean)true);
        if (search.forEach(HAS_META_CONFIG_KEY_PROCESSOR)) {
            return;
        }
        PsiIdentifier nameIdentifier = psiMethod.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        SpringGutterIconBuilder builder = SpringGutterIconBuilder.createBuilder((Icon)SpringBootApiIcons.SpringBoot, PSI_REFERENCE_CONVERTER, RELATED_ITEM_CONVERTER);
        builder.setTooltipText("Usage in Spring Boot Configuration Files").setPopupTitle(POPUP_TITLE).setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends PsiReference>>(){

            @NotNull
            protected Collection<? extends PsiReference> compute() {
                List list = ContainerUtil.findAll((Collection)search.findAll(), MetaConfigKeyReference.class);
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/properties/ConfigurationPropertyRelatedItemLineMarkerProvider$2", "compute"));
            }
        });
        result.add((RelatedItemLineMarkerInfo)builder.createSpringRelatedMergeableLineMarkerInfo((PsiElement)nameIdentifier));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/model/properties/ConfigurationPropertyRelatedItemLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

