/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.injection.el;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.ELImplicitVariable;
import com.intellij.psi.impl.source.jsp.JspImplicitVariableImpl;
import com.intellij.spring.el.contextProviders.SpringElContextProvider;
import com.intellij.spring.integration.SpringIntegrationBundle;
import com.intellij.spring.integration.injection.el.HeadersVariable;
import com.intellij.spring.integration.injection.el.PayloadTypeProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.Nullable;

public class SpringIntegrationELContextProvider
extends SpringElContextProvider {
    private static final String PREDEFINED_VARIABLE_PAYLOAD = "payload";

    public SpringIntegrationELContextProvider(PsiLanguageInjectionHost host) {
        super((PsiElement)host);
    }

    public Iterator<? extends PsiVariable> getTopLevelElVariables(@Nullable String nameHint) {
        if (nameHint == null) {
            Collection vars = this.getAllVariables(this.myHost);
            vars.add(this.createHeadersVariable());
            vars.add(this.createPayloadVariable());
            return vars.iterator();
        }
        if (nameHint.equals("headers")) {
            return Collections.singleton(this.createHeadersVariable()).iterator();
        }
        if (nameHint.equals(PREDEFINED_VARIABLE_PAYLOAD)) {
            return Collections.singleton(this.createPayloadVariable()).iterator();
        }
        return super.getVariable(nameHint, this.myHost);
    }

    private ELImplicitVariable createHeadersVariable() {
        return new HeadersVariable(this.myHost);
    }

    private ELImplicitVariable createPayloadVariable() {
        return new JspImplicitVariableImpl(this.myHost.getContext(), PREDEFINED_VARIABLE_PAYLOAD, PayloadTypeProvider.resolvePayloadType(this.myHost.getContext()), null){

            @Nullable
            public String getLocationString() {
                return SpringIntegrationBundle.message("el.location.name", new Object[0]);
            }
        };
    }
}

