/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.AddCommand;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.ListModification;
import org.jetbrains.idea.perforce.application.ModifyComment;
import org.jetbrains.idea.perforce.application.ModifyName;
import org.jetbrains.idea.perforce.application.NumberNameModifier;
import org.jetbrains.idea.perforce.application.PerforceChangeListListener;
import org.jetbrains.idea.perforce.application.PerforceNumberNameMap;
import org.jetbrains.idea.perforce.perforce.PerforceChangeList;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

@State(name="PerforceNumberNameSynchronizer", storages={@Storage(value="$WORKSPACE_FILE$")})
public class PerforceNumberNameSynchronizer
extends AbstractProjectComponent
implements PersistentStateComponent<ConfigBean> {
    private final Map<ConnectionKey, MyMapWrapper> myMap = new HashMap<ConnectionKey, MyMapWrapper>();
    private final Object myLock = new Object();
    private final PerforceChangeListListener myPerforceChangeListListener;
    private final ChangeListManager myChangeListManager;
    private ConfigBean myConfig = new ConfigBean();

    private PerforceNumberNameSynchronizer(Project project) {
        super(project);
        this.myPerforceChangeListListener = new PerforceChangeListListener(this.myProject, this, new MyCommonModifier());
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void handleChangeListSubmitted(@NotNull P4Connection connection, long changeListNumber, long l) {
        void newNumber;
        if (connection == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(0);
        }
        if (changeListNumber != -1L && newNumber == -1L) {
            Object object = this.myLock;
            synchronized (object) {
                String name;
                ConnectionKey connectionKey = connection.getConnectionKey();
                MyMapWrapper wrapper = this.myMap.get(connectionKey);
                if (wrapper != null && (name = wrapper.getMap().getName(changeListNumber)) != null) {
                    wrapper.remove(name, changeListNumber);
                    wrapper.removeListIfEmpty(name);
                }
            }
        }
    }

    private void createDefaultChangeList() {
        String defaultName = LocalChangeList.DEFAULT_NAME;
        LocalChangeList result = this.myChangeListManager.findChangeList(defaultName);
        if (result != null) {
            this.myChangeListManager.setReadOnly(result.getName(), true);
        } else {
            LocalChangeList changeList = this.myChangeListManager.addChangeList(defaultName, "");
            this.myChangeListManager.setReadOnly(changeList.getName(), true);
        }
    }

    public void startListening() {
        this.createDefaultChangeList();
        this.myChangeListManager.addChangeListListener((ChangeListListener)this.myPerforceChangeListListener);
    }

    public void stopListening() {
        this.myChangeListManager.removeChangeListListener((ChangeListListener)this.myPerforceChangeListListener);
    }

    public static PerforceNumberNameSynchronizer getInstance(Project project) {
        return (PerforceNumberNameSynchronizer)((Object)project.getComponent(PerforceNumberNameSynchronizer.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        Object object = this.myLock;
        synchronized (object) {
            for (MyMapWrapper wrapper : this.myMap.values()) {
                wrapper.getMap().cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> findOrCreate(@NotNull P4Connection connection, LocalChangeList list) throws VcsException {
        String description;
        if (connection == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(1);
        }
        String listName = list.getName();
        if (list.hasDefaultName()) {
            return Collections.singletonList(-1L);
        }
        ConnectionKey key = connection.getConnectionKey();
        Object object = this.myLock;
        synchronized (object) {
            PerforceNumberNameMap map = this.ensureGetWrapper(key).getMap();
            Collection<Long> numbers = map.getNumbers(listName);
            if (numbers != null && !numbers.isEmpty()) {
                return numbers;
            }
            description = PerforceNumberNameSynchronizer.getP4Description((ChangeList)list, map);
        }
        long newNumber = this.createList(connection, description);
        Object object2 = this.myLock;
        synchronized (object2) {
            PerforceNumberNameMap map = this.ensureGetWrapper(key).getMap();
            map.add(listName);
            map.put(listName, newNumber);
            return Collections.singletonList(newNumber);
        }
    }

    private long createList(P4Connection connection, String description) throws VcsException {
        PerforceRunner runner = PerforceRunner.getInstance(this.myProject);
        for (PerforceChangeList changeList : runner.getPendingChangeLists(connection)) {
            if (!Comparing.equal((String)changeList.getName(), (String)description) || !changeList.getChanges().isEmpty()) continue;
            return changeList.getNumber();
        }
        return runner.createChangeList(description, connection, null);
    }

    private static String getP4Description(ChangeList list, PerforceNumberNameMap map) {
        String description = list.getComment().trim();
        if (description.length() == 0) {
            return list.getName();
        }
        Collection<Long> existingWithNameAsDescription = map.getNumbers(description);
        if (existingWithNameAsDescription != null && !existingWithNameAsDescription.isEmpty()) {
            return list.getName();
        }
        return description;
    }

    private MyMapWrapper ensureGetWrapper(ConnectionKey key) {
        MyMapWrapper wrapper = this.myMap.get(key);
        if (wrapper == null) {
            wrapper = new MyMapWrapper(new PerforceNumberNameMap());
            this.myMap.put(key, wrapper);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> acceptInfo(ConnectionKey key, Collection<PerforceChangeList> lists, ChangeListManagerGate gate) {
        CommandsMerger commandsMerger = new CommandsMerger();
        Object object = this.myLock;
        synchronized (object) {
            MyMapWrapper wrapper = this.ensureGetWrapper(key);
            for (PerforceChangeList changeList : lists) {
                String nativeDescription = changeList.getName();
                Long number = changeList.getNumber();
                String listName = wrapper.getMap().getName(number);
                if (listName != null) {
                    LocalChangeList list = gate.findChangeList(listName);
                    String oldComment = list == null ? "" : StringUtil.notNullize((String)list.getComment()).trim();
                    NameComparator.check(listName.trim(), oldComment, nativeDescription, commandsMerger, number);
                    continue;
                }
                NameComparator.check(null, null, nativeDescription, commandsMerger, number);
            }
            commandsMerger.execute(this.myProject, gate, wrapper);
            return wrapper.getMap().removeEmpty(lists);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName(@NotNull ConnectionKey key, @NotNull Long number) {
        if (key == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(2);
        }
        if (number == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            MyMapWrapper wrapper = this.myMap.get(key);
            if (wrapper != null) {
                return wrapper.getMap().getName(number);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> getNumbers(@NotNull ConnectionKey key, @NotNull String name) {
        if (key == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(4);
        }
        if (name == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        synchronized (object) {
            MyMapWrapper wrapper = this.myMap.get(key);
            if (wrapper != null) {
                return wrapper.getMap().getNumbers(name);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getAnyNumber(@NotNull ConnectionKey key, @NotNull String name) {
        if (key == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(6);
        }
        if (name == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(7);
        }
        Object object = this.myLock;
        synchronized (object) {
            Collection<Long> numbers = this.getNumbers(key, name);
            return numbers == null ? null : (numbers.isEmpty() ? null : numbers.iterator().next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiMap<ConnectionKey, Long> getAllNumbers(@NotNull String name) {
        if (name == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(8);
        }
        MultiMap numbers = MultiMap.create();
        Object object = this.myLock;
        synchronized (object) {
            for (Map.Entry<ConnectionKey, MyMapWrapper> entry : this.myMap.entrySet()) {
                numbers.putValues((Object)entry.getKey(), entry.getValue().getMap().getNumbers(name));
            }
        }
        return numbers;
    }

    public void setHidden(Long number, boolean hidden) {
        if (hidden) {
            this.myConfig.removedFromIdea.add(number);
        } else {
            this.myConfig.removedFromIdea.remove(number);
        }
    }

    public boolean isHidden(Long number) {
        return this.myConfig.removedFromIdea.contains(number);
    }

    @Nullable
    public ConfigBean getState() {
        return this.myConfig;
    }

    public void loadState(ConfigBean state) {
        this.myConfig = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceNumberNameSynchronizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleChangeListSubmitted";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findOrCreate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getNumbers";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnyNumber";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllNumbers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ConfigBean {
        public Set<Long> removedFromIdea = Collections.synchronizedSet(ContainerUtil.newLinkedHashSet());
    }

    private class MyMapWrapper
    implements NumberNameModifier {
        private final PerforceNumberNameMap myMap;

        private MyMapWrapper(PerforceNumberNameMap map) {
            this.myMap = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rename(@NotNull String from, @NotNull String to) {
            if (from == null) {
                MyMapWrapper.$$$reportNull$$$0(0);
            }
            if (to == null) {
                MyMapWrapper.$$$reportNull$$$0(1);
            }
            Object object = PerforceNumberNameSynchronizer.this.myLock;
            synchronized (object) {
                this.myMap.rename(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(@NotNull String name) {
            if (name == null) {
                MyMapWrapper.$$$reportNull$$$0(2);
            }
            Object object = PerforceNumberNameSynchronizer.this.myLock;
            synchronized (object) {
                this.myMap.add(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(@NotNull String name, @NotNull Long nativeNumber) {
            if (name == null) {
                MyMapWrapper.$$$reportNull$$$0(3);
            }
            if (nativeNumber == null) {
                MyMapWrapper.$$$reportNull$$$0(4);
            }
            Object object = PerforceNumberNameSynchronizer.this.myLock;
            synchronized (object) {
                this.myMap.put(name, nativeNumber);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(@NotNull String name, @NotNull Long nativeNumber) {
            if (name == null) {
                MyMapWrapper.$$$reportNull$$$0(5);
            }
            if (nativeNumber == null) {
                MyMapWrapper.$$$reportNull$$$0(6);
            }
            Object object = PerforceNumberNameSynchronizer.this.myLock;
            synchronized (object) {
                this.myMap.remove(name, nativeNumber);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListIfEmpty(@NotNull String name) {
            if (name == null) {
                MyMapWrapper.$$$reportNull$$$0(7);
            }
            Object object = PerforceNumberNameSynchronizer.this.myLock;
            synchronized (object) {
                this.myMap.removeListIfEmpty(name);
            }
        }

        public PerforceNumberNameMap getMap() {
            return this.myMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean haveSingleAssociation(@NotNull String name) {
            if (name == null) {
                MyMapWrapper.$$$reportNull$$$0(8);
            }
            Object object = PerforceNumberNameSynchronizer.this.myLock;
            synchronized (object) {
                return this.myMap.haveSingleAssociation(name);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nativeNumber";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceNumberNameSynchronizer$MyMapWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rename";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "put";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "remove";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeListIfEmpty";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "haveSingleAssociation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyCommonModifier
    implements NumberNameModifier {
        private MyCommonModifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void each(Consumer<PerforceNumberNameMap> consumer) {
            Object object = PerforceNumberNameSynchronizer.this.myLock;
            synchronized (object) {
                Set connections = PerforceNumberNameSynchronizer.this.myMap.keySet();
                for (ConnectionKey connection : connections) {
                    MyMapWrapper wrapper = (MyMapWrapper)PerforceNumberNameSynchronizer.this.myMap.get(connection);
                    consumer.consume((Object)wrapper.getMap());
                }
            }
        }

        @Override
        public void rename(@NotNull String from, @NotNull String to) {
            if (from == null) {
                MyCommonModifier.$$$reportNull$$$0(0);
            }
            if (to == null) {
                MyCommonModifier.$$$reportNull$$$0(1);
            }
            this.each((Consumer<PerforceNumberNameMap>)((Consumer)perforceNumberNameMap -> {
                if (from == null) {
                    MyCommonModifier.$$$reportNull$$$0(12);
                }
                if (to == null) {
                    MyCommonModifier.$$$reportNull$$$0(13);
                }
                perforceNumberNameMap.rename(from, to);
            }));
        }

        @Override
        public void add(@NotNull String name) {
            if (name == null) {
                MyCommonModifier.$$$reportNull$$$0(2);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void put(@NotNull String name, @NotNull Long nativeNumber) {
            if (name == null) {
                MyCommonModifier.$$$reportNull$$$0(3);
            }
            if (nativeNumber == null) {
                MyCommonModifier.$$$reportNull$$$0(4);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(@NotNull String name, @NotNull Long nativeNumber) {
            if (name == null) {
                MyCommonModifier.$$$reportNull$$$0(5);
            }
            if (nativeNumber == null) {
                MyCommonModifier.$$$reportNull$$$0(6);
            }
            this.each((Consumer<PerforceNumberNameMap>)((Consumer)perforceNumberNameMap -> {
                if (name == null) {
                    MyCommonModifier.$$$reportNull$$$0(10);
                }
                if (nativeNumber == null) {
                    MyCommonModifier.$$$reportNull$$$0(11);
                }
                perforceNumberNameMap.remove(name, nativeNumber);
            }));
        }

        @Override
        public void removeListIfEmpty(@NotNull String name) {
            if (name == null) {
                MyCommonModifier.$$$reportNull$$$0(7);
            }
            this.each((Consumer<PerforceNumberNameMap>)((Consumer)perforceNumberNameMap -> {
                if (name == null) {
                    MyCommonModifier.$$$reportNull$$$0(9);
                }
                perforceNumberNameMap.removeListIfEmpty(name);
            }));
        }

        @Override
        public boolean haveSingleAssociation(@NotNull String name) {
            if (name == null) {
                MyCommonModifier.$$$reportNull$$$0(8);
            }
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 1: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: 
                case 6: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nativeNumber";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceNumberNameSynchronizer$MyCommonModifier";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rename";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "put";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "remove";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeListIfEmpty";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "haveSingleAssociation";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$removeListIfEmpty$2";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$remove$1";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$rename$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CommandsMerger
    implements CommandsAcceptor {
        private final MultiMap<String, AddCommand> myAddCommandMap = new MultiMap();
        private final MultiMap<String, ModifyName> myModifyNameMap;
        private final MultiMap<String, ModifyComment> myModifyCommentMap = new MultiMap();

        private CommandsMerger() {
            this.myModifyNameMap = new MultiMap();
        }

        public void execute(Project project, ChangeListManagerGate gate, NumberNameModifier modifier) {
            CommandsMerger.execute(this.myAddCommandMap, project, gate, modifier);
            CommandsMerger.execute(this.myModifyNameMap, project, gate, modifier);
            for (String name : this.myModifyCommentMap.keySet()) {
                ArrayList commands = new ArrayList(this.myModifyCommentMap.get((Object)name));
                CommandsMerger.filterSame(commands);
                LocalChangeList list = gate.findChangeList(name);
                if (list == null || !modifier.haveSingleAssociation(name) && !StringUtil.isEmptyOrSpaces((String)list.getComment()) || commands.size() != 1) continue;
                for (ListModification command : commands) {
                    command.execute(project, gate, modifier);
                }
            }
        }

        private static <T extends ListModification<T>> void execute(MultiMap<String, T> commandsMap, Project project, ChangeListManagerGate gate, NumberNameModifier modifier) {
            for (String name : commandsMap.keySet()) {
                ArrayList commands = new ArrayList(commandsMap.get((Object)name));
                CommandsMerger.filterSame(commands);
                for (ListModification command : commands) {
                    command.execute(project, gate, modifier);
                }
            }
        }

        private static <T extends ListModification<T>> void filterSame(List<T> coll) {
            Iterator<T> iterator = coll.iterator();
            while (iterator.hasNext()) {
                ListModification t = (ListModification)iterator.next();
                if (!t.doesNothing()) continue;
                iterator.remove();
            }
        }

        @Override
        public void accept(ModifyName modifyName) {
            if (modifyName.doesNothing()) {
                return;
            }
            this.myModifyNameMap.putValue((Object)modifyName.getOldName(), (Object)modifyName);
        }

        @Override
        public void accept(ModifyComment modifyComment) {
            if (modifyComment.doesNothing()) {
                return;
            }
            this.myModifyCommentMap.putValue((Object)modifyComment.getNewName(), (Object)modifyComment);
        }

        @Override
        public void accept(AddCommand addCommand) {
            this.myAddCommandMap.putValue((Object)addCommand.getNewName(), (Object)addCommand);
        }
    }

    private static interface CommandsAcceptor {
        public void accept(ModifyName var1);

        public void accept(ModifyComment var1);

        public void accept(AddCommand var1);
    }

    private static class NameComparator {
        private NameComparator() {
        }

        public static void check(String oldName, String oldComment, String nativeDescription, CommandsAcceptor commandsAcceptor, Long number) {
            String nativeTrimmed = nativeDescription.trim();
            String firstLine = NameComparator.getFirstLine(nativeTrimmed);
            if (oldName == null) {
                NameComparator.processAdd(commandsAcceptor, number, nativeTrimmed, firstLine);
                return;
            }
            if (oldComment == null || oldComment.length() == 0) {
                if (firstLine != null) {
                    commandsAcceptor.accept(new ModifyName(oldName, firstLine, number, oldComment));
                    commandsAcceptor.accept(new ModifyComment(firstLine, oldComment, nativeTrimmed, number));
                } else {
                    commandsAcceptor.accept(new ModifyName(oldName, nativeTrimmed, number, oldComment));
                }
            } else if (Comparing.equal((String)oldName, (String)NameComparator.getFirstLine(oldComment))) {
                if (firstLine == null) {
                    commandsAcceptor.accept(new ModifyName(oldName, nativeTrimmed, number, oldComment));
                    commandsAcceptor.accept(new ModifyComment(nativeTrimmed, oldComment, "", number));
                } else {
                    commandsAcceptor.accept(new ModifyName(oldName, firstLine, number, oldComment));
                    commandsAcceptor.accept(new ModifyComment(firstLine, oldComment, nativeTrimmed, number));
                }
            } else {
                commandsAcceptor.accept(new ModifyComment(oldName, oldComment, nativeTrimmed, number));
            }
        }

        private static void processAdd(CommandsAcceptor commandsAcceptor, Long number, String nativeTrimmed, String firstLine) {
            String comment;
            String name;
            if (firstLine == null) {
                name = nativeTrimmed;
                comment = "";
            } else {
                name = firstLine;
                comment = nativeTrimmed;
            }
            commandsAcceptor.accept(new AddCommand(name, comment, number));
        }

        @Nullable
        private static String getFirstLine(String description) {
            String firstLine = null;
            int pos = description.indexOf("\n");
            if (pos >= 0) {
                firstLine = description.substring(0, pos).trim() + "...";
            }
            return firstLine;
        }
    }
}

