/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.SystemProperties;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceBaseInfoWorker;
import org.jetbrains.idea.perforce.application.PerforceClientRootsChecker;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.FStat;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;

public final class P4File {
    private final VirtualFile myVFile;
    private final VirtualFile myParentDirOfDeleted;
    private final String myName;
    private FStat myFstat = null;
    private String myLocalPath = null;
    @NonNls
    private static final String VF_CACHE = "P4_VF_CACHE";
    public static final Key<P4File> KEY = new Key("P4_VF_CACHE");

    private P4File(String name, VirtualFile vFile, VirtualFile parentDirOfDeleted) {
        this.myParentDirOfDeleted = parentDirOfDeleted;
        this.myVFile = vFile;
        this.myName = name;
    }

    @NotNull
    public static P4File createInefficientFromLocalPath(String localPath) {
        P4File p4File = new P4File(null, null, null);
        p4File.myLocalPath = localPath;
        P4File p4File2 = p4File;
        if (p4File2 == null) {
            P4File.$$$reportNull$$$0(0);
        }
        return p4File2;
    }

    @NotNull
    public static P4File createInefficientFromLocalPath(String localPath, String name, VirtualFile vFile, VirtualFile parentDirOfDeleted) {
        P4File p4File = new P4File(name, vFile, parentDirOfDeleted);
        p4File.myLocalPath = localPath;
        P4File p4File2 = p4File;
        if (p4File2 == null) {
            P4File.$$$reportNull$$$0(1);
        }
        return p4File2;
    }

    @NotNull
    public static P4File create(@NotNull VirtualFile vFile) {
        P4File p4File;
        Object userData;
        if (vFile == null) {
            P4File.$$$reportNull$$$0(2);
        }
        if ((userData = vFile.getUserData(KEY)) != null) {
            p4File = (P4File)userData;
        } else {
            p4File = new P4File(null, vFile, null);
            p4File.myVFile.putUserData(KEY, (Object)p4File);
        }
        P4File p4File2 = p4File;
        if (p4File2 == null) {
            P4File.$$$reportNull$$$0(3);
        }
        return p4File2;
    }

    @NotNull
    public static P4File create(@NotNull FilePath filePath) {
        VirtualFile virtualFile;
        if (filePath == null) {
            P4File.$$$reportNull$$$0(4);
        }
        if ((virtualFile = filePath.getVirtualFile()) != null) {
            P4File p4File = P4File.create(virtualFile);
            if (p4File == null) {
                P4File.$$$reportNull$$$0(5);
            }
            return p4File;
        }
        P4File p4File = P4File.createInefficientFromLocalPath(filePath.getPath(), filePath.getName(), null, filePath.getVirtualFileParent());
        if (p4File == null) {
            P4File.$$$reportNull$$$0(6);
        }
        return p4File;
    }

    @NotNull
    public static P4File create(@NotNull File file) {
        VirtualFile virtualFile;
        if (file == null) {
            P4File.$$$reportNull$$$0(7);
        }
        if ((virtualFile = P4File.findVirtualFile(file)) != null) {
            P4File p4File = P4File.create(virtualFile);
            if (p4File == null) {
                P4File.$$$reportNull$$$0(8);
            }
            return p4File;
        }
        P4File p4File = P4File.createInefficientFromLocalPath(file.getAbsolutePath(), file.getName(), null, P4File.findVirtualFile(file.getParentFile()));
        if (p4File == null) {
            P4File.$$$reportNull$$$0(9);
        }
        return p4File;
    }

    private static VirtualFile findVirtualFile(@NotNull File file) {
        if (file == null) {
            P4File.$$$reportNull$$$0(10);
        }
        return (VirtualFile)ReadAction.compute(() -> {
            if (file == null) {
                P4File.$$$reportNull$$$0(12);
            }
            return LocalFileSystem.getInstance().findFileByIoFile(file);
        });
    }

    public String getEscapedPath() {
        return P4File.escapeWildcards(this.getLocalPath());
    }

    public String getRecursivePath() {
        String filePath = this.getEscapedPath();
        if (this.isDirectory()) {
            return filePath + "/...";
        }
        return filePath;
    }

    public static String escapeWildcards(String path) {
        path = path.replace("%", "%25");
        path = path.replace("@", "%40");
        path = path.replace("#", "%23");
        return path;
    }

    public static String unescapeWildcards(String path) {
        path = path.replace("%23", "#");
        path = path.replace("%40", "@");
        path = path.replace("%25", "%");
        return path;
    }

    public void invalidateFstat() {
        this.myFstat = null;
        if (this.myVFile != null && this.myVFile.isValid()) {
            P4File.invalidateFstat(this.myVFile);
        }
    }

    public static void invalidateFstat(Project project) {
        ApplicationManager.getApplication().runReadAction(() -> {
            PerforceVcs perforceVcs = PerforceVcs.getInstance(project);
            for (VirtualFile contentRoot : ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcsWithoutFiltering((AbstractVcs)perforceVcs)) {
                P4File.invalidateFstat(contentRoot);
            }
        });
    }

    public static void invalidateFstat(VirtualFile file) {
        ApplicationManager.getApplication().runReadAction(() -> P4File.invalidateFStatImpl(file));
    }

    private static void invalidateFStatImpl(VirtualFile file) {
        if (file.getFileSystem() == LocalFileSystem.getInstance()) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

                public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return ((NewVirtualFile)file).getCachedChildren();
                }

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    file.putUserData(KEY, null);
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "file";
                    objectArray2[1] = "org/jetbrains/idea/perforce/perforce/P4File$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getChildrenIterable";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitFile";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    public void clearCache() {
        this.myFstat = null;
        if (this.myVFile != null) {
            this.myLocalPath = null;
        }
    }

    public FStat getFstat(Project project, boolean forceNew) throws VcsException {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        PerforceRunner perforceRunner = PerforceRunner.getInstance(project);
        return this.getFstat((PerforceBaseInfoWorker)ServiceManager.getService((Project)project, PerforceBaseInfoWorker.class), changeListManager, perforceRunner, forceNew);
    }

    public FStat getFstat(PerforceBaseInfoWorker baseInfoWorker, ChangeListManager changeListManager, PerforceRunner perforceRunner, boolean forceNew) throws VcsException {
        long lastValidTime = baseInfoWorker.getLastValidTime();
        if (this.myFstat == null || forceNew || this.myFstat.statTime < lastValidTime || lastValidTime == -1L) {
            if (this.myVFile != null && changeListManager.isUnversioned(this.myVFile) && !forceNew) {
                this.myFstat = new FStat();
                this.myFstat.status = FStat.STATUS_NOT_ADDED;
            } else {
                this.myFstat = perforceRunner.getProxy().fstat(this);
            }
        }
        return this.myFstat;
    }

    public File getLocalFile() {
        return new File(this.getLocalPath());
    }

    @NotNull
    public String getLocalPath() {
        if (this.myLocalPath == null) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (this.myVFile != null) {
                    this.myLocalPath = this.myVFile.getPath();
                } else if (this.myParentDirOfDeleted != null) {
                    this.myLocalPath = this.myParentDirOfDeleted.getPath() + SystemProperties.getLineSeparator() + this.myName;
                } else {
                    throw new RuntimeException(PerforceBundle.message((String)"exception.text.cannot.figure.out.local.path", (Object[])new Object[0]));
                }
            });
        }
        String string = this.myLocalPath;
        if (string == null) {
            P4File.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NonNls
    public String toString() {
        return "org.jetbrains.idea.perforce.perforce.P4File{'" + this.getLocalPath() + "'}";
    }

    public boolean isDirectory() {
        if (this.myVFile != null) {
            return this.myVFile.isDirectory();
        }
        return PerforceClientRootsChecker.isDirectory(this.getLocalFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/perforce/P4File";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createInefficientFromLocalPath";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/perforce/P4File";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findVirtualFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

