/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionCalculator;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionMapper;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionProblemsNotifier;
import org.jetbrains.idea.perforce.perforce.connections.PerforceMultipleConnections;
import org.jetbrains.idea.perforce.perforce.connections.PerforceP4ConfigVirtualFileListener;
import org.jetbrains.idea.perforce.perforce.connections.SingletonConnection;

public class PerforceConnectionManager
implements PerforceConnectionManagerI {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager");
    private PerforceSettings mySettings;
    private final Project myProject;
    private PerforceConnectionMapper myConnectionMapper;
    private final VirtualFileListener myVirtualFileListener;
    private MessageBusConnection myMessageBusConnection;
    private final Object myLock = new Object();
    private final PerforceConnectionProblemsNotifier myNotifier;

    public PerforceConnectionManager(Project project, PerforceConnectionProblemsNotifier notifier, PerforceSettings perforceSettings) {
        this.myNotifier = notifier;
        this.mySettings = perforceSettings;
        this.myProject = project;
        this.myVirtualFileListener = new PerforceP4ConfigVirtualFileListener(this, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private PerforceConnectionMapper getConnectionMapper() {
        void var1_4;
        Object object = this.myLock;
        // MONITORENTER : object
        if (this.myConnectionMapper != null) {
            PerforceConnectionMapper perforceConnectionMapper = this.myConnectionMapper;
            // MONITOREXIT : object
            if (perforceConnectionMapper != null) return perforceConnectionMapper;
            PerforceConnectionManager.$$$reportNull$$$0(0);
            return perforceConnectionMapper;
        }
        // MONITOREXIT : object
        if (this.isSingletonConnectionUsed()) {
            SingletonConnection singletonConnection = SingletonConnection.getInstance(this.myProject);
        } else {
            P4ConnectionCalculator calculator = new P4ConnectionCalculator(this.myProject);
            calculator.execute();
            PerforceMultipleConnections perforceMultipleConnections = calculator.getMultipleConnections();
        }
        Object object2 = this.myLock;
        // MONITORENTER : object2
        if (this.myConnectionMapper == null) {
            this.myConnectionMapper = var1_4;
            if (var1_4 instanceof PerforceMultipleConnections) {
                this.myNotifier.setProblems(((PerforceMultipleConnections)var1_4).hasAnyErrors(), false);
            }
        }
        void v1 = var1_4;
        // MONITOREXIT : object2
        if (v1 != null) return v1;
        PerforceConnectionManager.$$$reportNull$$$0(1);
        return v1;
    }

    @Override
    @Nullable
    public PerforceMultipleConnections getMultipleConnectionObject() {
        PerforceConnectionMapper mapper = this.getConnectionMapper();
        return mapper instanceof PerforceMultipleConnections ? (PerforceMultipleConnections)mapper : null;
    }

    public static PerforceConnectionManagerI getInstance(Project project) {
        return (PerforceConnectionManagerI)ServiceManager.getService((Project)project, PerforceConnectionManagerI.class);
    }

    @Override
    @NotNull
    public Map<VirtualFile, P4Connection> getAllConnections() {
        Map<VirtualFile, P4Connection> map = this.getConnectionMapper().getAllConnections();
        if (map == null) {
            PerforceConnectionManager.$$$reportNull$$$0(2);
        }
        return map;
    }

    private Project getProject() {
        return this.myProject;
    }

    @Nullable
    public static VirtualFile findNearestLiveParentFor(File ioFile) {
        do {
            VirtualFile parent;
            if ((parent = LocalFileSystem.getInstance().findFileByIoFile(ioFile)) == null) continue;
            return parent;
        } while ((ioFile = ioFile.getParentFile()) != null);
        return null;
    }

    @Override
    @Nullable
    public P4Connection getConnectionForFile(@NotNull File file) {
        if (file == null) {
            PerforceConnectionManager.$$$reportNull$$$0(3);
        }
        if (this.isSingletonConnectionUsed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getConnectionForFile(" + file + ") returning singleton");
            }
            return (P4Connection)ReadAction.compute(() -> this.myProject.isDisposed() ? null : this.getConnectionMapper().getConnection(this.myProject.getBaseDir()));
        }
        VirtualFile vFile = PerforceConnectionManager.findNearestLiveParentFor(file);
        if (vFile == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getConnectionForFile(" + file + ") found no live parent");
            }
            return null;
        }
        return this.getConnectionForFile(vFile);
    }

    @Override
    public P4Connection getConnectionForFile(@NotNull P4File file) {
        if (file == null) {
            PerforceConnectionManager.$$$reportNull$$$0(4);
        }
        return this.getConnectionForFile(file.getLocalFile());
    }

    @Override
    public P4Connection getConnectionForFile(@NotNull VirtualFile file) {
        if (file == null) {
            PerforceConnectionManager.$$$reportNull$$$0(5);
        }
        return this.getConnectionMapper().getConnection(file);
    }

    @Override
    public boolean isSingletonConnectionUsed() {
        return !this.mySettings.useP4CONFIG;
    }

    public void startListening() {
        this.myMessageBusConnection = this.getProject().getMessageBus().connect();
        this.myMessageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                PerforceConnectionManager.this.updateConnections();
            }
        });
        this.myMessageBusConnection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, this::updateConnections);
        VirtualFileManager.getInstance().addVirtualFileListener(this.myVirtualFileListener);
        this.updateConnections();
    }

    public void stopListening() {
        if (this.myMessageBusConnection != null) {
            this.myMessageBusConnection.disconnect();
            this.myMessageBusConnection = null;
        }
        VirtualFileManager.getInstance().removeVirtualFileListener(this.myVirtualFileListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConnections() {
        Object object = this.myLock;
        synchronized (object) {
            this.myConnectionMapper = null;
        }
        PerforceManager manager = PerforceManager.getInstance(this.getProject());
        manager.configurationChanged();
    }

    @Override
    public boolean isUnderProjectConnections(@NotNull File file) {
        if (file == null) {
            PerforceConnectionManager.$$$reportNull$$$0(6);
        }
        Set<VirtualFile> allRoots = this.getConnectionMapper().getAllConnections().keySet();
        return ContainerUtil.or(allRoots, root -> {
            if (file == null) {
                PerforceConnectionManager.$$$reportNull$$$0(7);
            }
            return FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)file, (boolean)false);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionMapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConnections";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConnectionForFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUnderProjectConnections";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isUnderProjectConnections$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

