/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.index;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSInjectionController;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.frameworks.jquery.JQueryCssLanguage;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSIndexContentBuilder;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.css.CssAttribute;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.angularjs.codeInsight.attributes.AngularEventHandlerDescriptor;
import org.angularjs.html.Angular2HTMLLanguage;
import org.angularjs.index.AngularJSIndexingHandler;
import org.angularjs.lang.AngularJSLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJS2IndexingHandler
extends FrameworkIndexingHandler {
    public static final String TEMPLATE_REF = "TemplateRef";
    public static final String SELECTOR = "selector";
    public static final String NAME = "name";

    public void processCallExpression(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        JSExpression expression;
        if (outData == null) {
            AngularJS2IndexingHandler.$$$reportNull$$$0(0);
        }
        if ((expression = callExpression.getMethodExpression()) instanceof JSReferenceExpression) {
            String name = ((JSReferenceExpression)expression).getReferenceName();
            if (AngularJS2IndexingHandler.isDirective(name)) {
                AngularJS2IndexingHandler.addImplicitElement((PsiElement)callExpression, (JSElementIndexingDataImpl)outData, AngularJS2IndexingHandler.getPropertyName((PsiElement)callExpression, SELECTOR));
            }
            if (AngularJS2IndexingHandler.isPipe(name)) {
                AngularJS2IndexingHandler.addPipe((PsiElement)callExpression, (JSElementIndexingDataImpl)outData, AngularJS2IndexingHandler.getPropertyName((PsiElement)callExpression, NAME));
            }
            if (AngularJS2IndexingHandler.isModule(name)) {
                AngularJS2IndexingHandler.addImplicitElementToModules((PsiElement)callExpression, (JSElementIndexingDataImpl)outData, AngularJS2IndexingHandler.determineModuleName(callExpression));
            }
        }
    }

    public boolean shouldCreateStubForCallExpression(ASTNode node) {
        ASTNode name;
        ASTNode ref = node.getFirstChildNode();
        if (ref.getElementType() == JSTokenTypes.NEW_KEYWORD) {
            ref = TreeUtil.findSibling((ASTNode)ref, (IElementType)JSElementTypes.REFERENCE_EXPRESSION);
        }
        if (ref != null && (name = ref.getLastChildNode()) != null && name.getElementType() == JSTokenTypes.IDENTIFIER) {
            String referencedName = name.getText();
            return AngularJS2IndexingHandler.isDirective(referencedName) || AngularJS2IndexingHandler.isPipe(referencedName) || AngularJS2IndexingHandler.isModule(referencedName);
        }
        return false;
    }

    private static String determineModuleName(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            AngularJS2IndexingHandler.$$$reportNull$$$0(1);
        }
        if (!(callExpression.getParent() instanceof ES6Decorator)) {
            return null;
        }
        ES6Decorator decorator = (ES6Decorator)callExpression.getParent();
        PsiElement owner = decorator.getOwner();
        if (owner instanceof JSClass) {
            return ((JSClass)owner).getName();
        }
        return null;
    }

    private static void addImplicitElementToModules(PsiElement decorator, @NotNull JSElementIndexingDataImpl outData, String selector) {
        if (outData == null) {
            AngularJS2IndexingHandler.$$$reportNull$$$0(2);
        }
        if (selector == null) {
            return;
        }
        JSImplicitElementImpl.Builder elementBuilder = new JSImplicitElementImpl.Builder(selector, decorator).setUserString("ami");
        outData.addImplicitElement((JSImplicitElement)elementBuilder.toImplicitElement());
    }

    private static JSElementIndexingDataImpl addImplicitElement(PsiElement element, JSElementIndexingDataImpl outData, String selector) {
        JSImplicitElementImpl.Builder elementBuilder;
        if (selector == null) {
            return outData;
        }
        selector = selector.replace("\\n", "\n");
        MultiMap attributesToElements = MultiMap.createSet();
        PsiFile cssFile = PsiFileFactory.getInstance((Project)element.getProject()).createFileFromText((Language)JQueryCssLanguage.INSTANCE, (CharSequence)selector);
        CssSelectorList selectorList = (CssSelectorList)PsiTreeUtil.findChildOfType((PsiElement)cssFile, CssSelectorList.class);
        if (selectorList == null) {
            return outData;
        }
        for (CssSelector cssSelector : selectorList.getSelectors()) {
            for (CssSimpleSelector simpleSelector : cssSelector.getSimpleSelectors()) {
                String elementName = simpleSelector.getElementName();
                boolean seenAttribute = false;
                for (CssSelectorSuffix suffix : simpleSelector.getSelectorSuffixes()) {
                    if (!(suffix instanceof CssAttribute)) continue;
                    String name = ((CssAttribute)suffix).getAttributeName();
                    if (!StringUtil.isEmpty((String)name)) {
                        if (seenAttribute) {
                            name = "[" + name + "]";
                        }
                        attributesToElements.putValue((Object)name, (Object)elementName);
                    }
                    seenAttribute = true;
                }
                if (seenAttribute) continue;
                attributesToElements.putValue((Object)"", (Object)elementName);
            }
        }
        HashSet<String> added = new HashSet<String>();
        boolean template = AngularJS2IndexingHandler.isTemplate(element);
        for (String elementName : attributesToElements.get((Object)"")) {
            if (!added.add(elementName)) continue;
            elementBuilder = new JSImplicitElementImpl.Builder(elementName, element).setType(JSImplicitElement.Type.Class);
            if (!attributesToElements.containsKey((Object)elementName)) {
                elementBuilder.setTypeString("E;;;");
            } else {
                Collection elements = attributesToElements.get((Object)elementName);
                elementBuilder.setTypeString("AE;" + StringUtil.join((Collection)elements, (String)",") + ";;");
            }
            elementBuilder.setUserString("adi");
            if (outData == null) {
                outData = new JSElementIndexingDataImpl();
            }
            outData.addImplicitElement((JSImplicitElement)elementBuilder.toImplicitElement());
        }
        for (Map.Entry entry : attributesToElements.entrySet()) {
            String attributeName = (String)entry.getKey();
            if (attributeName.isEmpty() || !added.add(attributeName)) continue;
            if (outData == null) {
                outData = new JSElementIndexingDataImpl();
            }
            String elements = StringUtil.join((Collection)((Collection)entry.getValue()), (String)",");
            if (template && elements.isEmpty()) {
                elementBuilder = new JSImplicitElementImpl.Builder(attributeName, element).setType(JSImplicitElement.Type.Class).setTypeString("A;template,ng-template;;");
                elementBuilder.setUserString("adi");
                outData.addImplicitElement((JSImplicitElement)elementBuilder.toImplicitElement());
            }
            String prefix = template && !attributeName.startsWith("[") ? "*" : "";
            String attr = prefix + attributeName;
            elementBuilder = new JSImplicitElementImpl.Builder(attr, element).setType(JSImplicitElement.Type.Class).setTypeString("A;" + elements + ";;");
            elementBuilder.setUserString("adi");
            outData.addImplicitElement((JSImplicitElement)elementBuilder.toImplicitElement());
        }
        return outData;
    }

    private static void addPipe(PsiElement expression, @NotNull JSElementIndexingDataImpl outData, String pipe) {
        if (outData == null) {
            AngularJS2IndexingHandler.$$$reportNull$$$0(3);
        }
        if (pipe == null) {
            return;
        }
        JSImplicitElementImpl.Builder elementBuilder = new JSImplicitElementImpl.Builder(pipe, expression).setUserString("afi");
        outData.addImplicitElement((JSImplicitElement)elementBuilder.toImplicitElement());
    }

    private static boolean isTemplate(PsiElement decorator) {
        JSClass clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)decorator, JSClass.class);
        if (clazz != null) {
            JSFunction constructor = clazz.getConstructor();
            JSParameterList params = constructor != null ? constructor.getParameterList() : null;
            return params != null && params.getText().contains(TEMPLATE_REF);
        }
        JsonProperty property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)decorator, JsonProperty.class);
        if (property == null || !SELECTOR.equals(property.getName())) {
            return false;
        }
        if ((property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)property, JsonProperty.class)) == null || !"arguments".equals(property.getName())) {
            return false;
        }
        if ((property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)property, JsonProperty.class)) == null || !"decorators".equals(property.getName())) {
            return false;
        }
        PsiElement parent = property.getParent();
        if (parent instanceof JsonObject) {
            JsonProperty members = ((JsonObject)parent).findProperty("members");
            return members != null && members.getText().contains(TEMPLATE_REF);
        }
        return false;
    }

    @Nullable
    private static String getPropertyName(PsiElement decorator, String name) {
        JSExpression value;
        JSProperty selector = AngularJS2IndexingHandler.getProperty(decorator, name);
        JSExpression jSExpression = value = selector != null ? selector.getValue() : null;
        if (value instanceof JSBinaryExpression) {
            return JSInjectionController.getConcatenationText((PsiElement)value);
        }
        if (value instanceof JSLiteralExpression && ((JSLiteralExpression)value).isQuotedLiteral()) {
            return AngularJSIndexingHandler.unquote((PsiElement)value);
        }
        return null;
    }

    @Nullable
    public static JSProperty getSelector(PsiElement decorator) {
        return AngularJS2IndexingHandler.getProperty(decorator instanceof ES6Decorator ? PsiTreeUtil.findChildOfType((PsiElement)decorator, JSCallExpression.class) : decorator, SELECTOR);
    }

    @Nullable
    private static JSProperty getProperty(PsiElement decorator, String name) {
        JSExpression[] arguments;
        JSArgumentList argumentList = (JSArgumentList)PsiTreeUtil.getChildOfType((PsiElement)decorator, JSArgumentList.class);
        JSExpression[] jSExpressionArray = arguments = argumentList != null ? argumentList.getArguments() : null;
        if (arguments == null) {
            JSArrayLiteralExpression array = (JSArrayLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)decorator, JSArrayLiteralExpression.class);
            arguments = array != null ? array.getExpressions() : null;
        }
        JSObjectLiteralExpression descriptor = (JSObjectLiteralExpression)ObjectUtils.tryCast(arguments != null && arguments.length > 0 ? arguments[0] : null, JSObjectLiteralExpression.class);
        return descriptor != null ? descriptor.findProperty(name) : null;
    }

    public static boolean isDirective(@Nullable String name) {
        return "Directive".equals(name) || "DirectiveAnnotation".equals(name) || "Component".equals(name) || "ComponentAnnotation".equals(name);
    }

    public static boolean isModule(@Nullable String name) {
        return "NgModule".equals(name);
    }

    private static boolean isPipe(@Nullable String name) {
        return "Pipe".equals(name);
    }

    public void addContextType(JSTypeInfo info, PsiElement context) {
        JSQualifiedName directiveNamespace;
        if (context instanceof JSReferenceExpression && ((JSReferenceExpression)context).getQualifier() == null && (directiveNamespace = AngularJS2IndexingHandler.findDirective(context)) != null) {
            info.addType((JSNamespace)new JSNamespaceImpl(directiveNamespace, JSContext.INSTANCE, true), true);
        }
    }

    public void addContextNames(PsiElement context, List<String> names) {
        JSQualifiedName directiveNamespace;
        if (context instanceof JSReferenceExpression && ((JSReferenceExpression)context).getQualifier() == null && (directiveNamespace = AngularJS2IndexingHandler.findDirective(context)) != null) {
            names.add(directiveNamespace.getQualifiedName());
        }
    }

    @Nullable
    private static JSQualifiedName findDirective(PsiElement context) {
        JSClass clazz = AngularJS2IndexingHandler.findDirectiveClass(context);
        return clazz != null ? JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)clazz) : null;
    }

    @Nullable
    public static JSClass findDirectiveClass(PsiElement context) {
        PsiFile file = context.getContainingFile();
        if (file == null) {
            return null;
        }
        if (file.getLanguage().is((Language)Angular2HTMLLanguage.INSTANCE)) {
            return (JSClass)PsiTreeUtil.getParentOfType((PsiElement)InjectedLanguageManager.getInstance((Project)context.getProject()).getInjectionHost((PsiElement)file), JSClass.class);
        }
        if (file.getLanguage().is((Language)AngularJSLanguage.INSTANCE)) {
            PsiFile directiveFile;
            PsiElement original = CompletionUtil.getOriginalOrSelf((PsiElement)context);
            PsiFile hostFile = FileContextUtil.getContextFile((PsiElement)(original != context ? original : context.getContainingFile().getOriginalFile()));
            String name = hostFile != null ? hostFile.getVirtualFile().getNameWithoutExtension() : null;
            PsiDirectory dir = hostFile != null ? hostFile.getParent() : null;
            PsiFile psiFile = directiveFile = dir != null ? dir.findFile(name + ".ts") : null;
            if (directiveFile != null) {
                for (PsiElement element : directiveFile.getChildren()) {
                    if (!(element instanceof JSClass)) continue;
                    JSClass clazz = (JSClass)element;
                    JSAttributeList list = clazz.getAttributeList();
                    for (ES6Decorator decorator : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)list, ES6Decorator.class)) {
                        JSCallExpression call;
                        PsiElement[] decoratorChildren = decorator.getChildren();
                        if (decoratorChildren.length <= 0 || !(decoratorChildren[0] instanceof JSCallExpression) || !((call = (JSCallExpression)decoratorChildren[0]).getMethodExpression() instanceof JSReferenceExpression) || !AngularJS2IndexingHandler.isDirective(((JSReferenceExpression)call.getMethodExpression()).getReferenceName())) continue;
                        return clazz;
                    }
                }
            }
        }
        return null;
    }

    public boolean addTypeFromResolveResult(JSTypeEvaluator evaluator, PsiElement result, boolean hasSomeType) {
        List arguments;
        if (!(result instanceof JSImplicitElement) || !"$event".equals(((JSImplicitElement)result).getName())) {
            return false;
        }
        XmlAttribute parent = (XmlAttribute)ObjectUtils.tryCast((Object)result.getParent(), XmlAttribute.class);
        AngularEventHandlerDescriptor descriptor = (AngularEventHandlerDescriptor)((Object)ObjectUtils.tryCast((Object)(parent != null ? parent.getDescriptor() : null), AngularEventHandlerDescriptor.class));
        PsiElement declaration = descriptor != null ? descriptor.getDeclaration() : null;
        JSType type = null;
        if (declaration instanceof JSField) {
            type = ((JSField)declaration).getType();
        } else if (declaration instanceof JSFunction) {
            type = ((JSFunction)declaration).getReturnType();
        }
        type = JSTypeUtils.getValuableType((JSType)type);
        if (type instanceof JSGenericTypeImpl && (arguments = ((JSGenericTypeImpl)type).getArguments()).size() == 1) {
            evaluator.addType((JSType)arguments.get(0), declaration);
            return true;
        }
        return false;
    }

    public boolean canProcessCustomElement(@NotNull PsiElement element) {
        if (element == null) {
            AngularJS2IndexingHandler.$$$reportNull$$$0(4);
        }
        return element instanceof JsonProperty && element.getContainingFile().getName().endsWith(".metadata.json");
    }

    public boolean processCustomElement(@NotNull PsiElement customElement, @NotNull JSIndexContentBuilder builder) {
        JSElementIndexingDataImpl data;
        JsonValue value;
        if (customElement == null) {
            AngularJS2IndexingHandler.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            AngularJS2IndexingHandler.$$$reportNull$$$0(6);
        }
        if (customElement instanceof JsonProperty && SELECTOR.equals(((JsonProperty)customElement).getName()) && (value = ((JsonProperty)customElement).getValue()) instanceof JsonStringLiteral && (data = AngularJS2IndexingHandler.addImplicitElement((PsiElement)value, null, ((JsonStringLiteral)value).getValue())) != null && data.getImplicitElements() != null) {
            for (JSImplicitElement element : data.getImplicitElements()) {
                JSImplicitElementImpl.Builder elementBuilder = ((JSImplicitElementImpl)element).toBuilder().setProvider(null);
                JSImplicitElementsIndex.JSElementProxy proxy = new JSImplicitElementsIndex.JSElementProxy(elementBuilder, value.getTextRange().getStartOffset());
                builder.addImplicitElement(element.getName(), proxy);
            }
        }
        return true;
    }

    public int getVersion() {
        return 59;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "org/angularjs/index/AngularJS2IndexingHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processCallExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "determineModuleName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addImplicitElementToModules";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addPipe";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessCustomElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processCustomElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

