/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.taskdefs.Attribute;
import com.intellij.compiler.ant.taskdefs.Jar;
import com.intellij.compiler.ant.taskdefs.Manifest;
import com.intellij.compiler.ant.taskdefs.Property;
import com.intellij.compiler.ant.taskdefs.Target;
import com.intellij.compiler.ant.taskdefs.ZipFileSet;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.compiler.ant.J2MEBuildProperties;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class BuildJarTarget
extends Target {
    public BuildJarTarget(ModuleChunk chunk, GenerationOptions genOptions, MobileModuleSettings settings) {
        super(J2MEBuildProperties.getJarBuildTargetName(chunk.getName()), null, J2MEBundle.message("ant.jar.description", chunk.getName()), null);
        Module[] modules = chunk.getModules();
        Module module = modules[0];
        String moduleName = module.getName();
        MobileApplicationType mobileApplicationType = settings.getApplicationType();
        String destFile = GenerationUtils.toRelativePath((String)settings.getJarURL(), (ModuleChunk)chunk, (GenerationOptions)genOptions);
        String jarPathProperty = J2MEBuildProperties.getJarPathProperty();
        this.add((Generator)new Property(jarPathProperty, destFile));
        String jarPathPropertyRef = BuildProperties.propertyRef((String)jarPathProperty);
        Jar jarTag = new Jar(jarPathPropertyRef, "preserve");
        jarTag.add((Generator)new ZipFileSet(BuildProperties.propertyRef((String)BuildProperties.getTempDirForModuleProperty((String)moduleName)), "", true));
        this.createManifest(jarTag, settings, chunk, genOptions);
        this.add((Generator)jarTag);
        this.add((Generator)new Tag("length", new Pair[]{BuildJarTarget.pair((String)"file", (String)jarPathPropertyRef), BuildJarTarget.pair((String)"property", (String)J2MEBuildProperties.getJarSizeProperty())}));
        String jadProperty = J2MEBuildProperties.getExtensionPathProperty(mobileApplicationType);
        this.add((Generator)new Property(jadProperty, GenerationUtils.toRelativePath((String)settings.getMobileDescriptionPath(), (ModuleChunk)chunk, (GenerationOptions)genOptions)));
        this.add((Generator)new Tag("replaceregexp", new Pair[]{BuildJarTarget.pair((String)"file", (String)BuildProperties.propertyRef((String)jadProperty)), BuildJarTarget.pair((String)"match", (String)(mobileApplicationType.getJarSizeSettingName() + mobileApplicationType.getSeparator() + " .*")), BuildJarTarget.pair((String)"replace", (String)(mobileApplicationType.getJarSizeSettingName() + mobileApplicationType.getSeparator() + " " + BuildProperties.propertyRef((String)J2MEBuildProperties.getJarSizeProperty()))), BuildJarTarget.pair((String)"byline", (String)"true")}));
    }

    private void createManifest(Jar jarTag, MobileModuleSettings settings, ModuleChunk chunk, GenerationOptions genOptions) {
        File manifestFile;
        Manifest manifestTag = new Manifest();
        jarTag.add((Generator)manifestTag);
        String userManifestPath = settings.getUserManifestPath();
        if (settings.isUseUserManifest() && userManifestPath != null) {
            this.add((Generator)new Property(J2MEBuildProperties.getManifestPath(), GenerationUtils.toRelativePath((String)userManifestPath, (ModuleChunk)chunk, (GenerationOptions)genOptions)));
            manifestFile = new File(userManifestPath);
        } else {
            manifestFile = settings.getManifest();
        }
        Properties properties = new Properties();
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(FileUtil.loadFileBytes((File)manifestFile));
            properties.load(is);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            return;
        }
        manifestTag.applyAttributes(new java.util.jar.Manifest());
        for (Object key : properties.keySet()) {
            manifestTag.add((Generator)new Attribute((String)key, properties.getProperty((String)key)));
        }
    }
}

