/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.emulator.Emulator;
import com.intellij.j2meplugin.emulator.EmulatorType;
import com.intellij.j2meplugin.emulator.MobileSdk;
import com.intellij.j2meplugin.module.J2MEModuleType;
import com.intellij.j2meplugin.module.MobileModuleUtil;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.j2meplugin.module.settings.general.UserDefinedOption;
import com.intellij.j2meplugin.run.J2MERunnableState;
import com.intellij.j2meplugin.run.ui.J2MERunConfigurationEditor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class J2MERunConfiguration
extends LocatableConfigurationBase
implements ModuleRunProfile {
    public String TARGET_DEVICE_NAME;
    public String COMMAND_LINE_PARAMETERS;
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String VALUE = "value";
    private final Project myProject;
    private Module myModule;
    @NonNls
    private static final String USER_KEYS = "USER_OPTIONS";
    @NonNls
    private static final String OPTION = "option";
    @NonNls
    private static final String MODULE = "module";
    public String MAIN_CLASS_NAME = "";
    public String JAD_NAME = "";
    public boolean IS_CLASSES = false;
    public boolean IS_OTA = false;
    public String INSTALL;
    public String REMOVE;
    public String RUN;
    public String TRANSIENT;
    public String FORCE;
    public String TO_START;
    public int SELECTION;
    public ArrayList<UserDefinedOption> userParameters = new ArrayList();
    private String myModuleName;
    private static final Logger LOG = Logger.getInstance(J2MERunConfiguration.class);

    public J2MERunConfiguration(String name, Project project, ConfigurationFactory configurationFactory) {
        super(project, configurationFactory, name);
        this.myProject = project;
    }

    @Nullable
    public Module getModule() {
        if (this.myModule == null && this.myModuleName != null) {
            this.myModule = ModuleManager.getInstance((Project)this.getProject()).findModuleByName(this.myModuleName);
        }
        return this.myModule != null && !this.myModule.isDisposed() && ModuleType.get((Module)this.myModule).equals((Object)J2MEModuleType.getInstance()) ? this.myModule : null;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        Sdk jdk;
        if (executor == null) {
            J2MERunConfiguration.$$$reportNull$$$0(0);
        }
        if (env == null) {
            J2MERunConfiguration.$$$reportNull$$$0(1);
        }
        if (!MobileSdk.checkCorrectness(jdk = this.getProjectJdk(), this.getModule())) {
            return new J2MERunnableState(env.getRunnerSettings(), env.getConfigurationSettings(), this, this.getProject(), jdk);
        }
        EmulatorType emulatorType = ((Emulator)jdk.getSdkAdditionalData()).getEmulatorType();
        LOG.assertTrue(emulatorType != null);
        return emulatorType.getJ2MERunnableState(executor, env.getRunnerSettings(), env.getConfigurationSettings(), this, this.getProject(), jdk);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        J2MERunConfigurationEditor j2MERunConfigurationEditor = new J2MERunConfigurationEditor(this.getProject(), this);
        if (j2MERunConfigurationEditor == null) {
            J2MERunConfiguration.$$$reportNull$$$0(2);
        }
        return j2MERunConfigurationEditor;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        Element userOptions;
        if (element == null) {
            J2MERunConfiguration.$$$reportNull$$$0(3);
        }
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        Element module = element.getChild(MODULE);
        if (module != null) {
            this.myModuleName = module.getAttributeValue(NAME);
        }
        if ((userOptions = element.getChild(USER_KEYS)) != null) {
            this.userParameters.clear();
            for (Object o : userOptions.getChildren(OPTION)) {
                Element option = (Element)o;
                this.userParameters.add(new UserDefinedOption(option.getAttributeValue(NAME), option.getAttributeValue(VALUE)));
            }
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            J2MERunConfiguration.$$$reportNull$$$0(4);
        }
        Element moduleElement = new Element(MODULE);
        moduleElement.setAttribute(NAME, (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                Module module = J2MERunConfiguration.this.getModule();
                return module != null ? module.getName() : "";
            }
        }));
        element.addContent(moduleElement);
        Element userOptions = new Element(USER_KEYS);
        for (UserDefinedOption userParameter : this.userParameters) {
            Element userOption = new Element(OPTION);
            userOption.setAttribute(NAME, userParameter.getKey());
            userOption.setAttribute(VALUE, userParameter.getValue());
            userOptions.addContent(userOption);
        }
        element.addContent(userOptions);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
    }

    public String suggestedName() {
        if (StringUtil.isEmpty((String)this.MAIN_CLASS_NAME)) {
            return null;
        }
        return this.IS_CLASSES ? this.MAIN_CLASS_NAME : this.JAD_NAME;
    }

    public void setMainClassName(String qualifiedName) {
        boolean generatedName = this.isGeneratedName();
        this.MAIN_CLASS_NAME = qualifiedName;
        if (generatedName) {
            this.setGeneratedName();
        }
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        final Module module = this.getModule();
        if (module == null) {
            throw new RuntimeConfigurationException(J2MEBundle.message("run.configuration.module.not.specified", new Object[0]));
        }
        Sdk jdk = this.getProjectJdk();
        if (jdk == null) {
            throw new RuntimeConfigurationException(J2MEBundle.message("run.configuration.jdk.misconfigured", new Object[0]));
        }
        if (!MobileSdk.checkCorrectness(jdk, module)) {
            throw new RuntimeConfigurationException(J2MEBundle.message("compiler.jdk.is.invalid", jdk.getName(), ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return module.getName();
                }
            })));
        }
        EmulatorType emulatorType = ((Emulator)jdk.getSdkAdditionalData()).getEmulatorType();
        LOG.assertTrue(emulatorType != null);
        MobileApplicationType mobileApplicationType = MobileModuleUtil.getMobileApplicationTypeByName(emulatorType.getApplicationType());
        if (!this.IS_OTA) {
            if (this.IS_CLASSES) {
                if (this.MAIN_CLASS_NAME == null || this.MAIN_CLASS_NAME.trim().length() == 0) {
                    throw new RuntimeConfigurationWarning(J2MEBundle.message("run.configuration.no.class.specified", mobileApplicationType.getPresentableClassName()));
                }
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.MAIN_CLASS_NAME, GlobalSearchScope.moduleScope((Module)module));
                if (psiClass == null) {
                    throw new RuntimeConfigurationWarning(J2MEBundle.message("run.configuration.class.not.found", this.MAIN_CLASS_NAME, module.getName()));
                }
            } else {
                if (this.JAD_NAME == null || this.JAD_NAME.length() == 0) {
                    throw new RuntimeConfigurationException(J2MEBundle.message("run.configuration.no.file.specified", mobileApplicationType.getExtension()));
                }
                if (!this.JAD_NAME.endsWith(mobileApplicationType.getExtension())) {
                    throw new RuntimeConfigurationException(J2MEBundle.message("run.configuration.mistyped.descriptor", this.JAD_NAME, mobileApplicationType.getName()));
                }
            }
        } else if (this.TO_START == null || this.TO_START.length() == 0) {
            throw new RuntimeConfigurationException(J2MEBundle.message("run.configuration.no.file.specified", mobileApplicationType.getExtension()));
        }
    }

    public Sdk getProjectJdk() {
        Sdk jdk = null;
        if (this.getModule() != null) {
            jdk = ModuleRootManager.getInstance((Module)this.getModule()).getSdk();
        }
        return jdk;
    }

    @NotNull
    public Module[] getModules() {
        Module[] allModules;
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module module : allModules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            if (!ModuleType.get((Module)module).equals((Object)J2MEModuleType.getInstance())) continue;
            modules.add(module);
        }
        Module[] moduleArray = modules.toArray(new Module[modules.size()]);
        if (moduleArray == null) {
            J2MERunConfiguration.$$$reportNull$$$0(5);
        }
        return moduleArray;
    }

    public void setModule(Module module) {
        this.myModule = module;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/j2meplugin/run/J2MERunConfiguration";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/j2meplugin/run/J2MERunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

