/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.clientProperties.ClientPropertiesManager;
import com.intellij.uiDesigner.clientProperties.ConfigureClientPropertiesDialog;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.ReadOnlyProperty;
import com.intellij.uiDesigner.propertyInspector.properties.ClientPropertyProperty;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ClientPropertiesProperty
extends ReadOnlyProperty {
    private final Project myProject;
    private final PropertyRenderer myRenderer = new LabelPropertyRenderer(UIDesignerBundle.message("client.properties.configure", new Object[0]));
    private final PropertyEditor myEditor = new MyPropertyEditor();

    public static ClientPropertiesProperty getInstance(Project project) {
        return (ClientPropertiesProperty)ServiceManager.getService((Project)project, ClientPropertiesProperty.class);
    }

    public ClientPropertiesProperty(Project project) {
        super(null, "Client Properties");
        this.myProject = project;
    }

    @NotNull
    public PropertyRenderer getRenderer() {
        PropertyRenderer propertyRenderer = this.myRenderer;
        if (propertyRenderer == null) {
            ClientPropertiesProperty.$$$reportNull$$$0(0);
        }
        return propertyRenderer;
    }

    @Override
    public PropertyEditor getEditor() {
        return this.myEditor;
    }

    @Override
    @NotNull
    public Property[] getChildren(RadComponent component) {
        if (component == null) {
            if (EMPTY_ARRAY == null) {
                ClientPropertiesProperty.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }
        ClientPropertiesManager manager = ClientPropertiesManager.getInstance(component.getProject());
        List<ClientPropertiesManager.ClientProperty> props = manager.getClientProperties(component.getComponentClass());
        Property[] result = new Property[props.size()];
        for (int i = 0; i < props.size(); ++i) {
            result[i] = new ClientPropertyProperty(this, props.get(i).getName(), props.get(i).getValueClass());
        }
        if (result == null) {
            ClientPropertiesProperty.$$$reportNull$$$0(2);
        }
        return result;
    }

    @Override
    public boolean needRefreshPropertyList() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/uiDesigner/propertyInspector/properties/ClientPropertiesProperty";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MyPropertyEditor
    extends PropertyEditor {
        private final TextFieldWithBrowseButton myTf = new TextFieldWithBrowseButton();

        public MyPropertyEditor() {
            this.myTf.setText(UIDesignerBundle.message("client.properties.configure", new Object[0]));
            this.myTf.getTextField().setEditable(false);
            this.myTf.getTextField().setBorder(null);
            this.myTf.getTextField().setForeground(JBColor.foreground());
            this.myTf.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyPropertyEditor.this.showClientPropertiesDialog();
                }
            });
        }

        private void showClientPropertiesDialog() {
            ConfigureClientPropertiesDialog dlg = new ConfigureClientPropertiesDialog(ClientPropertiesProperty.this.myProject);
            dlg.show();
            if (dlg.getExitCode() == 0) {
                dlg.save();
                this.fireValueCommitted(true, false);
            }
        }

        public Object getValue() throws Exception {
            return null;
        }

        public JComponent getComponent(RadComponent component, Object value, InplaceContext inplaceContext) {
            return this.myTf;
        }

        @Override
        public void updateUI() {
            SwingUtilities.updateComponentTreeUI((Component)this.myTf);
        }
    }
}

