/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyConfigReader {
    private final Map<String, Map<String, PsiElement>> myEnvMap = new HashMap<String, Map<String, PsiElement>>();
    private final Map<String, PsiElement> myDefaultEnv = new HashMap<String, PsiElement>();
    private Map<String, PsiElement> myCurrentEnv = this.myDefaultEnv;
    private StringBuilder myCurrentPrefixes = new StringBuilder();

    private GroovyConfigReader() {
    }

    private void processStatements(@NotNull PsiElement root) {
        if (root == null) {
            GroovyConfigReader.$$$reportNull$$$0(0);
        }
        for (PsiElement e = root.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (e instanceof GrAssignmentExpression) {
                this.process((GrAssignmentExpression)e);
                continue;
            }
            if (!(e instanceof GrMethodCall)) continue;
            this.process((GrMethodCall)e);
        }
    }

    private void process(@NotNull GrAssignmentExpression assign) {
        if (assign == null) {
            GroovyConfigReader.$$$reportNull$$$0(1);
        }
        if (assign.isOperatorAssignment()) {
            return;
        }
        GrExpression value = assign.getLValue();
        if (!(value instanceof GrReferenceExpression)) {
            return;
        }
        int prefixSize = this.myCurrentPrefixes.length();
        if (GroovyConfigReader.appendPropertyName(this.myCurrentPrefixes, (GrReferenceExpression)value)) {
            this.myCurrentEnv.put(this.myCurrentPrefixes.toString(), (PsiElement)assign.getRValue());
        }
        this.myCurrentPrefixes.setLength(prefixSize);
    }

    private void process(@NotNull GrMethodCall call) {
        String methodName;
        if (call == null) {
            GroovyConfigReader.$$$reportNull$$$0(2);
        }
        if ((methodName = PsiUtil.getUnqualifiedMethodName((GrMethodCall)call)) == null) {
            return;
        }
        GrClosableBlock closure = GrailsUtils.getClosureArgument(call);
        if (closure == null) {
            return;
        }
        if (this.myCurrentEnv == this.myDefaultEnv && "environments".equals(methodName)) {
            for (PsiElement envClosureChild = closure.getFirstChild(); envClosureChild != null; envClosureChild = envClosureChild.getNextSibling()) {
                GrClosableBlock c;
                GrMethodCall mc;
                String envName;
                if (!(envClosureChild instanceof GrMethodCall) || (envName = PsiUtil.getUnqualifiedMethodName((GrMethodCall)(mc = (GrMethodCall)envClosureChild))) == null || (c = GrailsUtils.getClosureArgument(mc)) == null) continue;
                this.myCurrentEnv = this.myEnvMap.get(envName);
                if (this.myCurrentEnv == null) {
                    this.myCurrentEnv = new HashMap<String, PsiElement>();
                    this.myEnvMap.put(envName, this.myCurrentEnv);
                }
                this.processStatements((PsiElement)c);
                this.myCurrentEnv = this.myDefaultEnv;
            }
            return;
        }
        int prefixSize = this.myCurrentPrefixes.length();
        if (this.myCurrentPrefixes.length() > 0) {
            this.myCurrentPrefixes.append('.');
        }
        this.myCurrentPrefixes.append(methodName);
        this.processStatements((PsiElement)closure);
        this.myCurrentPrefixes.setLength(prefixSize);
    }

    private static boolean appendPropertyName(StringBuilder buf, GrReferenceExpression ref) {
        String refName;
        PsiElement nameElement;
        GrExpression qualifier = ref.getQualifierExpression();
        if (qualifier != null) {
            if (!(qualifier instanceof GrReferenceExpression)) {
                return false;
            }
            if (!GroovyConfigReader.appendPropertyName(buf, (GrReferenceExpression)qualifier)) {
                return false;
            }
        }
        if ((nameElement = ref.getReferenceNameElement()) instanceof GrLiteralImpl) {
            Object value = ((GrLiteralImpl)nameElement).getValue();
            if (!(value instanceof String)) {
                return false;
            }
            refName = (String)value;
        } else if (PsiImplUtil.isLeafElementOfType((PsiElement)nameElement, (IElementType)GroovyTokenTypes.mIDENT)) {
            refName = nameElement.getText();
        } else {
            return false;
        }
        if (buf.length() > 0) {
            buf.append('.');
        }
        buf.append(refName);
        return true;
    }

    public static GroovyConfigReader read(@NotNull GroovyFile groovyFile) {
        if (groovyFile == null) {
            GroovyConfigReader.$$$reportNull$$$0(3);
        }
        GroovyConfigReader res = new GroovyConfigReader();
        res.processStatements((PsiElement)groovyFile);
        return res;
    }

    public Set<String> getEnvironments() {
        return this.myEnvMap.keySet();
    }

    @Nullable
    public PsiElement getValue(@Nullable String environment, @NotNull String property) {
        PsiElement res;
        Map<String, PsiElement> map2;
        if (property == null) {
            GroovyConfigReader.$$$reportNull$$$0(4);
        }
        if (environment != null && (map2 = this.myEnvMap.get(environment)) != null && (res = map2.get(property)) != null) {
            return res;
        }
        return this.myDefaultEnv.get(property);
    }

    @Nullable
    public String getStringValue(@Nullable String environment, @NotNull String property) {
        PsiElement element;
        if (property == null) {
            GroovyConfigReader.$$$reportNull$$$0(5);
        }
        if ((element = this.getValue(environment, property)) == null) {
            return null;
        }
        if (element instanceof GrLiteralImpl) {
            Object value = ((GrLiteralImpl)element).getValue();
            if (value instanceof String) {
                return (String)value;
            }
            return null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assign";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groovyFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/config/GroovyConfigReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processStatements";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getStringValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

