/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.addins.js.JavaScriptIntegrationUtil;
import org.jetbrains.plugins.grails.lang.gsp.formatter.GspBlockGenerator;
import org.jetbrains.plugins.grails.lang.gsp.formatter.GspGroovyBlock;
import org.jetbrains.plugins.grails.lang.gsp.formatter.GspHtmlBlock;
import org.jetbrains.plugins.grails.lang.gsp.psi.GspPsiUtil;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.api.GspOuterGroovyElement;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspDeclarationTag;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspScriptletTag;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.directive.GspDirective;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspGrailsTag;

public class GspFormattingHelper {
    private final XmlFormattingPolicy myXmlFormattingPolicy;
    private final ASTNode myNode;
    private TextRange myTextRange;
    private Collection<PsiElement> myChildrenToSkip = new ArrayList<PsiElement>();

    public GspFormattingHelper(XmlFormattingPolicy policy, ASTNode node, TextRange textRange) {
        this.myNode = node;
        this.myXmlFormattingPolicy = policy;
        this.myTextRange = textRange;
    }

    public ASTNode processNonGspChild(ASTNode child, Indent indent, List<Block> result2, Wrap wrap, Alignment alignment) {
        Pair<PsiElement, Language> root = GspGroovyBlock.findPsiRootAt(child);
        if (root != null && child.getPsi() instanceof GspOuterGroovyElement) {
            this.createGspGroovyNode(result2, child, Indent.getNormalIndent());
            this.myTextRange = new TextRange(child.getTextRange().getEndOffset(), this.myTextRange.getEndOffset());
            return child.getTreeNext();
        }
        if (JavaScriptIntegrationUtil.isJavaScriptInjection(child.getPsi()) && this.myChildrenToSkip.size() == 0) {
            this.myChildrenToSkip = GspFormattingHelper.processJavascriptTagBody(child.getPsi());
            if (this.myChildrenToSkip.size() < 2) {
                GspBlockGenerator.createForeignLanguageBlock(JavaScriptSupportLoader.JAVASCRIPT.getLanguage(), child, result2, this.myXmlFormattingPolicy, this.myXmlFormattingPolicy.getSettings());
            } else {
                GspBlockGenerator.createGspBlockByChildNode(result2, this.myNode, child, wrap, alignment, this.myXmlFormattingPolicy);
            }
            this.myTextRange = new TextRange(child.getTextRange().getEndOffset(), this.myTextRange.getEndOffset());
        } else {
            XmlTag tag;
            int htmlTagOffset = this.calculatePossibleHtmlTagBegin(child);
            if (htmlTagOffset >= 0 && (tag = GspFormattingHelper.getHtmlTagByOffset(htmlTagOffset, child)) != null && this.myTextRange.contains(tag.getTextRange()) && this.doesNotIntersectSubTagsWith((PsiElement)tag) && GspFormattingHelper.isGoodTag(tag)) {
                ASTNode newChild;
                if (htmlTagOffset > this.myTextRange.getStartOffset()) {
                    TextRange trashRange = new TextRange(Math.max(child.getTextRange().getStartOffset(), this.myTextRange.getStartOffset()), htmlTagOffset);
                    GspBlockGenerator.createGspBlockByTextRange(result2, child, wrap, alignment, this.myXmlFormattingPolicy, trashRange);
                }
                XmlTag[] nestedGspTags = this.getSubTags();
                GspBlockGenerator.createHtmlBlockByChildNode(result2, this.myNode, tag.getNode(), wrap, alignment, this.myXmlFormattingPolicy, nestedGspTags);
                int tagEndOffset = tag.getTextRange().getEndOffset();
                if (tagEndOffset == this.myTextRange.getEndOffset()) {
                    this.myTextRange = new TextRange(tagEndOffset, tagEndOffset);
                    return child.getTreeNext();
                }
                this.myTextRange = new TextRange(tagEndOffset, this.myTextRange.getEndOffset());
                for (newChild = this.myNode.findLeafElementAt(tagEndOffset - this.myNode.getStartOffset()); newChild != null && newChild.getTreeParent() != this.myNode; newChild = newChild.getTreeParent()) {
                }
                return newChild;
            }
        }
        GspBlockGenerator.createGspBlockByTextRange(result2, child, wrap, alignment, this.myXmlFormattingPolicy, this.myTextRange.intersection(child.getTextRange()));
        this.myTextRange = new TextRange(child.getTextRange().getEndOffset(), this.myTextRange.getEndOffset());
        return child.getTreeNext();
    }

    private static ArrayList<PsiElement> processJavascriptTagBody(PsiElement child) {
        ArrayList<PsiElement> childrenToSkip = new ArrayList<PsiElement>();
        PsiElement parent = child.getParent();
        assert (parent instanceof GspGrailsTag);
        while (child != null) {
            if (JavaScriptIntegrationUtil.isJavaScriptInjection(child)) {
                childrenToSkip.add(child);
            }
            child = child.getNextSibling();
        }
        return childrenToSkip;
    }

    private static boolean isGoodTag(XmlTag tag) {
        for (PsiElement element : tag.getChildren()) {
            if (!(element instanceof PsiErrorElement)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static XmlTag getHtmlTagByOffset(int htmlTagOffset, ASTNode child) {
        FileViewProvider viewProvider = child.getPsi().getContainingFile().getViewProvider();
        PsiFile file = viewProvider.getPsi(StdLanguages.HTML);
        ASTNode found = file.getNode().findLeafElementAt(htmlTagOffset);
        if (found != null) {
            ASTNode foundTag = GspFormattingHelper.findTagParentWithTheSameOffset(found);
            if (foundTag == null) {
                return null;
            }
            PsiElement foundPsiElement = foundTag.getPsi();
            if (foundPsiElement instanceof XmlTag) {
                return (XmlTag)foundPsiElement;
            }
        }
        return null;
    }

    protected static ASTNode findTagParentWithTheSameOffset(ASTNode correspondingNode) {
        int offset = correspondingNode.getTextRange().getStartOffset();
        ASTNode result2 = correspondingNode;
        while (result2.getTreeParent() != null && result2.getTreeParent().getTextRange().getStartOffset() == offset) {
            if (result2.getTreeParent().getPsi() instanceof XmlTag) {
                return result2.getTreeParent();
            }
            result2 = result2.getTreeParent();
        }
        return result2;
    }

    private int calculatePossibleHtmlTagBegin(ASTNode child) {
        FileViewProvider viewProvider = child.getPsi().getContainingFile().getViewProvider();
        PsiFile file = viewProvider.getPsi(StdLanguages.HTML);
        assert (file != null);
        TextRange range = child.getTextRange();
        int curOffset = Math.max(range.getStartOffset(), this.myTextRange.getStartOffset());
        int endOffset = Math.min(range.getEndOffset(), this.myTextRange.getEndOffset());
        FileASTNode astNode = file.getNode();
        assert (astNode != null);
        ASTNode leaf = astNode.findLeafElementAt(curOffset);
        while (leaf != null && curOffset < endOffset && leaf.getElementType() != XmlTokenType.XML_START_TAG_START) {
            leaf = astNode.findLeafElementAt(++curOffset);
        }
        if (leaf == null) {
            return -1;
        }
        if (leaf.getElementType() == XmlTokenType.XML_START_TAG_START) {
            return curOffset;
        }
        return -1;
    }

    protected ASTNode processChild(List<Block> result2, ASTNode child, Wrap wrap, Alignment alignment, Indent indent) {
        PsiElement childPsi = child.getPsi();
        if (!this.myTextRange.intersectsStrict(child.getTextRange())) {
            return child.getTreeNext();
        }
        if (childPsi instanceof OuterLanguageElement) {
            return this.processNonGspChild(child, indent, result2, wrap, alignment);
        }
        GspBlockGenerator.createGspBlockByChildNode(result2, this.myNode, child, wrap, alignment, this.myXmlFormattingPolicy);
        this.myTextRange = new TextRange(child.getTextRange().getEndOffset(), this.myTextRange.getEndOffset());
        return child.getTreeNext();
    }

    protected void createGspGroovyNode(List<Block> localResult, ASTNode child, Indent indent) {
        localResult.add(new GspGroovyBlock(child, this.myXmlFormattingPolicy, GspGroovyBlock.findPsiRootAt(child), indent));
    }

    public static ASTNode findChildAfter(@NotNull ASTNode child, int endOffset) {
        FileElement fileNode;
        LeafElement leaf;
        if (child == null) {
            GspFormattingHelper.$$$reportNull$$$0(0);
        }
        if ((leaf = (fileNode = TreeUtil.getFileElement((TreeElement)((TreeElement)child))).findLeafElementAt(endOffset)) != null && leaf.getStartOffset() == endOffset && endOffset > 0) {
            return fileNode.findLeafElementAt(endOffset - 1);
        }
        return leaf;
    }

    public boolean doesNotIntersectSubTagsWith(PsiElement tag) {
        XmlTag[] subTags;
        TextRange tagRange = tag.getTextRange();
        for (XmlTag subTag : subTags = this.getSubTags()) {
            TextRange subTagRange = subTag.getTextRange();
            if (subTagRange.getEndOffset() < tagRange.getStartOffset()) continue;
            if (subTagRange.getStartOffset() > tagRange.getEndOffset()) {
                return true;
            }
            if (!GspHtmlBlock.areOvercrossing(subTagRange, tagRange)) continue;
            return false;
        }
        return true;
    }

    public static XmlTag[] collectSubTags(XmlElement node) {
        final ArrayList result2 = new ArrayList();
        node.processElements(new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof XmlTag) {
                    result2.add((XmlTag)element);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspFormattingHelper$1", "execute"));
            }
        }, (PsiElement)node);
        return result2.toArray(new XmlTag[result2.size()]);
    }

    public XmlTag[] getSubTags() {
        if (this.myNode instanceof XmlTag) {
            return ((XmlTag)this.myNode.getPsi()).getSubTags();
        }
        if (this.myNode.getPsi() instanceof XmlElement) {
            return GspFormattingHelper.collectSubTags((XmlElement)this.myNode.getPsi());
        }
        return XmlTag.EMPTY;
    }

    public boolean canBeAnotherTreeTagStart(ASTNode child) {
        boolean can = GspPsiUtil.getGspFile(this.myNode.getPsi()) != null && (GspFormattingHelper.isXmlTag(this.myNode) || this.myNode.getElementType() == XmlElementType.XML_DOCUMENT || this.myNode.getPsi() instanceof PsiFile) && child.getPsi() instanceof OuterLanguageElement;
        return can;
    }

    protected static boolean isXmlTag(ASTNode child) {
        return GspFormattingHelper.isXmlTag(child.getPsi());
    }

    protected static boolean isXmlTag(PsiElement psi) {
        return psi instanceof XmlTag && !(psi instanceof GspScriptletTag) && !(psi instanceof GspDirective) && !(psi instanceof GspDeclarationTag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspFormattingHelper", "findChildAfter"));
    }
}

