/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.util;

import com.intellij.lang.ASTNode;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.GspFileViewProvider;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspGrailsTag;
import org.jetbrains.plugins.grails.lang.gsp.psi.html.impl.GspHtmlFileImpl;

public class GspUtil {
    private GspUtil() {
    }

    @Nullable
    public static GspGrailsTag getContainingGrailsTag(PsiElement e) {
        FileViewProvider provider;
        PsiFile file;
        GspGrailsTag tag = null;
        if (e == null) {
            return null;
        }
        if (e.getTextOffset() >= 0 && (file = (provider = e.getContainingFile().getViewProvider()).getPsi(provider.getBaseLanguage())) instanceof GspFile) {
            int offset = e.getTextRange().getStartOffset();
            ASTNode node = file.getNode().findLeafElementAt(offset);
            if (node != null) {
                PsiElement start;
                for (start = node.getPsi(); start != null && !(start instanceof GspGrailsTag); start = start.getParent()) {
                }
                if (start != null) {
                    tag = (GspGrailsTag)start;
                }
            }
        }
        return tag;
    }

    @Nullable
    public static XmlTag getContainingHtmlTag(PsiElement e) {
        PsiFile file;
        FileViewProvider provider;
        XmlTag tag = null;
        if (e == null) {
            return null;
        }
        if (e.getTextOffset() >= 0 && (provider = e.getContainingFile().getViewProvider()) instanceof GspFileViewProvider && (file = provider.getPsi(((GspFileViewProvider)provider).getTemplateDataLanguage())) instanceof GspHtmlFileImpl) {
            int offset = e.getTextRange().getStartOffset();
            ASTNode node = file.getNode().findLeafElementAt(offset);
            if (node != null) {
                PsiElement start;
                for (start = node.getPsi(); start != null && !(start instanceof XmlTag); start = start.getParent()) {
                }
                if (start != null) {
                    tag = (XmlTag)start;
                }
            }
        }
        if (tag != null && tag.getTextRange().contains(e.getTextRange())) {
            return tag;
        }
        return null;
    }
}

