/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.perspectives.graph;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.settings.GraphSettingsProvider;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.PolyLineEdgeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.perspectives.DomainClassNodeRenderer;
import org.jetbrains.plugins.grails.perspectives.delete.RelationDeleteProvider;
import org.jetbrains.plugins.grails.perspectives.graph.DataModelAndSelectionModificationTracker;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassNode;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassRelationsInfo;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassesRelationsDataModel;

public class DomainClassDependencyPresentation
extends BasicGraphPresentationModel<DomainClassNode, DomainClassRelationsInfo> {
    private final DomainClassesRelationsDataModel myDataModel;
    private DomainClassNodeRenderer myNodeCellRenderer;

    public DomainClassDependencyPresentation(Graph graph, DomainClassesRelationsDataModel dataModel) {
        super(graph);
        this.myDataModel = dataModel;
        GraphSettings graphSettings = GraphSettingsProvider.getInstance((Project)this.myDataModel.getProject()).getSettings(graph);
        graphSettings.setCurrentLayouter((Layouter)graphSettings.getOrthogonalLayouter());
        GraphSettingsProvider.getInstance((Project)this.myDataModel.getProject()).getSettings(graph).setFitContentAfterLayout(true);
        this.setShowEdgeLabels(true);
    }

    @NotNull
    public NodeRealizer getNodeRealizer(DomainClassNode node) {
        if (this.myNodeCellRenderer == null) {
            GraphBuilder builder = this.getGraphBuilder();
            DataModelAndSelectionModificationTracker tracker = new DataModelAndSelectionModificationTracker(this.myDataModel.getProject());
            this.myNodeCellRenderer = new DomainClassNodeRenderer((GraphBuilder<DomainClassNode, DomainClassRelationsInfo>)builder, tracker, this.myDataModel);
        }
        NodeRealizer nodeRealizer = GraphViewUtil.createNodeRealizer((String)"DomainClassNodeRenderer", (NodeCellRenderer)this.myNodeCellRenderer);
        if (nodeRealizer == null) {
            DomainClassDependencyPresentation.$$$reportNull$$$0(0);
        }
        return nodeRealizer;
    }

    @NotNull
    public EdgeRealizer getEdgeRealizer(DomainClassRelationsInfo edge) {
        PolyLineEdgeRealizer edgeRealizer = GraphManager.getGraphManager().createPolyLineEdgeRealizer();
        edgeRealizer.setLineType(LineType.LINE_1);
        switch (edge.getRelation()) {
            case UNKNOWN: {
                edgeRealizer.setLineColor(JBColor.GREEN.darker());
                edgeRealizer.setTargetArrow(Arrow.STANDARD);
                edgeRealizer.setSourceArrow(Arrow.NONE);
                break;
            }
            case STRONG: {
                edgeRealizer.setLineColor(JBColor.CYAN.darker());
                edgeRealizer.setTargetArrow(Arrow.STANDARD);
                edgeRealizer.setSourceArrow(Arrow.NONE);
                break;
            }
            case BELONGS_TO: {
                edgeRealizer.setLineColor(JBColor.GREEN.darker());
                edgeRealizer.setTargetArrow(Arrow.STANDARD);
                edgeRealizer.setSourceArrow(Arrow.NONE);
                break;
            }
            case HAS_MANY: {
                edgeRealizer.setLineColor(JBColor.BLUE.darker());
                edgeRealizer.setTargetArrow(Arrow.STANDARD);
                edgeRealizer.setSourceArrow(Arrow.NONE);
                break;
            }
            default: {
                edgeRealizer.setLineType(LineType.LINE_1);
                edgeRealizer.setLineColor((Color)JBColor.GRAY);
                edgeRealizer.setArrow(Arrow.STANDARD);
            }
        }
        PolyLineEdgeRealizer polyLineEdgeRealizer = edgeRealizer;
        if (polyLineEdgeRealizer == null) {
            DomainClassDependencyPresentation.$$$reportNull$$$0(1);
        }
        return polyLineEdgeRealizer;
    }

    public String getEdgeTooltip(DomainClassRelationsInfo edge) {
        return edge.getEdgeLabel();
    }

    public void customizeSettings(Graph2DView view, EditMode editMode) {
        editMode.allowEdgeCreation(true);
        editMode.allowBendCreation(false);
        view.setFitContentOnResize(true);
    }

    public boolean editNode(DomainClassNode domainClassNode) {
        domainClassNode.getTypeDefinition().navigate(true);
        return true;
    }

    public DeleteProvider getDeleteProvider() {
        return new RelationDeleteProvider(this.myDataModel.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/grails/perspectives/graph/DomainClassDependencyPresentation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeRealizer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeRealizer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

