/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.codeInspection.MultipleRepositoryUrlsInspection;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class MultipleRepositoryUrlsFix
extends GroovyFix {
    private final GrClosableBlock myClosure;
    private final String myRepoType;

    public MultipleRepositoryUrlsFix(@NotNull GrClosableBlock closure, @NotNull String repoType) {
        if (closure == null) {
            MultipleRepositoryUrlsFix.$$$reportNull$$$0(0);
        }
        if (repoType == null) {
            MultipleRepositoryUrlsFix.$$$reportNull$$$0(1);
        }
        this.myClosure = closure;
        this.myRepoType = repoType;
    }

    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        List<GrCallExpression> statements;
        if (project == null) {
            MultipleRepositoryUrlsFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            MultipleRepositoryUrlsFix.$$$reportNull$$$0(3);
        }
        if ((statements = MultipleRepositoryUrlsInspection.findUrlCallExpressions(this.myClosure)).size() <= 1) {
            return;
        }
        statements.remove(0);
        ArrayList<GrCallExpression> elements = new ArrayList<GrCallExpression>(statements);
        for (GrCallExpression statement : statements) {
            PsiElement newLineCandidate = statement.getNextSibling();
            if (!PsiUtil.isNewLine((PsiElement)newLineCandidate)) continue;
            elements.add((GrCallExpression)newLineCandidate);
        }
        this.myClosure.removeElements(elements.toArray(new PsiElement[elements.size()]));
        GrClosableBlock closableBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)this.myClosure, GrClosableBlock.class);
        if (closableBlock == null) {
            return;
        }
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance((Project)project);
        for (GrCallExpression statement : statements) {
            closableBlock.addStatementBefore(elementFactory.createStatementFromText((CharSequence)(this.myRepoType + '{' + statement.getText() + '}')), null);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = GradleInspectionBundle.message("multiple.repository.urls.fix.name", new Object[0]);
        if (string == null) {
            MultipleRepositoryUrlsFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/codeInspection/MultipleRepositoryUrlsFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/codeInspection/MultipleRepositoryUrlsFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

